/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.log.Trace;

public class CommonTest
extends TestCase {
    protected static final int TEST_SOCKET_PORT = 12345;
    protected static final String TMP_OUTPUT_FILE = "Common_test.out";
    protected static final String TMP_ROOT = System.getProperty("tests.tmp.dir") != null ? System.getProperty("tests.tmp.dir") : (System.getProperty("java.io.tmpdir") != null ? System.getProperty("java.io.tmpdir") : "/tmp");
    protected static final String GENERATED_TMP_OUTPUT_FILE = TMP_ROOT + "/Module_DEBUG";
    protected static final String GENERATED_METHOD_TMP_OUTPUT_FILE = TMP_ROOT + "/Module.method_FATAL";
    protected File tmpOutput;
    protected File generatedTmpOutput;
    protected File generatedMethodTmpOutput;
    protected String[] expectedDebugResults = new String[]{"] [DEBUG] Module: module debug", "] [FATAL] Module: module fatal", "] [DEBUG] Module.method(): module with method name", "] [DEBUG] Module.method(arg): module with method name and arg"};
    protected String[] expectedFatalResults = new String[]{"] [FATAL] Module: module fatal"};
    protected String[] expectedDefaultResults = new String[]{"] [DEBUG] Module2: output to default"};
    static /* synthetic */ Class class$org$jgroups$tests$CommonTest;

    public static Test suite() {
        return new TestSuite(class$org$jgroups$tests$CommonTest == null ? (class$org$jgroups$tests$CommonTest = CommonTest.class$("org.jgroups.tests.CommonTest")) : class$org$jgroups$tests$CommonTest);
    }

    public void setUp() {
        this.tmpOutput = new File(TMP_OUTPUT_FILE);
        this.generatedTmpOutput = new File(GENERATED_TMP_OUTPUT_FILE);
        this.generatedMethodTmpOutput = new File(GENERATED_METHOD_TMP_OUTPUT_FILE);
        Trace.closeAllOutputs();
        Trace.restoreDefaultOutput();
        Trace.setDefaultOutput(0, System.out);
        this.deleteTempFiles();
    }

    public void tearDown() {
        Trace.closeAllOutputs();
        this.deleteTempFiles();
    }

    protected void deleteTempFiles() {
        if (this.tmpOutput.exists()) {
            this.tmpOutput.delete();
        }
        if (this.generatedTmpOutput.exists()) {
            this.generatedTmpOutput.delete();
        }
        if (this.generatedMethodTmpOutput.exists()) {
            this.generatedMethodTmpOutput.delete();
        }
    }

    public CommonTest(String name) {
        super(name);
    }

    public void testInnerClasses() {
        try {
            Trace.setOutput("FD", 0, TMP_OUTPUT_FILE);
            Trace.println("FD.PingThread.run()", 3, "thread terminated");
            Trace.println("FD.setProperties()", 5, "property timeout not recognized");
            Trace.closeAllOutputs();
            String[] expectedResults = new String[]{"] [WARN] FD.PingThread.run(): thread terminated", "] [FATAL] FD.setProperties(): property timeout not recognized"};
            this.compareOutputs(TMP_OUTPUT_FILE, expectedResults);
        }
        catch (IOException e) {
            CommonTest.fail((String)("testInnerClasses: exception " + e + " thrown"));
        }
    }

    public void testBogusModuleName() {
        try {
            Trace.setOutput("method()", 0, TMP_OUTPUT_FILE);
            Trace.closeDefaultOutput();
            this.sendTestMessages();
            Trace.closeOutput("method()");
            File f = new File(TMP_OUTPUT_FILE);
            CommonTest.assertTrue((String)"testBogusModuleName: file should never be created", (!f.exists() ? 1 : 0) != 0);
        }
        catch (IOException e) {
            CommonTest.fail((String)("testBogusModuleName: exception " + e + " thrown"));
        }
    }

    public void testNullDefaultOutputOK() {
        Trace.closeDefaultOutput();
        Trace.println("Module", 0, "nowhere to go");
    }

    public void testChangeDefaultOutput() {
        try {
            Trace.setDefaultOutput(TMP_OUTPUT_FILE);
            this.sendTestMessages();
            Trace.restoreDefaultOutput();
            this.compareOutputs(TMP_OUTPUT_FILE, this.expectedDebugResults);
        }
        catch (Exception e) {
            Thread.dumpStack();
            CommonTest.fail((String)("testChangeDefaultOutput: exception " + e + " thrown"));
        }
    }

    public void testDefaultOutput() {
        try {
            PrintStream origSystemOut = System.out;
            PrintStream newSystemOut = new PrintStream(new FileOutputStream(TMP_OUTPUT_FILE));
            System.setOut(newSystemOut);
            Trace.println("Module2", 0, "output to default");
            System.setOut(origSystemOut);
            newSystemOut.flush();
            newSystemOut.close();
            this.compareOutputs(TMP_OUTPUT_FILE, this.expectedDefaultResults);
        }
        catch (Exception e) {
            CommonTest.fail((String)("testDefaultOutput: exception " + e + " thrown"));
        }
    }

    public void testDefaultWithLevel() {
        try {
            Trace.setDefaultOutput(5, TMP_OUTPUT_FILE);
            this.sendTestMessages();
            Trace.closeDefaultOutput();
            this.compareOutputs(TMP_OUTPUT_FILE, this.expectedFatalResults);
        }
        catch (IOException e) {
            CommonTest.fail((String)("testDefaultWithLevel: exception " + e + " thrown"));
        }
    }

    public void testDebugFileOutput() {
        this._testFileOutput(0, this.expectedDebugResults);
    }

    public void testFatalFileOutput() {
        this._testFileOutput(5, this.expectedFatalResults);
    }

    protected void _testFileOutput(int level, String[] expectedResults) {
        try {
            Trace.setOutput("Module", level, TMP_OUTPUT_FILE);
            this.sendTestMessages();
            Trace.closeOutput("Module");
            this.compareOutputs(TMP_OUTPUT_FILE, expectedResults);
        }
        catch (Exception e) {
            CommonTest.fail((String)("exception " + e + " thrown"));
        }
    }

    public void testStreamOutput() {
        try {
            PrintStream origSystemErr = System.err;
            System.setErr(new PrintStream(new FileOutputStream(TMP_OUTPUT_FILE)));
            Trace.setOutput("Module", 0, System.err);
            this.sendTestMessages();
            System.setErr(origSystemErr);
            Trace.closeOutput("Module");
            this.compareOutputs(TMP_OUTPUT_FILE, this.expectedDebugResults);
        }
        catch (Exception e) {
            CommonTest.fail((String)("exception " + e + " thrown"));
        }
    }

    public void testSocketOutput() {
        try {
            final ServerSocket serverSocket = new ServerSocket(0);
            int port = serverSocket.getLocalPort();
            new Thread(new Runnable(){

                public void run() {
                    try {
                        int numBytesRead;
                        Socket listener = serverSocket.accept();
                        byte[] buf = new byte[1024];
                        StringBuffer lineBuffer = new StringBuffer();
                        do {
                            numBytesRead = listener.getInputStream().read(buf);
                            lineBuffer.append(new String(buf, 0, numBytesRead));
                        } while (buf[numBytesRead - 1] != 10);
                        listener.close();
                        serverSocket.close();
                        String line = lineBuffer.toString();
                        int endOfDate = line.indexOf(93);
                        Assert.assertEquals((String)"] [DEBUG] Module: socket message\n", (String)line.substring(endOfDate));
                    }
                    catch (Exception e) {
                        Assert.fail((String)("exception " + e + " thrown"));
                    }
                }
            }).start();
            Trace.setOutput("Module", 0, InetAddress.getLocalHost(), port);
            Trace.println("Module", 0, "socket message");
        }
        catch (Exception e) {
            CommonTest.fail((String)("exception " + e + " thrown"));
        }
    }

    protected void sendTestMessages() {
        Trace.println("Module", 0, "module debug");
        Trace.println("Module", 5, "module fatal");
        Trace.println("Module.method()", 0, "module with method name");
        Trace.println("Module.method(arg)", 0, "module with method name and arg");
    }

    protected void compareOutputs(String outputFileName, String[] expectedResults) throws FileNotFoundException, IOException {
        BufferedReader in = new BufferedReader(new FileReader(outputFileName));
        String input = null;
        for (int i = 0; i < expectedResults.length; ++i) {
            input = in.readLine();
            CommonTest.assertNotNull((String)("unexpected EOF in module output; expected to see <" + expectedResults[i] + ">"), (Object)input);
            int endOfDate = input.indexOf(93);
            CommonTest.assertTrue((String)("compareOutputs: malformed output string (no brackets): '" + input + "'"), (endOfDate != -1 ? 1 : 0) != 0);
            CommonTest.assertEquals((String)expectedResults[i], (String)input.substring(endOfDate));
        }
        input = in.readLine();
        CommonTest.assertNull((String)("trace output has too much output; saw <" + input + ">"), (Object)input);
    }

    public void testFileNameGeneration() {
        try {
            Trace.setOutput("Module", 0, TMP_ROOT);
            Trace.setOutput("Module.method()", 5, TMP_ROOT);
            CommonTest.assertTrue((boolean)this.generatedTmpOutput.exists());
            CommonTest.assertTrue((boolean)this.generatedMethodTmpOutput.exists());
            Trace.closeOutput("Module");
            Trace.closeOutput("Module.method()");
            CommonTest.assertTrue((boolean)this.generatedTmpOutput.exists());
            CommonTest.assertTrue((boolean)this.generatedMethodTmpOutput.exists());
        }
        catch (IOException e) {
            CommonTest.fail((String)("testFileNameGeneration threw exception " + e));
        }
    }

    public void testAppend() {
        try {
            Trace.setOutput("Module", 0, TMP_OUTPUT_FILE);
            Trace.println("Module", 0, "double the fun");
            this.sendTestMessages();
            Trace.closeOutput("Module");
            Trace.setOutput("Module", 0, TMP_OUTPUT_FILE);
            this.sendTestMessages();
            Trace.closeOutput("Module");
            String[] doubleExpected = new String[this.expectedDebugResults.length * 2 + 1];
            doubleExpected[0] = "] [DEBUG] Module: double the fun";
            System.arraycopy(this.expectedDebugResults, 0, doubleExpected, 1, this.expectedDebugResults.length);
            System.arraycopy(this.expectedDebugResults, 0, doubleExpected, this.expectedDebugResults.length, this.expectedDebugResults.length);
            for (int i = 0; i < this.expectedDebugResults.length; ++i) {
                String string = this.expectedDebugResults[i];
                doubleExpected[i + this.expectedDebugResults.length + 1] = string;
                doubleExpected[i + 1] = string;
            }
            this.compareOutputs(TMP_OUTPUT_FILE, doubleExpected);
        }
        catch (IOException e) {
            CommonTest.fail((String)("testAppend threw exception " + e));
        }
    }

    public void testOpenTwoCloseOne() {
        try {
            Trace.setOutput("Module", 0, TMP_OUTPUT_FILE);
            Trace.setOutput("AnotherModule", 0, TMP_OUTPUT_FILE);
            this.sendTestMessages();
            Trace.closeOutput("Module");
            this.compareOutputs(TMP_OUTPUT_FILE, this.expectedDebugResults);
            Trace.println("AnotherModule", 0, "more output");
            Trace.closeOutput("AnotherModule");
            String[] expected = new String[this.expectedDebugResults.length + 1];
            System.arraycopy(this.expectedDebugResults, 0, expected, 0, this.expectedDebugResults.length);
            expected[this.expectedDebugResults.length] = "] [DEBUG] AnotherModule: more output";
            this.compareOutputs(TMP_OUTPUT_FILE, expected);
        }
        catch (IOException e) {
            CommonTest.fail((String)("testOpenTwoCloseOne threw exception " + e));
        }
    }

    public static void main(String[] args) {
        TestRunner.run((Test)CommonTest.suite());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

