/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.Event;
import org.jgroups.JChannel;
import org.jgroups.UpHandler;
import org.jgroups.log.Trace;
import org.jgroups.protocols.PingRsp;
import org.jgroups.util.Util;

public class Ping
implements UpHandler {
    Channel channel = null;
    boolean print_all_events = false;

    public Ping(String props, boolean trace, boolean printall) throws Exception {
        this.print_all_events = printall;
        if (trace) {
            Trace.init();
        }
        this.channel = new JChannel(props);
        this.channel.setUpHandler(this);
    }

    public void go(String groupname) {
        try {
            this.channel.connect(groupname);
            Trace.setIdentifier(this.channel.getLocalAddress().toString());
            this.channel.down(new Event(12));
        }
        catch (Exception e) {
            System.err.println("Ping.go(): " + e);
            System.exit(1);
        }
    }

    public void up(Event evt) {
        if (evt.getType() == 13) {
            Vector v = (Vector)evt.getArg();
            System.out.println("Found " + v.size() + " members");
            for (int i = 0; i < v.size(); ++i) {
                PingRsp rsp = (PingRsp)v.elementAt(i);
                System.out.println("Rsp #" + (i + 1) + ": " + rsp);
            }
            if (v.size() > 0) {
                Ping.verifyCoordinator(v);
            }
            System.exit(1);
        } else if (this.print_all_events) {
            System.out.println(">> " + evt);
        }
    }

    static void verifyCoordinator(Vector rsps) {
        Hashtable votes = new Hashtable();
        for (int i = 0; i < rsps.size(); ++i) {
            PingRsp rsp = (PingRsp)rsps.elementAt(i);
            Address coord = rsp.getCoordAddress();
            Address mbr = rsp.getAddress();
            Vector<Address> v = (Vector<Address>)votes.get(coord);
            if (v == null) {
                v = new Vector<Address>();
                votes.put(coord, v);
            }
            if (v.contains(mbr)) continue;
            v.addElement(mbr);
        }
        System.out.println("");
        if (votes.size() > 1) {
            System.err.println("*** Found more than 1 coordinator !");
        }
        Ping.printVotes(votes);
    }

    static void printVotes(Hashtable votes) {
        Enumeration e = votes.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            Vector val = (Vector)votes.get(key);
            System.out.println("\n\nCoord: " + key);
            System.out.println("Votes: " + val + "\n");
        }
    }

    public static void main(String[] args) {
        Ping ping = null;
        boolean trace = false;
        String groupname = Util.shortName(Util.getHostname());
        boolean printall = false;
        String props = "UDP(mcast_addr=224.0.0.200;mcast_port=7500;ip_ttl=0;ucast_send_buf_size=30000;ucast_recv_buf_size=60000):PING(timeout=5000;num_initial_members=30)";
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-help")) {
                Ping.usage();
                return;
            }
            if (args[i].equals("-trace")) {
                trace = true;
                continue;
            }
            if (args[i].equals("-printall")) {
                printall = true;
                continue;
            }
            if (args[i].equals("-group")) {
                groupname = args[++i];
                continue;
            }
            if (args[i].equals("-props")) {
                props = args[++i];
                continue;
            }
            Ping.usage();
            return;
        }
        try {
            ping = new Ping(props, trace, printall);
            ping.go(groupname);
        }
        catch (Exception e) {
            System.err.println("Ping.main(): " + e);
            System.exit(0);
        }
    }

    static void usage() {
        System.out.println("Ping [-help] [-trace] [-group <groupname>] [-props <properties>] [-printall]");
    }
}

