/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.DataInputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.StringTokenizer;

public class UcastTest {
    public static void main(String[] args) {
        byte[] buf = new byte[]{};
        boolean receiver = true;
        InetAddress receiver_addr = null;
        InetAddress sender_addr = null;
        int receiver_port = 0;
        int sender_port = 0;
        for (int i = 0; i < args.length; ++i) {
            String val = args[i];
            if (val.equals("-help")) {
                UcastTest.help();
                return;
            }
            if (val.equals("-sender")) {
                receiver = false;
                continue;
            }
            if (val.equals("-sender_addr")) {
                try {
                    sender_addr = InetAddress.getByName(args[++i]);
                    sender_port = Integer.parseInt(args[++i]);
                    continue;
                }
                catch (Exception e) {
                    System.err.println(e);
                    UcastTest.help();
                    return;
                }
            }
            if (val.equals("-receiver")) {
                receiver = true;
                try {
                    receiver_addr = InetAddress.getByName(args[++i]);
                    receiver_port = Integer.parseInt(args[++i]);
                    continue;
                }
                catch (Exception e) {
                    System.err.println(e);
                    UcastTest.help();
                    return;
                }
            }
            UcastTest.help();
        }
        try {
            if (receiver) {
                DatagramSocket sock = new DatagramSocket(receiver_port, receiver_addr);
                System.out.println("Socket=" + sock.getLocalAddress() + ":" + sock.getLocalPort());
                System.out.println("starting as receiver");
                UcastTest.receiverLoop(sock);
            } else {
                DatagramSocket sock = sender_addr != null && sender_port > 0 ? new DatagramSocket(sender_port, sender_addr) : new DatagramSocket();
                System.out.println("Socket=" + sock.getLocalAddress() + ":" + sock.getLocalPort());
                System.out.println("starting as sender");
                UcastTest.senderLoop(sock);
            }
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    static void receiverLoop(DatagramSocket sock) {
        while (true) {
            byte[] buf = new byte[256];
            DatagramPacket packet = new DatagramPacket(buf, buf.length);
            try {
                sock.receive(packet);
                System.out.println("Receive packet from " + packet.getAddress().getHostAddress() + ":" + packet.getPort() + ": " + new String(packet.getData()));
                buf = "ACK".getBytes();
                packet = new DatagramPacket(buf, buf.length, packet.getAddress(), packet.getPort());
                sock.send(packet);
            }
            catch (Exception e) {
                System.err.println(e);
                return;
            }
        }
    }

    static void senderLoop(DatagramSocket sock) {
        AckReceiver ack_receiver = new AckReceiver(sock);
        ack_receiver.start();
        DataInputStream in = new DataInputStream(System.in);
        try {
            while (true) {
                int dst_port;
                InetAddress dst;
                System.out.print("> ");
                String line = in.readLine();
                if (line.startsWith("quit") || line.startsWith("exit")) break;
                StringTokenizer tok = new StringTokenizer(line);
                try {
                    dst = InetAddress.getByName(tok.nextToken());
                    dst_port = Integer.parseInt(tok.nextToken());
                }
                catch (Exception e) {
                    System.err.println(e);
                    continue;
                }
                StringBuffer sb = new StringBuffer();
                while (tok.hasMoreTokens()) {
                    String tmp = tok.nextToken();
                    sb.append(tmp + " ");
                }
                String buf = sb.toString();
                System.out.println("sending " + buf);
                byte[] bbuf = buf.getBytes();
                DatagramPacket packet = new DatagramPacket(bbuf, bbuf.length, dst, dst_port);
                sock.send(packet);
            }
        }
        catch (Exception e) {
            System.err.println(e);
        }
        ack_receiver.stop();
    }

    static void help() {
        System.out.println("UcastTest [-help] [-sender | -receiver <local addr> <local port>] [-sender_addr <sender's bind address> <sender' port>]");
    }

    private static class AckReceiver
    implements Runnable {
        DatagramSocket sock;
        DatagramPacket packet;
        byte[] buf;
        Thread t = null;

        AckReceiver(DatagramSocket sock) {
            this.sock = sock;
        }

        public void run() {
            while (this.t != null) {
                try {
                    this.buf = new byte[256];
                    this.packet = new DatagramPacket(this.buf, this.buf.length);
                    this.sock.receive(this.packet);
                    System.out.println("<< Received packet from " + this.packet.getAddress().getHostAddress() + ":" + this.packet.getPort() + ": " + new String(this.packet.getData()));
                }
                catch (Exception e) {
                    System.err.println(e);
                    break;
                }
            }
            this.t = null;
        }

        void start() {
            this.t = new Thread((Runnable)this, "UcastTest.AckReceiver thread");
            this.t.start();
        }

        void stop() {
            if (this.t != null && this.t.isAlive()) {
                this.t = null;
                try {
                    this.sock.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

