/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests.adapt;

import org.apache.log4j.Logger;
import org.jgroups.Channel;
import org.jgroups.ChannelClosedException;
import org.jgroups.ChannelNotConnectedException;
import org.jgroups.Message;

public class SenderThread
extends Thread {
    private Channel channel;
    private long msgs_burst;
    private long sleep_msec;
    private int num_bursts;
    private int msg_size;
    Logger log = Logger.getLogger(this.getClass());
    long log_interval = 1000L;
    boolean gnuplot_output = Boolean.getBoolean("gnuplot_output");

    public SenderThread(Channel ch, long mb, long st, int nb, int ms, long log_interval) {
        this.channel = ch;
        this.msgs_burst = mb;
        this.sleep_msec = st;
        this.num_bursts = nb;
        this.msg_size = ms;
        this.log_interval = log_interval;
    }

    public void run() {
        long total_msgs = 0L;
        System.out.println("Sender thread started...");
        try {
            byte[] msg = new byte[this.msg_size];
            for (int h = 0; h < this.msg_size; ++h) {
                msg[h] = (byte)h;
            }
            for (int i = 0; i < this.num_bursts; ++i) {
                int j = 0;
                while ((long)j < this.msgs_burst) {
                    Message jg_msg = new Message(null, null, msg);
                    this.channel.send(jg_msg);
                    if (++total_msgs % 100L == 0L) {
                        System.out.println("++ sent " + total_msgs);
                    }
                    if (total_msgs % this.log_interval == 0L && !this.gnuplot_output) {
                        this.log.info((Object)this.dumpStats(total_msgs));
                    }
                    ++j;
                }
                SenderThread.sleep(this.sleep_msec);
            }
            System.out.println("Sent all bursts. Sender terminates.\n");
        }
        catch (ChannelNotConnectedException e) {
            e.printStackTrace();
        }
        catch (ChannelClosedException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    String dumpStats(long sent_msgs) {
        StringBuffer sb = new StringBuffer();
        sb.append("\nmsgs_sent=").append(sent_msgs).append("\n");
        sb.append("free_mem=").append(Runtime.getRuntime().freeMemory());
        sb.append(" (total_mem=").append(Runtime.getRuntime().totalMemory()).append(")\n");
        return sb.toString();
    }
}

