/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.ViewId;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Streamable;
import org.jgroups.util.Util;

public class SEQUENCER
extends Protocol {
    private Address local_addr = null;
    private Address coord = null;
    static final String name = "SEQUENCER";
    private boolean is_coord = false;
    private long seqno = 0L;
    private final Map forward_table = new TreeMap();
    private final ConcurrentHashMap received_table = new ConcurrentHashMap();
    private long forwarded_msgs = 0L;
    private long bcast_msgs = 0L;
    private long received_forwards = 0L;
    private long received_bcasts = 0L;
    static /* synthetic */ Class class$org$jgroups$ViewId;

    public boolean isCoordinator() {
        return this.is_coord;
    }

    public Address getCoordinator() {
        return this.coord;
    }

    public Address getLocalAddress() {
        return this.local_addr;
    }

    public String getName() {
        return name;
    }

    public long getForwarded() {
        return this.forwarded_msgs;
    }

    public long getBroadcast() {
        return this.bcast_msgs;
    }

    public long getReceivedForwards() {
        return this.received_forwards;
    }

    public long getReceivedBroadcasts() {
        return this.received_bcasts;
    }

    public void resetStats() {
        this.received_bcasts = 0L;
        this.received_forwards = 0L;
        this.bcast_msgs = 0L;
        this.forwarded_msgs = 0L;
    }

    public Map dumpStats() {
        HashMap<String, Long> m = super.dumpStats();
        if (m == null) {
            m = new HashMap<String, Long>();
        }
        m.put("forwarded", new Long(this.forwarded_msgs));
        m.put("broadcast", new Long(this.bcast_msgs));
        m.put("received_forwards", new Long(this.received_forwards));
        m.put("received_bcasts", new Long(this.received_bcasts));
        return m;
    }

    public String printStats() {
        return this.dumpStats().toString();
    }

    public boolean setProperties(Properties props) {
        super.setProperties(props);
        if (props.size() > 0) {
            this.log.error((Object)("the following properties are not recognized: " + props));
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final long nextSeqno() {
        SEQUENCER sEQUENCER = this;
        synchronized (sEQUENCER) {
            return this.seqno++;
        }
    }

    public void down(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                Address dest = msg.getDest();
                if (dest != null && !dest.isMulticastAddress()) break;
                long next_seqno = this.nextSeqno();
                SequencerHeader hdr = new SequencerHeader(1, this.local_addr, next_seqno);
                msg.putHeader(name, hdr);
                if (!this.is_coord) {
                    this.forwardToCoord(msg, next_seqno);
                } else {
                    this.broadcast(msg);
                }
                return;
            }
            case 6: {
                this.handleViewChange((View)evt.getArg());
            }
        }
        this.passDown(evt);
    }

    public void up(Event evt) {
        switch (evt.getType()) {
            case 8: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 1: {
                Message msg = (Message)evt.getArg();
                SequencerHeader hdr = (SequencerHeader)msg.getHeader(name);
                if (hdr == null) break;
                switch (hdr.type) {
                    case 1: {
                        if (!this.is_coord) {
                            if (this.log.isErrorEnabled()) {
                                this.log.warn((Object)("I (" + this.local_addr + ") am not the coord and don't handle " + "FORWARD requests, ignoring request"));
                            }
                            return;
                        }
                        this.broadcast(msg);
                        ++this.received_forwards;
                        return;
                    }
                    case 2: {
                        this.deliver(msg, hdr);
                        ++this.received_bcasts;
                        return;
                    }
                }
                break;
            }
            case 6: {
                this.handleViewChange((View)evt.getArg());
            }
        }
        this.passUp(evt);
    }

    private void handleViewChange(View v) {
        boolean coord_changed;
        Vector members = v.getMembers();
        if (members.size() == 0) {
            return;
        }
        Address prev_coord = this.coord;
        this.coord = (Address)members.firstElement();
        this.is_coord = this.local_addr != null && this.local_addr.equals(this.coord);
        boolean bl = coord_changed = prev_coord != null && !prev_coord.equals(this.coord);
        if (coord_changed) {
            this.resendMessagesInForwardTable();
        }
        int size = this.received_table.size();
        Set keys = this.received_table.keySet();
        keys.retainAll(members);
        if (keys.size() != size && this.trace) {
            this.log.trace((Object)("adjusted received_table, keys are " + keys));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resendMessagesInForwardTable() {
        Map map = this.forward_table;
        synchronized (map) {
            Iterator it = this.forward_table.values().iterator();
            while (it.hasNext()) {
                Message msg = (Message)it.next();
                msg.setDest(this.coord);
                this.passDown(new Event(1, msg));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forwardToCoord(Message msg, long seqno) {
        msg.setDest(this.coord);
        Map map = this.forward_table;
        synchronized (map) {
            this.forward_table.put(new Long(seqno), msg);
        }
        this.passDown(new Event(1, msg));
        ++this.forwarded_msgs;
    }

    private void broadcast(Message msg) {
        SequencerHeader hdr = (SequencerHeader)msg.getHeader(name);
        hdr.type = (byte)2;
        msg.setDest(null);
        msg.setSrc(this.local_addr);
        this.passDown(new Event(1, msg));
        ++this.bcast_msgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliver(Message msg, SequencerHeader hdr) {
        Long highest_seqno_seen;
        Address original_sender = hdr.getOriginalSender();
        if (original_sender == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"original sender is null, cannot swap sender address back to original sender");
            }
            return;
        }
        long msg_seqno = hdr.getSeqno();
        if (original_sender.equals(this.local_addr)) {
            Map map = this.forward_table;
            synchronized (map) {
                this.forward_table.remove(new Long(msg_seqno));
            }
        }
        if ((highest_seqno_seen = (Long)this.received_table.get((Object)original_sender)) != null && highest_seqno_seen >= msg_seqno) {
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)("message seqno (" + original_sender + "::" + msg_seqno + " has already " + "been received (highest received=" + highest_seqno_seen + "); discarding duplicate message"));
            }
            return;
        }
        this.received_table.put((Object)original_sender, (Object)new Long(msg_seqno));
        Message tmp = msg.copy(true);
        tmp.setSrc(original_sender);
        this.passUp(new Event(1, tmp));
    }

    public static class SequencerHeader
    extends Header
    implements Streamable {
        static final byte FORWARD = 1;
        static final byte BCAST = 2;
        byte type = (byte)-1;
        ViewId tag = null;

        public SequencerHeader() {
        }

        public SequencerHeader(byte type, Address original_sender, long seqno) {
            this.type = type;
            this.tag = new ViewId(original_sender, seqno);
        }

        public Address getOriginalSender() {
            return this.tag != null ? this.tag.getCoordAddress() : null;
        }

        public long getSeqno() {
            return this.tag != null ? this.tag.getId() : -1L;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(64);
            sb.append(this.printType());
            if (this.tag != null) {
                sb.append(" (tag=").append(this.tag).append(")");
            }
            return sb.toString();
        }

        private final String printType() {
            switch (this.type) {
                case 1: {
                    return "FORWARD";
                }
                case 2: {
                    return "BCAST";
                }
            }
            return "n/a";
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeByte(this.type);
            out.writeObject(this.tag);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = in.readByte();
            this.tag = (ViewId)in.readObject();
        }

        public void writeTo(DataOutputStream out) throws IOException {
            out.writeByte(this.type);
            Util.writeStreamable(this.tag, out);
        }

        public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
            this.type = in.readByte();
            this.tag = (ViewId)Util.readStreamable(class$org$jgroups$ViewId == null ? (class$org$jgroups$ViewId = SEQUENCER.class$("org.jgroups.ViewId")) : class$org$jgroups$ViewId, in);
        }

        public long size() {
            long size = 2L;
            if (this.tag != null) {
                size += (long)this.tag.serializedSize();
            }
            return size;
        }
    }
}

