/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.pbcast;

import EDU.oswego.cs.dl.util.concurrent.ReentrantLock;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.TimeoutException;
import org.jgroups.View;
import org.jgroups.ViewId;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Promise;
import org.jgroups.util.Streamable;
import org.jgroups.util.Util;

public class FLUSH
extends Protocol {
    public static final String NAME = "FLUSH";
    private View currentView;
    private Address localAddress;
    private Address flushCoordinator;
    private final Collection flushMembers;
    private final Set flushOkSet;
    private final Set flushCompletedSet;
    private final Set stopFlushOkSet;
    private final Set suspected;
    private final Object sharedLock = new Object();
    private final Object blockMutex = new Object();
    private boolean isBlockingFlushDown = true;
    private long timeout = 8000L;
    private long block_timeout = 10000L;
    private boolean receivedFirstView = false;
    private boolean receivedMoreThanOneView = false;
    private long startFlushTime;
    private long totalTimeInFlush;
    private int numberOfFlushes;
    private double averageFlushDuration;
    private final Promise flush_promise = new Promise();
    private final Promise blockok_promise = new Promise();
    private final FlushPhase flushPhase = new FlushPhase();
    private boolean auto_flush_conf = true;

    public FLUSH() {
        this.currentView = new View(new ViewId(), new Vector());
        this.flushOkSet = new TreeSet();
        this.flushCompletedSet = new TreeSet();
        this.stopFlushOkSet = new TreeSet();
        this.flushMembers = new ArrayList();
        this.suspected = new TreeSet();
    }

    public String getName() {
        return NAME;
    }

    public boolean setProperties(Properties props) {
        super.setProperties(props);
        this.timeout = Util.parseLong(props, "timeout", this.timeout);
        this.block_timeout = Util.parseLong(props, "block_timeout", this.block_timeout);
        this.auto_flush_conf = Util.parseBoolean(props, "auto_flush_conf", this.auto_flush_conf);
        if (props.size() > 0) {
            this.log.error((Object)("the following properties are not recognized: " + props));
            return false;
        }
        return true;
    }

    public void init() throws Exception {
        if (this.auto_flush_conf) {
            HashMap<String, Long> map = new HashMap<String, Long>();
            map.put("flush_timeout", new Long(this.timeout));
            this.passUp(new Event(56, map));
            this.passDown(new Event(56, map));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("flush_supported", Boolean.TRUE);
        this.passUp(new Event(56, map));
        this.passDown(new Event(56, map));
        Object object = this.sharedLock;
        synchronized (object) {
            this.receivedFirstView = false;
            this.receivedMoreThanOneView = false;
        }
        object = this.blockMutex;
        synchronized (object) {
            this.isBlockingFlushDown = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.sharedLock;
        synchronized (object) {
            this.currentView = new View(new ViewId(), new Vector());
            this.flushCompletedSet.clear();
            this.flushOkSet.clear();
            this.stopFlushOkSet.clear();
            this.flushMembers.clear();
            this.suspected.clear();
            this.flushCoordinator = null;
        }
    }

    public double getAverageFlushDuration() {
        return this.averageFlushDuration;
    }

    public long getTotalTimeInFlush() {
        return this.totalTimeInFlush;
    }

    public int getNumberOfFlushes() {
        return this.numberOfFlushes;
    }

    public boolean startFlush(long timeout) {
        boolean successfulFlush = false;
        this.down(new Event(68));
        this.flush_promise.reset();
        try {
            this.flush_promise.getResultWithTimeout(timeout);
            successfulFlush = true;
        }
        catch (TimeoutException e) {
            // empty catch block
        }
        return successfulFlush;
    }

    public void stopFlush() {
        this.down(new Event(70));
    }

    public void down(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                FlushHeader fh = (FlushHeader)msg.removeHeader(this.getName());
                if (fh != null && fh.type == 6) break;
                this.blockMessageDuringFlush();
                break;
            }
            case 19: {
                this.blockMessageDuringFlush();
                break;
            }
            case 2: {
                boolean successfulBlock = this.sendBlockUpToChannel(this.block_timeout);
                if (!successfulBlock || !this.log.isDebugEnabled()) break;
                this.log.debug((Object)("Blocking of channel " + this.localAddress + " completed successfully"));
                break;
            }
            case 68: {
                this.attemptSuspend(evt);
                return;
            }
            case 70: {
                this.onResume();
                return;
            }
            case 11: {
                this.blockok_promise.setResult(Boolean.TRUE);
                return;
            }
        }
        this.passDown(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void blockMessageDuringFlush() {
        boolean shouldSuspendByItself = false;
        long start = 0L;
        long stop = 0L;
        Object object = this.blockMutex;
        synchronized (object) {
            while (this.isBlockingFlushDown) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("FLUSH block at " + this.localAddress + " for " + (this.timeout <= 0L ? "ever" : this.timeout + "ms")));
                }
                try {
                    start = System.currentTimeMillis();
                    if (this.timeout <= 0L) {
                        this.blockMutex.wait();
                    } else {
                        this.blockMutex.wait(this.timeout);
                    }
                    stop = System.currentTimeMillis();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (!this.isBlockingFlushDown) continue;
                this.isBlockingFlushDown = false;
                shouldSuspendByItself = true;
                this.blockMutex.notifyAll();
            }
        }
        if (shouldSuspendByItself) {
            this.log.warn((Object)("unblocking FLUSH.down() at " + this.localAddress + " after timeout of " + (stop - start) + "ms"));
            this.passUp(new Event(69));
            this.passDown(new Event(69));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void up(Event evt) {
        Message msg = null;
        switch (evt.getType()) {
            case 1: {
                msg = (Message)evt.getArg();
                FlushHeader fh = (FlushHeader)msg.removeHeader(this.getName());
                if (fh == null) break;
                this.flushPhase.lock();
                if (fh.type == 0) {
                    if (!this.flushPhase.isFlushInProgress()) {
                        this.flushPhase.setFirstPhase(true);
                        this.flushPhase.release();
                        boolean successfulBlock = this.sendBlockUpToChannel(this.block_timeout);
                        if (successfulBlock && this.log.isDebugEnabled()) {
                            this.log.debug((Object)("Blocking of channel " + this.localAddress + " completed successfully"));
                        }
                        this.onStartFlush(msg.getSrc(), fh);
                    } else if (this.flushPhase.isInFirstPhase()) {
                        this.flushPhase.release();
                        Address flushRequester = msg.getSrc();
                        Address coordinator = null;
                        Object object = this.sharedLock;
                        synchronized (object) {
                            coordinator = this.flushCoordinator;
                        }
                        if (flushRequester.compareTo(coordinator) < 0) {
                            this.rejectFlush(fh.viewID, coordinator);
                            if (this.log.isDebugEnabled()) {
                                this.log.debug((Object)("Rejecting flush at " + this.localAddress + " to current flush coordinator " + coordinator + " and switching flush coordinator to " + flushRequester));
                            }
                            object = this.sharedLock;
                            synchronized (object) {
                                this.flushCoordinator = flushRequester;
                            }
                        } else {
                            this.rejectFlush(fh.viewID, flushRequester);
                            if (this.log.isDebugEnabled()) {
                                this.log.debug((Object)("Rejecting flush at " + this.localAddress + " to flush requester " + flushRequester));
                            }
                        }
                    } else if (this.flushPhase.isInSecondPhase()) {
                        this.flushPhase.release();
                        Address flushRequester = msg.getSrc();
                        this.rejectFlush(fh.viewID, flushRequester);
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("Rejecting flush in second phase at " + this.localAddress + " to flush requester " + flushRequester));
                        }
                    }
                } else if (fh.type == 2) {
                    this.flushPhase.setPhases(false, true);
                    this.flushPhase.release();
                    this.onStopFlush();
                } else if (fh.type == 5) {
                    this.flushPhase.release();
                    this.passUp(new Event(76));
                    this.passDown(new Event(76));
                } else if (this.isCurrentFlushMessage(fh)) {
                    this.flushPhase.release();
                    if (fh.type == 1) {
                        this.onFlushOk(msg.getSrc(), fh.viewID);
                    } else if (fh.type == 4) {
                        this.onStopFlushOk(msg.getSrc(), fh.viewID);
                    } else if (fh.type == 3) {
                        this.onFlushCompleted(msg.getSrc());
                    }
                } else {
                    this.flushPhase.release();
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)(this.localAddress + " received outdated FLUSH message " + fh + ",ignoring it."));
                    }
                }
                return;
            }
            case 6: {
                boolean singletonMember;
                View newView = (View)evt.getArg();
                boolean firstView = this.onViewChange(newView);
                boolean bl = singletonMember = newView.size() == 1 && newView.containsMember(this.localAddress);
                if (!firstView || !singletonMember) break;
                this.passUp(evt);
                Object object = this.blockMutex;
                synchronized (object) {
                    this.isBlockingFlushDown = false;
                    this.blockMutex.notifyAll();
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("At " + this.localAddress + " unblocking FLUSH.down() and sending UNBLOCK up"));
                }
                this.passUp(new Event(75));
                return;
            }
            case 8: {
                Object object = this.sharedLock;
                synchronized (object) {
                    this.localAddress = (Address)evt.getArg();
                    break;
                }
            }
            case 9: {
                this.onSuspect((Address)evt.getArg());
                break;
            }
            case 68: {
                this.attemptSuspend(evt);
                return;
            }
            case 70: {
                this.onResume();
                return;
            }
        }
        this.passUp(evt);
    }

    public Vector providedDownServices() {
        Vector<Integer> retval = new Vector<Integer>(2);
        retval.addElement(new Integer(68));
        retval.addElement(new Integer(70));
        return retval;
    }

    private void attemptSuspend(Event evt) {
        View v = (View)evt.getArg();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Received SUSPEND at " + this.localAddress + ", view is " + v));
        }
        this.flushPhase.lock();
        if (!this.flushPhase.isFlushInProgress()) {
            this.flushPhase.release();
            this.onSuspend(v);
        } else {
            this.flushPhase.release();
            this.passUp(new Event(76));
            this.passDown(new Event(76));
        }
    }

    private void rejectFlush(long viewId, Address flushRequester) {
        Message reject = new Message(flushRequester);
        reject.putHeader(this.getName(), new FlushHeader(5, viewId));
        this.passDown(new Event(1, reject));
    }

    private boolean sendBlockUpToChannel(long btimeout) {
        boolean successfulBlock = false;
        this.blockok_promise.reset();
        new Thread(Util.getGlobalThreadGroup(), new Runnable(){

            public void run() {
                FLUSH.this.passUp(new Event(10));
            }
        }, "FLUSH block").start();
        try {
            this.blockok_promise.getResultWithTimeout(btimeout);
            successfulBlock = true;
        }
        catch (TimeoutException e) {
            this.log.warn((Object)("Blocking of channel using BLOCK event timed out after " + btimeout + " msec."));
        }
        return successfulBlock;
    }

    private boolean isCurrentFlushMessage(FlushHeader fh) {
        return fh.viewID == this.currentViewId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long currentViewId() {
        long viewId = -1L;
        Object object = this.sharedLock;
        synchronized (object) {
            ViewId view = this.currentView.getVid();
            if (view != null) {
                viewId = view.getId();
            }
        }
        return viewId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean onViewChange(View view) {
        boolean amINewCoordinator = false;
        boolean isThisOurFirstView = false;
        Object object = this.sharedLock;
        synchronized (object) {
            if (this.receivedFirstView) {
                this.receivedMoreThanOneView = true;
            }
            if (!this.receivedFirstView) {
                this.receivedFirstView = true;
            }
            isThisOurFirstView = this.receivedFirstView && !this.receivedMoreThanOneView;
            this.suspected.retainAll(view.getMembers());
            this.currentView = view;
            amINewCoordinator = this.flushCoordinator != null && !view.getMembers().contains(this.flushCoordinator) && this.localAddress.equals(view.getMembers().get(0));
        }
        if (amINewCoordinator) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Coordinator left, " + this.localAddress + " will complete flush"));
            }
            this.onResume();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Installing view at  " + this.localAddress + " view is " + view));
        }
        return isThisOurFirstView;
    }

    private void onStopFlush() {
        if (this.stats) {
            long stopFlushTime = System.currentTimeMillis();
            this.totalTimeInFlush += stopFlushTime - this.startFlushTime;
            if (this.numberOfFlushes > 0) {
                this.averageFlushDuration = (double)this.totalTimeInFlush / (double)this.numberOfFlushes;
            }
        }
        Message msg = new Message(null);
        msg.putHeader(this.getName(), new FlushHeader(4, this.currentViewId()));
        this.passDown(new Event(1, msg));
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Received STOP_FLUSH and sent STOP_FLUSH_OK from " + this.localAddress));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onSuspend(View view) {
        Message msg = null;
        ArrayList participantsInFlush = null;
        Object object = this.sharedLock;
        synchronized (object) {
            if (view != null) {
                participantsInFlush = new ArrayList(view.getMembers());
                participantsInFlush.retainAll(this.currentView.getMembers());
            } else {
                participantsInFlush = new ArrayList(this.currentView.getMembers());
            }
            msg = new Message(null);
            msg.putHeader(this.getName(), new FlushHeader(0, this.currentViewId(), participantsInFlush));
        }
        if (participantsInFlush.isEmpty()) {
            this.passUp(new Event(69));
            this.passDown(new Event(69));
        } else {
            this.passDown(new Event(1, msg));
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Received SUSPEND at " + this.localAddress + ", sent START_FLUSH to " + participantsInFlush));
            }
        }
    }

    private void onResume() {
        long viewID = this.currentViewId();
        Message msg = new Message(null);
        msg.putHeader(this.getName(), new FlushHeader(2, viewID));
        this.passDown(new Event(1, msg));
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Received RESUME at " + this.localAddress + ", sent STOP_FLUSH to all"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onStartFlush(Address flushStarter, FlushHeader fh) {
        if (this.stats) {
            this.startFlushTime = System.currentTimeMillis();
            ++this.numberOfFlushes;
        }
        Object object = this.sharedLock;
        synchronized (object) {
            this.flushCoordinator = flushStarter;
            this.flushMembers.clear();
            if (fh.flushParticipants != null) {
                this.flushMembers.addAll(fh.flushParticipants);
            }
            this.flushMembers.removeAll(this.suspected);
        }
        Message msg = new Message(null);
        msg.putHeader(this.getName(), new FlushHeader(1, fh.viewID));
        this.passDown(new Event(1, msg));
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Received START_FLUSH at " + this.localAddress + " responded with FLUSH_OK"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onFlushOk(Address address, long viewID) {
        boolean flushOkCompleted = false;
        Message m = null;
        Object object = this.sharedLock;
        synchronized (object) {
            this.flushOkSet.add(address);
            flushOkCompleted = this.flushOkSet.containsAll(this.flushMembers);
            if (flushOkCompleted) {
                m = new Message(this.flushCoordinator);
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("At " + this.localAddress + " FLUSH_OK from " + address + ",completed " + flushOkCompleted + ",  flushOkSet " + this.flushOkSet.toString()));
        }
        if (flushOkCompleted) {
            object = this.blockMutex;
            synchronized (object) {
                this.isBlockingFlushDown = true;
            }
            m.putHeader(this.getName(), new FlushHeader(3, viewID));
            this.passDown(new Event(1, m));
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)(this.localAddress + " is blocking FLUSH.down(). Sent FLUSH_COMPLETED message to " + this.flushCoordinator));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onStopFlushOk(Address address, long viewID) {
        boolean stopFlushOkCompleted = false;
        Object object = this.sharedLock;
        synchronized (object) {
            this.stopFlushOkSet.add(address);
            TreeSet membersCopy = new TreeSet(this.currentView.getMembers());
            membersCopy.removeAll(this.suspected);
            stopFlushOkCompleted = this.stopFlushOkSet.containsAll(membersCopy);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("At " + this.localAddress + " STOP_FLUSH_OK from " + address + ",completed " + stopFlushOkCompleted + ",  stopFlushOkSet " + this.stopFlushOkSet.toString()));
        }
        if (stopFlushOkCompleted) {
            object = this.sharedLock;
            synchronized (object) {
                this.flushCompletedSet.clear();
                this.flushOkSet.clear();
                this.stopFlushOkSet.clear();
                this.flushMembers.clear();
                this.suspected.clear();
                this.flushCoordinator = null;
            }
            this.flushPhase.lock();
            this.flushPhase.setSecondPhase(false);
            this.flushPhase.release();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("At " + this.localAddress + " unblocking FLUSH.down() and sending UNBLOCK up"));
            }
            object = this.blockMutex;
            synchronized (object) {
                this.isBlockingFlushDown = false;
                this.blockMutex.notifyAll();
            }
            this.passUp(new Event(75));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onFlushCompleted(Address address) {
        boolean flushCompleted = false;
        Object object = this.sharedLock;
        synchronized (object) {
            this.flushCompletedSet.add(address);
            flushCompleted = this.flushCompletedSet.containsAll(this.flushMembers);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("At " + this.localAddress + " FLUSH_COMPLETED from " + address + ",completed " + flushCompleted + ",flushCompleted " + this.flushCompletedSet.toString()));
        }
        if (flushCompleted) {
            this.flush_promise.setResult(Boolean.TRUE);
            this.passUp(new Event(69));
            this.passDown(new Event(69));
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("All FLUSH_COMPLETED received at " + this.localAddress + " sent SUSPEND_OK down/up"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onSuspect(Address address) {
        boolean flushOkCompleted = false;
        Message m = null;
        long viewID = 0L;
        Object object = this.sharedLock;
        synchronized (object) {
            this.suspected.add(address);
            this.flushMembers.removeAll(this.suspected);
            viewID = this.currentViewId();
            boolean bl = flushOkCompleted = !this.flushOkSet.isEmpty() && this.flushOkSet.containsAll(this.flushMembers);
            if (flushOkCompleted) {
                m = new Message(this.flushCoordinator);
            }
        }
        if (flushOkCompleted) {
            m.putHeader(this.getName(), new FlushHeader(3, viewID));
            this.passDown(new Event(1, m));
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)(this.localAddress + " sent FLUSH_COMPLETED message to " + this.flushCoordinator));
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Suspect is " + address + ",completed " + flushOkCompleted + ",  flushOkSet " + this.flushOkSet + " flushMembers " + this.flushMembers));
        }
    }

    public static class FlushHeader
    extends Header
    implements Streamable {
        public static final byte START_FLUSH = 0;
        public static final byte FLUSH_OK = 1;
        public static final byte STOP_FLUSH = 2;
        public static final byte FLUSH_COMPLETED = 3;
        public static final byte STOP_FLUSH_OK = 4;
        public static final byte ABORT_FLUSH = 5;
        public static final byte FLUSH_BYPASS = 6;
        byte type;
        long viewID;
        Collection flushParticipants;

        public FlushHeader() {
            this(0, 0L);
        }

        public FlushHeader(byte type) {
            this(type, 0L);
        }

        public FlushHeader(byte type, long viewID) {
            this(type, viewID, null);
        }

        public FlushHeader(byte type, long viewID, Collection flushView) {
            this.type = type;
            this.viewID = viewID;
            this.flushParticipants = flushView;
        }

        public String toString() {
            switch (this.type) {
                case 0: {
                    return "FLUSH[type=START_FLUSH,viewId=" + this.viewID + ",members=" + this.flushParticipants + "]";
                }
                case 1: {
                    return "FLUSH[type=FLUSH_OK,viewId=" + this.viewID + "]";
                }
                case 2: {
                    return "FLUSH[type=STOP_FLUSH,viewId=" + this.viewID + "]";
                }
                case 4: {
                    return "FLUSH[type=STOP_FLUSH_OK,viewId=" + this.viewID + "]";
                }
                case 5: {
                    return "FLUSH[type=ABORT_FLUSH,viewId=" + this.viewID + "]";
                }
                case 3: {
                    return "FLUSH[type=FLUSH_COMPLETED,viewId=" + this.viewID + "]";
                }
                case 6: {
                    return "FLUSH[type=FLUSH_BYPASS,viewId=" + this.viewID + "]";
                }
            }
            return "[FLUSH: unknown type (" + this.type + ")]";
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeByte(this.type);
            out.writeLong(this.viewID);
            out.writeObject(this.flushParticipants);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = in.readByte();
            this.viewID = in.readLong();
            this.flushParticipants = (Collection)in.readObject();
        }

        public void writeTo(DataOutputStream out) throws IOException {
            out.writeByte(this.type);
            out.writeLong(this.viewID);
            if (this.flushParticipants != null && !this.flushParticipants.isEmpty()) {
                out.writeShort(this.flushParticipants.size());
                Iterator iter = this.flushParticipants.iterator();
                while (iter.hasNext()) {
                    Address address = (Address)iter.next();
                    Util.writeAddress(address, out);
                }
            } else {
                out.writeShort(0);
            }
        }

        public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
            this.type = in.readByte();
            this.viewID = in.readLong();
            int flushParticipantsSize = in.readShort();
            if (flushParticipantsSize > 0) {
                this.flushParticipants = new ArrayList(flushParticipantsSize);
                for (int i = 0; i < flushParticipantsSize; ++i) {
                    this.flushParticipants.add(Util.readAddress(in));
                }
            }
        }
    }

    private static class FlushPhase {
        private boolean inFirstFlushPhase = false;
        private boolean inSecondFlushPhase = false;
        private final ReentrantLock lock = new ReentrantLock();

        public void lock() {
            try {
                this.lock.acquire();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        public void release() {
            this.lock.release();
        }

        public void setFirstPhase(boolean inFirstPhase) {
            this.inFirstFlushPhase = inFirstPhase;
        }

        public void setSecondPhase(boolean inSecondPhase) {
            this.inSecondFlushPhase = inSecondPhase;
        }

        public void setPhases(boolean inFirstPhase, boolean inSecondPhase) {
            this.inFirstFlushPhase = inFirstPhase;
            this.inSecondFlushPhase = inSecondPhase;
        }

        public boolean isInFirstPhase() {
            return this.inFirstFlushPhase;
        }

        public boolean isInSecondPhase() {
            return this.inSecondFlushPhase;
        }

        public boolean isFlushInProgress() {
            return this.inFirstFlushPhase || this.inSecondFlushPhase;
        }
    }
}

