/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ChannelClosedException;
import org.jgroups.ChannelNotConnectedException;
import org.jgroups.Event;
import org.jgroups.ExtendedMembershipListener;
import org.jgroups.ExtendedMessageListener;
import org.jgroups.MembershipListener;
import org.jgroups.Message;
import org.jgroups.MessageListener;
import org.jgroups.SuspectedException;
import org.jgroups.TimeoutException;
import org.jgroups.Transport;
import org.jgroups.UpHandler;
import org.jgroups.View;
import org.jgroups.blocks.GroupRequest;
import org.jgroups.blocks.PullPushAdapter;
import org.jgroups.blocks.RequestCorrelator;
import org.jgroups.blocks.RequestHandler;
import org.jgroups.blocks.RspCollector;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.StateTransferInfo;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;
import org.jgroups.util.Util;

public class MessageDispatcher
implements RequestHandler {
    protected Channel channel = null;
    protected RequestCorrelator corr = null;
    protected MessageListener msg_listener = null;
    protected MembershipListener membership_listener = null;
    protected RequestHandler req_handler = null;
    protected ProtocolAdapter prot_adapter = null;
    protected TransportAdapter transport_adapter = null;
    protected final Collection members = new TreeSet();
    protected Address local_addr = null;
    protected boolean deadlock_detection = false;
    protected PullPushAdapter adapter = null;
    protected PullPushHandler handler = null;
    protected Serializable id = null;
    protected final Log log = LogFactory.getLog(this.getClass());
    protected boolean concurrent_processing = false;

    public MessageDispatcher(Channel channel, MessageListener l, MembershipListener l2) {
        this.channel = channel;
        this.prot_adapter = new ProtocolAdapter();
        if (channel != null) {
            this.local_addr = channel.getLocalAddress();
        }
        this.setMessageListener(l);
        this.setMembershipListener(l2);
        if (channel != null) {
            channel.setUpHandler(this.prot_adapter);
        }
        this.start();
    }

    public MessageDispatcher(Channel channel, MessageListener l, MembershipListener l2, boolean deadlock_detection) {
        this.channel = channel;
        this.deadlock_detection = deadlock_detection;
        this.prot_adapter = new ProtocolAdapter();
        if (channel != null) {
            this.local_addr = channel.getLocalAddress();
        }
        this.setMessageListener(l);
        this.setMembershipListener(l2);
        if (channel != null) {
            channel.setUpHandler(this.prot_adapter);
        }
        this.start();
    }

    public MessageDispatcher(Channel channel, MessageListener l, MembershipListener l2, boolean deadlock_detection, boolean concurrent_processing) {
        this.channel = channel;
        this.deadlock_detection = deadlock_detection;
        this.concurrent_processing = concurrent_processing;
        this.prot_adapter = new ProtocolAdapter();
        if (channel != null) {
            this.local_addr = channel.getLocalAddress();
        }
        this.setMessageListener(l);
        this.setMembershipListener(l2);
        if (channel != null) {
            channel.setUpHandler(this.prot_adapter);
        }
        this.start();
    }

    public MessageDispatcher(Channel channel, MessageListener l, MembershipListener l2, RequestHandler req_handler) {
        this(channel, l, l2);
        this.setRequestHandler(req_handler);
    }

    public MessageDispatcher(Channel channel, MessageListener l, MembershipListener l2, RequestHandler req_handler, boolean deadlock_detection) {
        this(channel, l, l2, deadlock_detection, false);
        this.setRequestHandler(req_handler);
    }

    public MessageDispatcher(Channel channel, MessageListener l, MembershipListener l2, RequestHandler req_handler, boolean deadlock_detection, boolean concurrent_processing) {
        this(channel, l, l2, deadlock_detection, concurrent_processing);
        this.setRequestHandler(req_handler);
    }

    public MessageDispatcher(PullPushAdapter adapter, Serializable id, MessageListener l, MembershipListener l2) {
        this.adapter = adapter;
        this.id = id;
        this.setMembers(((Channel)adapter.getTransport()).getView().getMembers());
        this.setMessageListener(l);
        this.setMembershipListener(l2);
        this.handler = new PullPushHandler();
        this.transport_adapter = new TransportAdapter();
        adapter.addMembershipListener(this.handler);
        if (id == null) {
            adapter.setListener(this.handler);
        } else {
            adapter.registerListener(id, this.handler);
        }
        Transport tp = adapter.getTransport();
        if (tp instanceof Channel) {
            this.local_addr = ((Channel)tp).getLocalAddress();
        }
        this.start();
    }

    public MessageDispatcher(PullPushAdapter adapter, Serializable id, MessageListener l, MembershipListener l2, RequestHandler req_handler) {
        this.adapter = adapter;
        this.id = id;
        this.setMembers(((Channel)adapter.getTransport()).getView().getMembers());
        this.setRequestHandler(req_handler);
        this.setMessageListener(l);
        this.setMembershipListener(l2);
        this.handler = new PullPushHandler();
        this.transport_adapter = new TransportAdapter();
        adapter.addMembershipListener(this.handler);
        if (id == null) {
            adapter.setListener(this.handler);
        } else {
            adapter.registerListener(id, this.handler);
        }
        Transport tp = adapter.getTransport();
        if (tp instanceof Channel) {
            this.local_addr = ((Channel)tp).getLocalAddress();
        }
        this.start();
    }

    public MessageDispatcher(PullPushAdapter adapter, Serializable id, MessageListener l, MembershipListener l2, RequestHandler req_handler, boolean concurrent_processing) {
        this.concurrent_processing = concurrent_processing;
        this.adapter = adapter;
        this.id = id;
        this.setMembers(((Channel)adapter.getTransport()).getView().getMembers());
        this.setRequestHandler(req_handler);
        this.setMessageListener(l);
        this.setMembershipListener(l2);
        this.handler = new PullPushHandler();
        this.transport_adapter = new TransportAdapter();
        adapter.addMembershipListener(this.handler);
        if (id == null) {
            adapter.setListener(this.handler);
        } else {
            adapter.registerListener(id, this.handler);
        }
        Transport tp = adapter.getTransport();
        if (tp instanceof Channel) {
            this.local_addr = ((Channel)tp).getLocalAddress();
        }
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection getMembers() {
        Collection collection = this.members;
        synchronized (collection) {
            return new ArrayList(this.members);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setMembers(Vector new_mbrs) {
        if (new_mbrs != null) {
            Collection collection = this.members;
            synchronized (collection) {
                this.members.clear();
                this.members.addAll(new_mbrs);
            }
        }
    }

    public void setDeadlockDetection(boolean flag) {
        this.deadlock_detection = flag;
        if (this.corr != null) {
            this.corr.setDeadlockDetection(flag);
        }
    }

    public void setConcurrentProcessing(boolean flag) {
        this.concurrent_processing = flag;
    }

    public final void start() {
        if (this.corr == null) {
            this.corr = this.transport_adapter != null ? new RequestCorrelator("MessageDispatcher", this.transport_adapter, this, this.deadlock_detection, this.local_addr, this.concurrent_processing) : new RequestCorrelator("MessageDispatcher", this.prot_adapter, this, this.deadlock_detection, this.local_addr, this.concurrent_processing);
        }
        this.correlatorStarted();
        this.corr.start();
        if (this.channel != null) {
            Vector<Address> tmp_mbrs = this.channel.getView() != null ? this.channel.getView().getMembers() : null;
            this.setMembers(tmp_mbrs);
        }
    }

    protected void correlatorStarted() {
    }

    public void stop() {
        if (this.corr != null) {
            this.corr.stop();
        }
        if (this.adapter != null && this.handler != null) {
            this.adapter.removeMembershipListener(this.handler);
        }
    }

    public final void setMessageListener(MessageListener l) {
        this.msg_listener = l;
    }

    public MessageListener getMessageListener() {
        return this.msg_listener;
    }

    public final void setMembershipListener(MembershipListener l) {
        this.membership_listener = l;
    }

    public final void setRequestHandler(RequestHandler rh) {
        this.req_handler = rh;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void send(Message msg) throws ChannelNotConnectedException, ChannelClosedException {
        block8: {
            if (this.channel != null) {
                this.channel.send(msg);
            } else {
                if (this.adapter != null) {
                    try {
                        if (this.id != null) {
                            this.adapter.send(this.id, msg);
                            break block8;
                        }
                        this.adapter.send(msg);
                    }
                    catch (Throwable ex) {
                        if (this.log.isErrorEnabled()) {
                            this.log.error((Object)("exception=" + Util.print(ex)));
                        }
                        break block8;
                    }
                }
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)"channel == null");
                }
            }
        }
    }

    public RspList castMessage(Vector dests, Message msg, int mode, long timeout) {
        return this.castMessage(dests, msg, mode, timeout, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RspList castMessage(Vector dests, Message msg, int mode, long timeout, boolean use_anycasting) {
        Vector<Address> real_dests;
        GroupRequest _req = null;
        if (dests != null) {
            real_dests = (Vector<Address>)dests.clone();
            real_dests.retainAll(this.members);
        } else {
            Collection collection = this.members;
            synchronized (collection) {
                real_dests = new Vector<Address>(this.members);
            }
        }
        Channel tmp = this.channel;
        if (tmp == null && this.adapter != null && this.adapter.getTransport() instanceof Channel) {
            tmp = (Channel)this.adapter.getTransport();
        }
        if (tmp != null && tmp.getOpt(3).equals(Boolean.FALSE)) {
            if (this.local_addr == null) {
                this.local_addr = tmp.getLocalAddress();
            }
            if (this.local_addr != null) {
                real_dests.removeElement(this.local_addr);
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("real_dests=" + real_dests));
        }
        if (real_dests.isEmpty()) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)"destination list is empty, won't send message");
            }
            return new RspList();
        }
        _req = new GroupRequest(msg, this.corr, real_dests, mode, timeout, 0);
        _req.setCaller(this.local_addr);
        try {
            _req.execute(use_anycasting);
        }
        catch (Exception ex) {
            throw new RuntimeException("failed executing request " + _req, ex);
        }
        return _req.getResults();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void castMessage(Vector dests, long req_id, Message msg, RspCollector coll) {
        Vector real_dests;
        if (msg == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"request is null");
            }
            return;
        }
        if (coll == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"response collector is null (must be non-null)");
            }
            return;
        }
        if (dests != null) {
            real_dests = (Vector)dests.clone();
            real_dests.retainAll(this.members);
        } else {
            Collection collection = this.members;
            synchronized (collection) {
                real_dests = new Vector(this.members);
            }
        }
        Channel tmp = this.channel;
        if (tmp == null && this.adapter != null && this.adapter.getTransport() instanceof Channel) {
            tmp = (Channel)this.adapter.getTransport();
        }
        if (tmp != null && tmp.getOpt(3).equals(Boolean.FALSE)) {
            if (this.local_addr == null) {
                this.local_addr = tmp.getLocalAddress();
            }
            if (this.local_addr != null) {
                real_dests.removeElement(this.local_addr);
            }
        }
        if (real_dests.isEmpty()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"destination list is empty, won't send message");
            }
            return;
        }
        try {
            this.corr.sendRequest(req_id, real_dests, msg, coll);
        }
        catch (Exception e) {
            throw new RuntimeException("failure sending request " + req_id + " to " + real_dests, e);
        }
    }

    public void done(long req_id) {
        this.corr.done(req_id);
    }

    public Object sendMessage(Message msg, int mode, long timeout) throws TimeoutException, SuspectedException {
        Rsp rsp;
        Vector<Address> mbrs = new Vector<Address>();
        RspList rsp_list = null;
        Address dest = msg.getDest();
        GroupRequest _req = null;
        if (dest == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"the message's destination is null, cannot send message");
            }
            return null;
        }
        mbrs.addElement(dest);
        _req = new GroupRequest(msg, this.corr, mbrs, mode, timeout, 0);
        _req.setCaller(this.local_addr);
        try {
            _req.execute();
        }
        catch (Exception t) {
            throw new RuntimeException("failed executing request " + _req, t);
        }
        if (mode == 6) {
            return null;
        }
        rsp_list = _req.getResults();
        if (rsp_list.isEmpty()) {
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)" response list is empty");
            }
            return null;
        }
        if (rsp_list.size() > 1 && this.log.isWarnEnabled()) {
            this.log.warn((Object)"response list contains more that 1 response; returning first response !");
        }
        if ((rsp = (Rsp)rsp_list.elementAt(0)).wasSuspected()) {
            throw new SuspectedException(dest);
        }
        if (!rsp.wasReceived()) {
            throw new TimeoutException();
        }
        return rsp.getValue();
    }

    public Object handle(Message msg) {
        if (this.req_handler != null) {
            return this.req_handler.handle(msg);
        }
        return null;
    }

    class PullPushHandler
    implements ExtendedMessageListener,
    MembershipListener {
        PullPushHandler() {
        }

        public void receive(Message msg) {
            boolean consumed = false;
            if (MessageDispatcher.this.corr != null) {
                consumed = MessageDispatcher.this.corr.receiveMessage(msg);
            }
            if (!consumed && MessageDispatcher.this.msg_listener != null) {
                MessageDispatcher.this.msg_listener.receive(msg);
            }
        }

        public byte[] getState() {
            return MessageDispatcher.this.msg_listener != null ? MessageDispatcher.this.msg_listener.getState() : null;
        }

        public byte[] getState(String state_id) {
            if (MessageDispatcher.this.msg_listener == null) {
                return null;
            }
            if (MessageDispatcher.this.msg_listener instanceof ExtendedMessageListener && state_id != null) {
                return ((ExtendedMessageListener)MessageDispatcher.this.msg_listener).getState(state_id);
            }
            return MessageDispatcher.this.msg_listener.getState();
        }

        public void setState(byte[] state) {
            if (MessageDispatcher.this.msg_listener != null) {
                MessageDispatcher.this.msg_listener.setState(state);
            }
        }

        public void setState(String state_id, byte[] state) {
            if (MessageDispatcher.this.msg_listener != null) {
                if (MessageDispatcher.this.msg_listener instanceof ExtendedMessageListener && state_id != null) {
                    ((ExtendedMessageListener)MessageDispatcher.this.msg_listener).setState(state_id, state);
                } else {
                    MessageDispatcher.this.msg_listener.setState(state);
                }
            }
        }

        public void getState(OutputStream ostream) {
            if (MessageDispatcher.this.msg_listener instanceof ExtendedMessageListener) {
                ((ExtendedMessageListener)MessageDispatcher.this.msg_listener).getState(ostream);
            }
        }

        public void getState(String state_id, OutputStream ostream) {
            if (MessageDispatcher.this.msg_listener instanceof ExtendedMessageListener && state_id != null) {
                ((ExtendedMessageListener)MessageDispatcher.this.msg_listener).getState(state_id, ostream);
            }
        }

        public void setState(InputStream istream) {
            if (MessageDispatcher.this.msg_listener instanceof ExtendedMessageListener) {
                ((ExtendedMessageListener)MessageDispatcher.this.msg_listener).setState(istream);
            }
        }

        public void setState(String state_id, InputStream istream) {
            if (MessageDispatcher.this.msg_listener instanceof ExtendedMessageListener && state_id != null) {
                ((ExtendedMessageListener)MessageDispatcher.this.msg_listener).setState(state_id, istream);
            }
        }

        public void viewAccepted(View v) {
            if (MessageDispatcher.this.corr != null) {
                MessageDispatcher.this.corr.receiveView(v);
            }
            Vector<Address> new_mbrs = v.getMembers();
            MessageDispatcher.this.setMembers(new_mbrs);
            if (MessageDispatcher.this.membership_listener != null) {
                MessageDispatcher.this.membership_listener.viewAccepted(v);
            }
        }

        public void suspect(Address suspected_mbr) {
            if (MessageDispatcher.this.corr != null) {
                MessageDispatcher.this.corr.receiveSuspect(suspected_mbr);
            }
            if (MessageDispatcher.this.membership_listener != null) {
                MessageDispatcher.this.membership_listener.suspect(suspected_mbr);
            }
        }

        public void block() {
            if (MessageDispatcher.this.membership_listener != null) {
                MessageDispatcher.this.membership_listener.block();
            }
        }
    }

    class TransportAdapter
    implements Transport {
        TransportAdapter() {
        }

        public void send(Message msg) throws Exception {
            block8: {
                if (MessageDispatcher.this.channel != null) {
                    MessageDispatcher.this.channel.send(msg);
                } else {
                    if (MessageDispatcher.this.adapter != null) {
                        try {
                            if (MessageDispatcher.this.id != null) {
                                MessageDispatcher.this.adapter.send(MessageDispatcher.this.id, msg);
                                break block8;
                            }
                            MessageDispatcher.this.adapter.send(msg);
                        }
                        catch (Throwable ex) {
                            if (MessageDispatcher.this.log.isErrorEnabled()) {
                                MessageDispatcher.this.log.error((Object)("exception=" + Util.print(ex)));
                            }
                            break block8;
                        }
                    }
                    if (MessageDispatcher.this.log.isErrorEnabled()) {
                        MessageDispatcher.this.log.error((Object)"channel == null");
                    }
                }
            }
        }

        public Object receive(long timeout) throws Exception {
            return null;
        }
    }

    class ProtocolAdapter
    extends Protocol
    implements UpHandler {
        ProtocolAdapter() {
        }

        public String getName() {
            return "MessageDispatcher";
        }

        private Object handleUpEvent(Event evt) {
            switch (evt.getType()) {
                case 1: {
                    if (MessageDispatcher.this.msg_listener == null) break;
                    MessageDispatcher.this.msg_listener.receive((Message)evt.getArg());
                    break;
                }
                case 17: {
                    StateTransferInfo info = (StateTransferInfo)evt.getArg();
                    String state_id = info.state_id;
                    byte[] tmp_state = null;
                    if (MessageDispatcher.this.msg_listener != null) {
                        try {
                            tmp_state = MessageDispatcher.this.msg_listener instanceof ExtendedMessageListener && state_id != null ? ((ExtendedMessageListener)MessageDispatcher.this.msg_listener).getState(state_id) : MessageDispatcher.this.msg_listener.getState();
                        }
                        catch (Throwable t) {
                            this.log.error((Object)("failed getting state from message listener (" + MessageDispatcher.this.msg_listener + ')'), t);
                        }
                    }
                    return new StateTransferInfo(null, state_id, 0L, tmp_state);
                }
                case 20: {
                    if (MessageDispatcher.this.msg_listener == null) break;
                    try {
                        StateTransferInfo info = (StateTransferInfo)evt.getArg();
                        String id = info.state_id;
                        if (MessageDispatcher.this.msg_listener instanceof ExtendedMessageListener && id != null) {
                            ((ExtendedMessageListener)MessageDispatcher.this.msg_listener).setState(id, info.state);
                            break;
                        }
                        MessageDispatcher.this.msg_listener.setState(info.state);
                    }
                    catch (ClassCastException cast_ex) {
                        if (!this.log.isErrorEnabled()) break;
                        this.log.error((Object)("received SetStateEvent, but argument " + evt.getArg() + " is not serializable. Discarding message."));
                    }
                    break;
                }
                case 72: {
                    StateTransferInfo sti = (StateTransferInfo)evt.getArg();
                    OutputStream os = sti.outputStream;
                    if (MessageDispatcher.this.msg_listener instanceof ExtendedMessageListener) {
                        if (os != null && MessageDispatcher.this.msg_listener instanceof ExtendedMessageListener) {
                            if (sti.state_id == null) {
                                ((ExtendedMessageListener)MessageDispatcher.this.msg_listener).getState(os);
                            } else {
                                ((ExtendedMessageListener)MessageDispatcher.this.msg_listener).getState(sti.state_id, os);
                            }
                        }
                        return new StateTransferInfo(null, os, sti.state_id);
                    }
                    if (!(MessageDispatcher.this.msg_listener instanceof MessageListener) || !this.log.isWarnEnabled()) break;
                    this.log.warn((Object)"Channel has STREAMING_STATE_TRANSFER, however, application does not implement ExtendedMessageListener. State is not transfered");
                    Util.close(os);
                    break;
                }
                case 71: {
                    StateTransferInfo sti = (StateTransferInfo)evt.getArg();
                    InputStream is = sti.inputStream;
                    if (MessageDispatcher.this.msg_listener instanceof ExtendedMessageListener) {
                        if (is == null || !(MessageDispatcher.this.msg_listener instanceof ExtendedMessageListener)) break;
                        if (sti.state_id == null) {
                            ((ExtendedMessageListener)MessageDispatcher.this.msg_listener).setState(is);
                            break;
                        }
                        ((ExtendedMessageListener)MessageDispatcher.this.msg_listener).setState(sti.state_id, is);
                        break;
                    }
                    if (!(MessageDispatcher.this.msg_listener instanceof MessageListener) || !this.log.isWarnEnabled()) break;
                    this.log.warn((Object)"Channel has STREAMING_STATE_TRANSFER, however, application does not implement ExtendedMessageListener. State is not transfered");
                    Util.close(is);
                    break;
                }
                case 6: {
                    View v = (View)evt.getArg();
                    Vector<Address> new_mbrs = v.getMembers();
                    MessageDispatcher.this.setMembers(new_mbrs);
                    if (MessageDispatcher.this.membership_listener == null) break;
                    MessageDispatcher.this.membership_listener.viewAccepted(v);
                    break;
                }
                case 8: {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)("setting local_addr (" + MessageDispatcher.this.local_addr + ") to " + evt.getArg()));
                    }
                    MessageDispatcher.this.local_addr = (Address)evt.getArg();
                    break;
                }
                case 9: {
                    if (MessageDispatcher.this.membership_listener == null) break;
                    MessageDispatcher.this.membership_listener.suspect((Address)evt.getArg());
                    break;
                }
                case 10: {
                    if (MessageDispatcher.this.membership_listener != null) {
                        MessageDispatcher.this.membership_listener.block();
                    }
                    MessageDispatcher.this.channel.blockOk();
                    break;
                }
                case 75: {
                    if (!(MessageDispatcher.this.membership_listener instanceof ExtendedMembershipListener)) break;
                    ((ExtendedMembershipListener)MessageDispatcher.this.membership_listener).unblock();
                }
            }
            return null;
        }

        public Object up(Event evt) {
            if (MessageDispatcher.this.corr != null) {
                if (!MessageDispatcher.this.corr.receive(evt)) {
                    return this.handleUpEvent(evt);
                }
            } else if (this.log.isErrorEnabled()) {
                this.log.error((Object)("correlator is null, event will be ignored (evt=" + evt + ")"));
            }
            return null;
        }

        public Object down(Event evt) {
            if (MessageDispatcher.this.channel != null) {
                return MessageDispatcher.this.channel.downcall(evt);
            }
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)("channel is null, discarding event " + evt));
            }
            return null;
        }
    }
}

