/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ChannelClosedException;
import org.jgroups.ChannelException;
import org.jgroups.ChannelFactory;
import org.jgroups.ChannelNotConnectedException;
import org.jgroups.ExtendedMembershipListener;
import org.jgroups.ExtendedMessageListener;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.Message;
import org.jgroups.MessageListener;
import org.jgroups.View;
import org.jgroups.blocks.MethodCall;
import org.jgroups.blocks.MethodLookup;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.persistence.CannotPersistException;
import org.jgroups.persistence.CannotRemoveException;
import org.jgroups.persistence.PersistenceFactory;
import org.jgroups.persistence.PersistenceManager;
import org.jgroups.util.Promise;
import org.jgroups.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplicatedHashMap<K extends Serializable, V extends Serializable>
extends HashMap<K, V>
implements ExtendedMessageListener,
ExtendedMembershipListener {
    protected static Map<Short, Method> methods;
    private transient Channel channel;
    protected transient RpcDispatcher disp = null;
    private String cluster_name = null;
    private final transient Set<Notification> notifs = new CopyOnWriteArraySet<Notification>();
    private final Vector<Address> members = new Vector();
    private transient boolean persistent = false;
    private transient PersistenceManager persistence_mgr = null;
    private transient boolean send_message = false;
    protected final transient Promise state_promise = new Promise();
    protected int update_mode = 6;
    protected long timeout = 5000L;
    protected final Log log = LogFactory.getLog(this.getClass());

    public ReplicatedHashMap(String clustername, ChannelFactory factory, String properties, long state_timeout) throws ChannelException {
        this.cluster_name = clustername;
        this.channel = factory != null ? (properties != null ? factory.createChannel(properties) : factory.createChannel()) : new JChannel(properties);
        this.disp = new RpcDispatcher(this.channel, (MessageListener)this, (MembershipListener)this, (Object)this);
        this.disp.setMethodLookup(new MethodLookup(){

            public Method findMethod(short id) {
                return methods.get(id);
            }
        });
        this.channel.connect(clustername);
        this.start(state_timeout);
    }

    public ReplicatedHashMap(String clustername, ChannelFactory factory, String properties, boolean persistent, long state_timeout) throws ChannelException {
        this.cluster_name = clustername;
        this.persistent = persistent;
        this.channel = factory != null ? (properties != null ? factory.createChannel(properties) : factory.createChannel()) : new JChannel(properties);
        this.disp = new RpcDispatcher(this.channel, (MessageListener)this, (MembershipListener)this, (Object)this);
        this.disp.setMethodLookup(new MethodLookup(){

            public Method findMethod(short id) {
                return methods.get(id);
            }
        });
        this.channel.connect(clustername);
        this.start(state_timeout);
    }

    public ReplicatedHashMap(Channel channel, long state_timeout) {
        this(channel, false, state_timeout);
    }

    public ReplicatedHashMap(Channel channel, boolean persistent, long state_timeout) {
        this.cluster_name = channel.getClusterName();
        this.channel = channel;
        this.persistent = persistent;
        this.init(state_timeout);
    }

    protected final void init(long state_timeout) {
        this.disp = new RpcDispatcher(this.channel, (MessageListener)this, (MembershipListener)this, (Object)this);
        this.disp.setMethodLookup(new MethodLookup(){

            public Method findMethod(short id) {
                return methods.get(id);
            }
        });
    }

    public boolean isBlockingUpdates() {
        return this.update_mode == 2;
    }

    public void setBlockingUpdates(boolean blocking_updates) {
        this.update_mode = blocking_updates ? 2 : 6;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public final void start(long state_timeout) throws ChannelClosedException, ChannelNotConnectedException {
        if (this.persistent) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)"fetching state from database");
            }
            try {
                this.persistence_mgr = PersistenceFactory.getInstance().createManager();
            }
            catch (Throwable ex) {
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)("failed creating PersistenceManager, turning persistency off. Exception: " + Util.printStackTrace(ex)));
                }
                this.persistent = false;
            }
        }
        this.state_promise.reset();
        boolean rc = this.channel.getState(null, state_timeout);
        if (rc) {
            Boolean result;
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)"state was retrieved successfully, waiting for setState()");
            }
            if ((result = (Boolean)this.state_promise.getResult(state_timeout)) == null) {
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)"setState() never got called");
                }
            } else if (this.log.isInfoEnabled()) {
                this.log.info((Object)"setState() was called");
            }
        } else {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)"state could not be retrieved (first member)");
            }
            if (this.persistent) {
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)"fetching state from database");
                }
                try {
                    Map m = this.persistence_mgr.retrieveAll();
                    if (m != null) {
                        for (Map.Entry entry : m.entrySet()) {
                            Serializable key = (Serializable)entry.getKey();
                            Serializable val = (Serializable)entry.getValue();
                            if (this.log.isTraceEnabled()) {
                                this.log.trace((Object)("inserting " + key + " --> " + val));
                            }
                            this.put((K)key, (V)val);
                        }
                    }
                }
                catch (Throwable ex) {
                    if (this.log.isErrorEnabled()) {
                        this.log.error((Object)("failed creating PersistenceManager, turning persistency off. Exception: " + Util.printStackTrace(ex)));
                    }
                    this.persistent = false;
                }
            }
        }
    }

    public Address getLocalAddress() {
        return this.channel != null ? this.channel.getLocalAddress() : null;
    }

    public String getClusterName() {
        return this.cluster_name;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public boolean getPersistent() {
        return this.persistent;
    }

    public void setPersistent(boolean p) {
        this.persistent = p;
    }

    public void setDeadlockDetection(boolean flag) {
        if (this.disp != null) {
            this.disp.setDeadlockDetection(flag);
        }
    }

    public void addNotifier(Notification n) {
        if (n != null) {
            this.notifs.add(n);
        }
    }

    public void removeNotifier(Notification n) {
        if (n != null) {
            this.notifs.remove(n);
        }
    }

    public void stop() {
        if (this.disp != null) {
            this.disp.stop();
            this.disp = null;
        }
        if (this.channel != null) {
            this.channel.close();
            this.channel = null;
        }
    }

    @Override
    public V put(K key, V value) {
        Serializable prev_val = (Serializable)this.get(key);
        if (this.send_message) {
            try {
                MethodCall call = new MethodCall(1, new Object[]{key, value});
                this.disp.callRemoteMethods(null, call, this.update_mode, this.timeout);
            }
            catch (Exception e) {
                throw new RuntimeException("put(" + key + ", " + value + ") failed", e);
            }
        } else {
            this._put(key, value);
        }
        return (V)prev_val;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        if (this.send_message) {
            try {
                MethodCall call = new MethodCall(2, new Object[]{m});
                this.disp.callRemoteMethods(null, call, this.update_mode, this.timeout);
            }
            catch (Throwable t) {
                throw new RuntimeException("putAll() failed", t);
            }
        } else {
            this._putAll(m);
        }
    }

    @Override
    public void clear() {
        if (this.send_message) {
            try {
                MethodCall call = new MethodCall(4, null);
                this.disp.callRemoteMethods(null, call, this.update_mode, this.timeout);
            }
            catch (Exception e) {
                throw new RuntimeException("clear() failed", e);
            }
        } else {
            this._clear();
        }
    }

    @Override
    public V remove(Object key) {
        Serializable retval = (Serializable)this.get(key);
        if (this.send_message) {
            try {
                MethodCall call = new MethodCall(3, new Object[]{key});
                this.disp.callRemoteMethods(null, call, this.update_mode, this.timeout);
            }
            catch (Exception e) {
                throw new RuntimeException("remove(" + key + ") failed", e);
            }
        } else {
            this._remove(key);
        }
        return (V)retval;
    }

    public V _put(K key, V value) {
        Serializable retval;
        block6: {
            retval = (Serializable)super.put(key, value);
            if (this.persistent) {
                try {
                    this.persistence_mgr.save((Serializable)key, (Serializable)value);
                }
                catch (CannotPersistException cannot_persist_ex) {
                    if (this.log.isErrorEnabled()) {
                        this.log.error((Object)("failed persisting " + key + " + " + value + ", exception=" + cannot_persist_ex));
                    }
                }
                catch (Throwable t) {
                    if (!this.log.isErrorEnabled()) break block6;
                    this.log.error((Object)("failed persisting " + key + " + " + value + ", exception=" + Util.printStackTrace(t)));
                }
            }
        }
        for (Notification notif : this.notifs) {
            notif.entrySet(key, value);
        }
        return (V)retval;
    }

    public void _putAll(Map<? extends K, ? extends V> map) {
        block8: {
            if (map == null) {
                return;
            }
            for (Map.Entry<K, V> entry : map.entrySet()) {
                super.put(entry.getKey(), entry.getValue());
            }
            if (this.persistent) {
                try {
                    this.persistence_mgr.saveAll(map);
                }
                catch (CannotPersistException persist_ex) {
                    if (this.log.isErrorEnabled()) {
                        this.log.error((Object)("failed persisting contents: " + persist_ex));
                    }
                }
                catch (Throwable t) {
                    if (!this.log.isErrorEnabled()) break block8;
                    this.log.error((Object)("failed persisting contents: " + t));
                }
            }
        }
        for (Notification notif : this.notifs) {
            notif.contentsSet(map);
        }
    }

    public void _clear() {
        block6: {
            super.clear();
            if (this.persistent) {
                try {
                    this.persistence_mgr.clear();
                }
                catch (CannotRemoveException cannot_remove_ex) {
                    if (this.log.isErrorEnabled()) {
                        this.log.error((Object)("failed clearing contents, exception=" + cannot_remove_ex));
                    }
                }
                catch (Throwable t) {
                    if (!this.log.isErrorEnabled()) break block6;
                    this.log.error((Object)("failed clearing contents, exception=" + t));
                }
            }
        }
        for (Notification notif : this.notifs) {
            notif.contentsCleared();
        }
    }

    public V _remove(Object key) {
        Serializable retval;
        block6: {
            retval = (Serializable)super.remove(key);
            if (this.persistent) {
                try {
                    this.persistence_mgr.remove((Serializable)key);
                }
                catch (CannotRemoveException cannot_remove_ex) {
                    if (this.log.isErrorEnabled()) {
                        this.log.error((Object)("failed clearing contents, exception=" + cannot_remove_ex));
                    }
                }
                catch (Throwable t) {
                    if (!this.log.isErrorEnabled()) break block6;
                    this.log.error((Object)("failed clearing contents, exception=" + t));
                }
            }
        }
        for (Notification notif : this.notifs) {
            notif.entryRemoved(key);
        }
        return (V)retval;
    }

    @Override
    public void receive(Message msg) {
    }

    @Override
    public byte[] getState() {
        HashMap<Serializable, Serializable> copy = new HashMap<Serializable, Serializable>();
        for (Map.Entry entry : this.entrySet()) {
            Serializable key = (Serializable)entry.getKey();
            Serializable val = (Serializable)entry.getValue();
            copy.put(key, val);
        }
        try {
            return Util.objectToByteBuffer(copy);
        }
        catch (Throwable ex) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("exception marshalling state: " + ex));
            }
            return null;
        }
    }

    @Override
    public void setState(byte[] new_state) {
        HashMap new_copy;
        try {
            new_copy = (HashMap)Util.objectFromByteBuffer(new_state);
            if (new_copy == null) {
                return;
            }
        }
        catch (Throwable ex) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("exception unmarshalling state: " + ex));
            }
            return;
        }
        this._putAll(new_copy);
        this.state_promise.setResult(Boolean.TRUE);
    }

    @Override
    public void viewAccepted(View new_view) {
        Vector<Address> new_mbrs = new_view.getMembers();
        if (new_mbrs != null) {
            this.sendViewChangeNotifications(new_view, new_mbrs, new Vector<Address>(this.members));
            this.members.clear();
            this.members.addAll(new_mbrs);
        }
        this.send_message = this.members.size() > 1;
    }

    @Override
    public void suspect(Address suspected_mbr) {
    }

    @Override
    public void block() {
    }

    void sendViewChangeNotifications(View view, Vector<Address> new_mbrs, Vector<Address> old_mbrs) {
        if (this.notifs.isEmpty() || old_mbrs == null || new_mbrs == null || old_mbrs.isEmpty() || new_mbrs.isEmpty()) {
            return;
        }
        Vector<Address> joined = new Vector<Address>();
        for (Address mbr : new_mbrs) {
            if (old_mbrs.contains(mbr)) continue;
            joined.addElement(mbr);
        }
        Vector<Address> left = new Vector<Address>();
        for (Address mbr : old_mbrs) {
            if (new_mbrs.contains(mbr)) continue;
            left.addElement(mbr);
        }
        for (Notification notif : this.notifs) {
            notif.viewChange(view, joined, left);
        }
    }

    @Override
    public byte[] getState(String state_id) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getState(OutputStream ostream) {
        HashMap<Serializable, Serializable> copy = new HashMap<Serializable, Serializable>();
        ObjectOutputStream oos = null;
        for (Map.Entry entry : this.entrySet()) {
            Serializable key = (Serializable)entry.getKey();
            Serializable val = (Serializable)entry.getValue();
            copy.put(key, val);
        }
        try {
            oos = new ObjectOutputStream(ostream);
            oos.writeObject(copy);
        }
        catch (Throwable ex) {
            block5: {
                try {
                    if (!this.log.isErrorEnabled()) break block5;
                    this.log.error((Object)("exception marshalling state: " + ex));
                }
                catch (Throwable throwable) {
                    Util.close(oos);
                    throw throwable;
                }
            }
            Util.close(oos);
        }
        Util.close(oos);
    }

    @Override
    public void getState(String state_id, OutputStream ostream) {
    }

    @Override
    public void setState(String state_id, byte[] state) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setState(InputStream istream) {
        HashMap new_copy = null;
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(istream);
            new_copy = (HashMap)ois.readObject();
            ois.close();
        }
        catch (Throwable e) {
            block5: {
                try {
                    e.printStackTrace();
                    if (!this.log.isErrorEnabled()) break block5;
                    this.log.error((Object)("exception marshalling state: " + e));
                }
                catch (Throwable throwable) {
                    Util.close(ois);
                    throw throwable;
                }
            }
            Util.close(ois);
        }
        Util.close(ois);
        if (new_copy != null) {
            this._putAll(new_copy);
        }
        this.state_promise.setResult(Boolean.TRUE);
    }

    @Override
    public void setState(String state_id, InputStream istream) {
    }

    @Override
    public void unblock() {
    }

    static {
        try {
            methods = new HashMap<Short, Method>(10);
            methods.put(new Short(1), ReplicatedHashMap.class.getMethod("_put", Serializable.class, Serializable.class));
            methods.put(new Short(2), ReplicatedHashMap.class.getMethod("_putAll", Map.class));
            methods.put(new Short(3), ReplicatedHashMap.class.getMethod("_remove", Object.class));
            methods.put(new Short(4), ReplicatedHashMap.class.getMethod("_clear", new Class[0]));
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Notification {
        public void entrySet(Object var1, Object var2);

        public void entryRemoved(Object var1);

        public void viewChange(View var1, Vector<Address> var2, Vector<Address> var3);

        public void contentsSet(Map var1);

        public void contentsCleared();
    }
}

