/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.HashMap;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.blocks.ReplicatedHashMap;
import org.jgroups.tests.ChannelTestBase;

public class ReplicatedHashMapTest
extends ChannelTestBase {
    private ReplicatedHashMap<String, String> map1;
    private ReplicatedHashMap<String, String> map2;

    public ReplicatedHashMapTest(String testName) {
        super(testName);
    }

    protected void setUp() throws Exception {
        super.setUp();
        JChannel c1 = this.createChannel("A");
        this.map1 = new ReplicatedHashMap(c1, false, 5000L);
        this.map1.setBlockingUpdates(true);
        ((Channel)c1).connect("demo");
        this.map1.start(5000L);
        JChannel c2 = this.createChannel("A");
        this.map2 = new ReplicatedHashMap(c2, false, 5000L);
        this.map2.setBlockingUpdates(true);
        ((Channel)c2).connect("demo");
        this.map2.start(5000L);
    }

    protected void tearDown() throws Exception {
        this.map1.stop();
        this.map2.stop();
        super.tearDown();
    }

    public void testSize() {
        ReplicatedHashMapTest.assertEquals((int)0, (int)this.map1.size());
        ReplicatedHashMapTest.assertEquals((int)this.map2.size(), (int)this.map1.size());
        this.map1.put("key1", "value1");
        ReplicatedHashMapTest.assertEquals((int)1, (int)this.map1.size());
        ReplicatedHashMapTest.assertEquals((int)this.map2.size(), (int)this.map1.size());
        this.map2.put("key2", "value2");
        ReplicatedHashMapTest.assertEquals((int)2, (int)this.map1.size());
        ReplicatedHashMapTest.assertEquals((int)this.map2.size(), (int)this.map1.size());
    }

    public void testIsEmpty() {
        ReplicatedHashMapTest.assertTrue((boolean)this.map1.isEmpty());
        ReplicatedHashMapTest.assertTrue((boolean)this.map2.isEmpty());
        this.map1.put("key", "value");
        ReplicatedHashMapTest.assertFalse((boolean)this.map1.isEmpty());
        ReplicatedHashMapTest.assertFalse((boolean)this.map2.isEmpty());
    }

    public void testContainsKey() {
        ReplicatedHashMapTest.assertFalse((boolean)this.map1.containsKey("key1"));
        ReplicatedHashMapTest.assertFalse((boolean)this.map2.containsKey("key1"));
        this.map1.put("key1", "value");
        ReplicatedHashMapTest.assertTrue((boolean)this.map1.containsKey("key1"));
        ReplicatedHashMapTest.assertTrue((boolean)this.map2.containsKey("key1"));
        this.map2.put("key2", "value");
        ReplicatedHashMapTest.assertTrue((boolean)this.map1.containsKey("key2"));
        ReplicatedHashMapTest.assertTrue((boolean)this.map2.containsKey("key2"));
    }

    public void testContainsValue() {
        ReplicatedHashMapTest.assertFalse((boolean)this.map1.containsValue("value1"));
        ReplicatedHashMapTest.assertFalse((boolean)this.map2.containsValue("value1"));
        this.map1.put("key1", "value1");
        ReplicatedHashMapTest.assertTrue((boolean)this.map1.containsValue("value1"));
        ReplicatedHashMapTest.assertTrue((boolean)this.map2.containsValue("value1"));
        this.map2.put("key2", "value2");
        ReplicatedHashMapTest.assertTrue((boolean)this.map1.containsValue("value2"));
        ReplicatedHashMapTest.assertTrue((boolean)this.map2.containsValue("value2"));
    }

    public void testPutAndGet() {
        ReplicatedHashMapTest.assertNull(this.map1.get("key1"));
        ReplicatedHashMapTest.assertNull(this.map2.get("key1"));
        this.map1.put("key1", "value1");
        ReplicatedHashMapTest.assertNotNull(this.map1.get("key1"));
        ReplicatedHashMapTest.assertNotNull(this.map2.get("key1"));
        this.map2.put("key2", "value2");
        ReplicatedHashMapTest.assertNotNull(this.map1.get("key2"));
        ReplicatedHashMapTest.assertNotNull(this.map2.get("key2"));
    }

    public void testRemove() {
        ReplicatedHashMapTest.assertNull(this.map1.get("key1"));
        ReplicatedHashMapTest.assertNull(this.map2.get("key1"));
        this.map1.put("key1", "value1");
        this.map2.put("key2", "value2");
        ReplicatedHashMapTest.assertNotNull(this.map1.get("key1"));
        ReplicatedHashMapTest.assertNotNull(this.map2.get("key1"));
        ReplicatedHashMapTest.assertNotNull(this.map1.get("key2"));
        ReplicatedHashMapTest.assertNotNull(this.map2.get("key2"));
        this.map1.remove("key1");
        ReplicatedHashMapTest.assertNull(this.map1.get("key1"));
        ReplicatedHashMapTest.assertNull(this.map2.get("key1"));
        ReplicatedHashMapTest.assertNotNull(this.map1.get("key2"));
        ReplicatedHashMapTest.assertNotNull(this.map2.get("key2"));
        this.map2.remove("key2");
        ReplicatedHashMapTest.assertNull(this.map1.get("key2"));
        ReplicatedHashMapTest.assertNull(this.map2.get("key2"));
    }

    public void testPutAll() {
        HashMap<String, String> all1 = new HashMap<String, String>();
        all1.put("key1", "value1");
        all1.put("key2", "value2");
        HashMap<String, String> all2 = new HashMap<String, String>();
        all2.put("key3", "value3");
        all2.put("key4", "value4");
        this.map1.putAll(all1);
        ReplicatedHashMapTest.assertEquals((int)2, (int)this.map1.size());
        ReplicatedHashMapTest.assertEquals((int)2, (int)this.map2.size());
        this.map2.putAll(all2);
        ReplicatedHashMapTest.assertEquals((int)4, (int)this.map1.size());
        ReplicatedHashMapTest.assertEquals((int)4, (int)this.map2.size());
        ReplicatedHashMapTest.assertTrue((boolean)this.map1.containsKey("key1"));
        ReplicatedHashMapTest.assertTrue((boolean)this.map1.containsKey("key2"));
        ReplicatedHashMapTest.assertTrue((boolean)this.map1.containsKey("key3"));
        ReplicatedHashMapTest.assertTrue((boolean)this.map1.containsKey("key4"));
        ReplicatedHashMapTest.assertTrue((boolean)this.map2.containsKey("key1"));
        ReplicatedHashMapTest.assertTrue((boolean)this.map2.containsKey("key2"));
        ReplicatedHashMapTest.assertTrue((boolean)this.map2.containsKey("key3"));
        ReplicatedHashMapTest.assertTrue((boolean)this.map2.containsKey("key4"));
    }

    public void testClear() {
        ReplicatedHashMapTest.assertTrue((boolean)this.map1.isEmpty());
        ReplicatedHashMapTest.assertTrue((boolean)this.map2.isEmpty());
        this.map1.put("key", "value");
        ReplicatedHashMapTest.assertFalse((boolean)this.map1.isEmpty());
        ReplicatedHashMapTest.assertFalse((boolean)this.map2.isEmpty());
        this.map1.clear();
        ReplicatedHashMapTest.assertTrue((boolean)this.map1.isEmpty());
        ReplicatedHashMapTest.assertTrue((boolean)this.map2.isEmpty());
        this.map2.put("key", "value");
        ReplicatedHashMapTest.assertFalse((boolean)this.map1.isEmpty());
        ReplicatedHashMapTest.assertFalse((boolean)this.map2.isEmpty());
        this.map2.clear();
        ReplicatedHashMapTest.assertTrue((boolean)this.map1.isEmpty());
        ReplicatedHashMapTest.assertTrue((boolean)this.map2.isEmpty());
    }

    public void testKeySet() {
        HashMap<String, String> all1 = new HashMap<String, String>();
        all1.put("key1", "value1");
        all1.put("key2", "value2");
        HashMap<String, String> all2 = new HashMap<String, String>();
        all2.put("key3", "value3");
        all2.put("key4", "value4");
        this.map1.putAll(all1);
        ReplicatedHashMapTest.assertEquals(all1.keySet(), this.map1.keySet());
        ReplicatedHashMapTest.assertEquals(all1.keySet(), this.map2.keySet());
        this.map2.putAll(all2);
        all1.putAll(all2);
        ReplicatedHashMapTest.assertEquals(all1.keySet(), this.map1.keySet());
        ReplicatedHashMapTest.assertEquals(all1.keySet(), this.map2.keySet());
    }

    public void testValues() {
        HashMap<String, String> all1 = new HashMap<String, String>();
        all1.put("key1", "value1");
        all1.put("key2", "value2");
        HashMap<String, String> all2 = new HashMap<String, String>();
        all2.put("key3", "value3");
        all2.put("key4", "value4");
        this.map1.putAll(all1);
        ReplicatedHashMapTest.assertTrue((boolean)this.map1.values().containsAll(all1.values()));
        ReplicatedHashMapTest.assertTrue((boolean)this.map2.values().containsAll(all1.values()));
        this.map2.putAll(all2);
        all1.putAll(all2);
        ReplicatedHashMapTest.assertTrue((boolean)this.map1.values().containsAll(all1.values()));
        ReplicatedHashMapTest.assertTrue((boolean)this.map2.values().containsAll(all1.values()));
    }
}

