/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.annotation;

import com.sun.faces.application.annotation.ComponentConfigHandler;
import com.sun.faces.application.annotation.ConfigAnnotationHandler;
import com.sun.faces.application.annotation.ConverterConfigHandler;
import com.sun.faces.application.annotation.ListenerForScanner;
import com.sun.faces.application.annotation.ManagedBeanConfigHandler;
import com.sun.faces.application.annotation.RenderKitConfigHandler;
import com.sun.faces.application.annotation.ResourceDependencyScanner;
import com.sun.faces.application.annotation.RuntimeAnnotationHandler;
import com.sun.faces.application.annotation.Scanner;
import com.sun.faces.application.annotation.ValidatorConfigHandler;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.render.Renderer;
import javax.faces.validator.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationManager {
    private static final Logger LOGGER = FacesLogger.APPLICATION.getLogger();
    private static final Scanner RESOURCE_DEPENDENCY_SCANNER = new ResourceDependencyScanner();
    private static final Scanner LISTENER_FOR_SCANNER = new ListenerForScanner();
    private static final Scanner[] UICOMPONENT_SCANNERS = new Scanner[]{RESOURCE_DEPENDENCY_SCANNER, LISTENER_FOR_SCANNER};
    private static final Scanner[] VALIDATOR_SCANNERS = new Scanner[]{RESOURCE_DEPENDENCY_SCANNER};
    private static final Scanner[] CONVERTER_SCANNERS = new Scanner[]{RESOURCE_DEPENDENCY_SCANNER};
    private static final Scanner[] RENDERER_SCANNERS = new Scanner[]{RESOURCE_DEPENDENCY_SCANNER, LISTENER_FOR_SCANNER};
    private ConcurrentMap<Class<?>, Future<Map<Class<? extends Annotation>, RuntimeAnnotationHandler>>> cache = new ConcurrentHashMap(40, 0.75f, 32);

    public void applyConfigAnntations(FacesContext ctx, Collection<String> annotatedClasses) {
        if (!annotatedClasses.isEmpty()) {
            Map<Class<? extends Annotation>, ConfigAnnotationHandler> handlers = this.getConfigAnnotationHandlers();
            for (String className : annotatedClasses) {
                try {
                    Annotation[] annotations;
                    Class c = Util.loadClass(className, this);
                    for (Annotation annotation : annotations = c.getAnnotations()) {
                        ConfigAnnotationHandler handler = handlers.get(annotation.annotationType());
                        if (handler == null) continue;
                        handler.collect(c, annotation);
                    }
                }
                catch (ClassNotFoundException cnfe) {
                    throw new FacesException((Throwable)cnfe);
                }
            }
            for (ConfigAnnotationHandler handler : handlers.values()) {
                handler.push(ctx);
            }
        }
    }

    public void applyComponentAnnotations(FacesContext ctx, UIComponent c) {
        this.applyAnnotations(ctx, c.getClass(), ProcessingTarget.UIComponent, c);
    }

    public void applyValidatorAnnotations(FacesContext ctx, Validator v) {
        this.applyAnnotations(ctx, v.getClass(), ProcessingTarget.Validator, v);
    }

    public void applyConverterAnnotations(FacesContext ctx, Converter c) {
        this.applyAnnotations(ctx, c.getClass(), ProcessingTarget.Converter, c);
    }

    public void applyRendererAnnotations(FacesContext ctx, Renderer r, UIComponent c) {
        this.applyAnnotations(ctx, r.getClass(), ProcessingTarget.Renderer, r, c);
    }

    private Map<Class<? extends Annotation>, ConfigAnnotationHandler> getConfigAnnotationHandlers() {
        ConfigAnnotationHandler[] handlers = new ConfigAnnotationHandler[]{new ComponentConfigHandler(), new ConverterConfigHandler(), new ValidatorConfigHandler(), new RenderKitConfigHandler(), new ManagedBeanConfigHandler()};
        HashMap<Class<? extends Annotation>, ConfigAnnotationHandler> handlerMap = new HashMap<Class<? extends Annotation>, ConfigAnnotationHandler>();
        for (ConfigAnnotationHandler handler : handlers) {
            Collection<Class<? extends Annotation>> handledClasses = handler.getHandledAnnotations();
            for (Class<? extends Annotation> handled : handledClasses) {
                handlerMap.put(handled, handler);
            }
        }
        return handlerMap;
    }

    private void applyAnnotations(FacesContext ctx, Class<?> targetClass, ProcessingTarget processingTarget, Object ... params) {
        Map<Class<? extends Annotation>, RuntimeAnnotationHandler> map = this.getHandlerMap(targetClass, processingTarget);
        if (map != null && !map.isEmpty()) {
            for (RuntimeAnnotationHandler handler : map.values()) {
                handler.apply(ctx, params);
            }
        }
    }

    /*
     * Loose catch block
     */
    private Map<Class<? extends Annotation>, RuntimeAnnotationHandler> getHandlerMap(Class<?> targetClass, ProcessingTarget processingTarget) {
        while (true) {
            ProcessAnnotationsTask t;
            FutureTask<Map<Class<? extends Annotation>, RuntimeAnnotationHandler>> ft;
            FutureTask<Map<Class<? extends Annotation>, RuntimeAnnotationHandler>> f;
            if ((f = (FutureTask<Map<Class<? extends Annotation>, RuntimeAnnotationHandler>>)this.cache.get(targetClass)) == null && (f = (Future)this.cache.putIfAbsent(targetClass, ft = new FutureTask<Map<Class<? extends Annotation>, RuntimeAnnotationHandler>>(t = new ProcessAnnotationsTask(targetClass, processingTarget.scanners)))) == null) {
                f = ft;
                ft.run();
            }
            try {
                return (Map)f.get();
            }
            catch (CancellationException ce) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.log(Level.FINEST, ce.toString(), ce);
                }
                this.cache.remove(targetClass);
                continue;
            }
            catch (InterruptedException ie) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.log(Level.FINEST, ie.toString(), ie);
                }
                this.cache.remove(targetClass);
                continue;
            }
            break;
        }
        catch (ExecutionException ee) {
            throw new FacesException((Throwable)ee);
        }
    }

    static /* synthetic */ Scanner[] access$000() {
        return UICOMPONENT_SCANNERS;
    }

    static /* synthetic */ Scanner[] access$100() {
        return VALIDATOR_SCANNERS;
    }

    static /* synthetic */ Scanner[] access$200() {
        return CONVERTER_SCANNERS;
    }

    static /* synthetic */ Scanner[] access$300() {
        return RENDERER_SCANNERS;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ProcessAnnotationsTask
    implements Callable<Map<Class<? extends Annotation>, RuntimeAnnotationHandler>> {
        private static final Map<Class<? extends Annotation>, RuntimeAnnotationHandler> EMPTY = Collections.EMPTY_MAP;
        private Class<?> clazz;
        private Scanner[] scanners;

        public ProcessAnnotationsTask(Class<?> clazz, Scanner[] scanners) {
            this.clazz = clazz;
            this.scanners = scanners;
        }

        @Override
        public Map<Class<? extends Annotation>, RuntimeAnnotationHandler> call() throws Exception {
            Map<Class<? extends Annotation>, RuntimeAnnotationHandler> map = null;
            for (Scanner scanner : this.scanners) {
                RuntimeAnnotationHandler handler = scanner.scan(this.clazz);
                if (handler == null) continue;
                if (map == null) {
                    map = new HashMap<Class<? extends Annotation>, RuntimeAnnotationHandler>(2, 1.0f);
                }
                map.put(scanner.getAnnotation(), handler);
            }
            return map != null ? map : EMPTY;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ProcessingTarget {
        UIComponent(AnnotationManager.access$000()),
        Validator(AnnotationManager.access$100()),
        Converter(AnnotationManager.access$200()),
        Renderer(AnnotationManager.access$300());

        private Scanner[] scanners;

        private ProcessingTarget(Scanner[] scanners) {
            this.scanners = scanners;
        }
    }
}

