/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.view;

import com.sun.faces.application.view.WriteBehindStateWriter;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.Util;
import java.awt.event.ActionEvent;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ExpressionFactory;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.ViewHandler;
import javax.faces.component.ActionSource2;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionListener;
import javax.faces.event.MethodExpressionActionListener;
import javax.faces.event.MethodExpressionValueChangeListener;
import javax.faces.event.ValueChangeEvent;
import javax.faces.event.ValueChangeListener;
import javax.faces.validator.MethodExpressionValidator;
import javax.faces.validator.Validator;
import javax.faces.webapp.pdl.ActionSource2AttachedObjectHandler;
import javax.faces.webapp.pdl.ActionSource2AttachedObjectTarget;
import javax.faces.webapp.pdl.AttachedObjectHandler;
import javax.faces.webapp.pdl.AttachedObjectTarget;
import javax.faces.webapp.pdl.EditableValueHolderAttachedObjectHandler;
import javax.faces.webapp.pdl.EditableValueHolderAttachedObjectTarget;
import javax.faces.webapp.pdl.PageDeclarationLanguage;
import javax.faces.webapp.pdl.PageDeclarationLanguageFactory;
import javax.faces.webapp.pdl.ValueHolderAttachedObjectHandler;
import javax.faces.webapp.pdl.ValueHolderAttachedObjectTarget;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiViewHandler
extends ViewHandler {
    private static final Logger logger = FacesLogger.APPLICATION.getLogger();
    private String[] configuredExtensions;
    private PageDeclarationLanguageFactory pdlFactory;

    public MultiViewHandler() {
        WebConfiguration config = WebConfiguration.getInstance();
        String defaultSuffixConfig = config.getOptionValue(WebConfiguration.WebContextInitParameter.DefaultSuffix);
        this.configuredExtensions = Util.split(defaultSuffixConfig, " ");
        this.pdlFactory = (PageDeclarationLanguageFactory)FactoryFinder.getFactory((String)"javax.faces.webapp.pdl.PageDeclarationLanguageFactory");
    }

    public void initView(FacesContext context) throws FacesException {
        if (context.getExternalContext().getRequestCharacterEncoding() == null) {
            super.initView(context);
        }
    }

    public void renderView(FacesContext context, UIViewRoot viewToRender) throws IOException, FacesException {
        Util.notNull("context", context);
        Util.notNull("viewToRender", viewToRender);
        this.pdlFactory.getPageDeclarationLanguage(viewToRender.getViewId()).renderView(context, viewToRender);
    }

    public UIViewRoot restoreView(FacesContext context, String viewId) {
        Util.notNull("context", context);
        String actualViewId = this.derivePhysicalViewId(context, viewId);
        return this.pdlFactory.getPageDeclarationLanguage(actualViewId).restoreView(context, actualViewId);
    }

    public void retargetAttachedObjects(FacesContext context, UIComponent topLevelComponent, List<AttachedObjectHandler> handlers) {
        BeanInfo componentBeanInfo = (BeanInfo)topLevelComponent.getAttributes().get("javax.faces.component.BEANINFO_KEY");
        if (null == componentBeanInfo) {
            return;
        }
        BeanDescriptor componentDescriptor = componentBeanInfo.getBeanDescriptor();
        List targetList = (List)componentDescriptor.getValue("javax.faces.webapp.pdl.AttachedObjectTargets");
        List targetComponents = null;
        boolean foundMatch = false;
        block0: for (AttachedObjectHandler curHandler : handlers) {
            String forAttributeValue = curHandler.getFor();
            foundMatch = false;
            for (AttachedObjectTarget curTarget : targetList) {
                if (foundMatch) continue block0;
                String curTargetName = curTarget.getName();
                targetComponents = curTarget.getTargets(topLevelComponent);
                if (curHandler instanceof ActionSource2AttachedObjectHandler && curTarget instanceof ActionSource2AttachedObjectTarget) {
                    if (!forAttributeValue.equals(curTargetName)) continue;
                    for (UIComponent curTargetComponent : targetComponents) {
                        curHandler.applyAttachedObject(context, curTargetComponent);
                        foundMatch = true;
                    }
                    continue;
                }
                if (curHandler instanceof EditableValueHolderAttachedObjectHandler && curTarget instanceof EditableValueHolderAttachedObjectTarget) {
                    if (!forAttributeValue.equals(curTargetName)) continue;
                    for (UIComponent curTargetComponent : targetComponents) {
                        curHandler.applyAttachedObject(context, curTargetComponent);
                        foundMatch = true;
                    }
                    continue;
                }
                if (!(curHandler instanceof ValueHolderAttachedObjectHandler) || !(curTarget instanceof ValueHolderAttachedObjectTarget) || !forAttributeValue.equals(curTargetName)) continue;
                for (UIComponent curTargetComponent : targetComponents) {
                    curHandler.applyAttachedObject(context, curTargetComponent);
                    foundMatch = true;
                }
            }
        }
    }

    public void retargetMethodExpressions(FacesContext context, UIComponent topLevelComponent) {
        BeanInfo componentBeanInfo = (BeanInfo)topLevelComponent.getAttributes().get("javax.faces.component.BEANINFO_KEY");
        if (null == componentBeanInfo) {
            return;
        }
        PropertyDescriptor[] attributes = componentBeanInfo.getPropertyDescriptors();
        String targets = null;
        String attrName = null;
        String strValue = null;
        String methodSignature = null;
        UIComponent target = null;
        ExpressionFactory expressionFactory = null;
        ValueExpression valueExpression = null;
        MethodExpression toApply = null;
        Class expectedReturnType = null;
        Class[] expectedParameters = null;
        for (PropertyDescriptor cur : attributes) {
            String[] targetIds;
            valueExpression = (ValueExpression)cur.getValue("type");
            if (null != valueExpression || null == (valueExpression = (ValueExpression)cur.getValue("method-signature")) || null == (methodSignature = (String)valueExpression.getValue(context.getELContext()))) continue;
            valueExpression = (ValueExpression)cur.getValue("targets");
            if (null != valueExpression) {
                targets = (String)valueExpression.getValue(context.getELContext());
            }
            if (null == targets) {
                targets = cur.getName();
            }
            if (null == targets || 0 == targets.length()) {
                logger.severe("Unable to retarget MethodExpression: " + methodSignature);
                continue;
            }
            for (String curTarget : targetIds = targets.split(" ")) {
                int j;
                int i;
                block26: {
                    attrName = cur.getName();
                    valueExpression = (ValueExpression)topLevelComponent.getAttributes().get(attrName);
                    if (null == valueExpression) {
                        logger.severe("Unable to find attribute with name \"" + attrName + "\" in top level component in consuming page.  " + "Page author error.");
                        continue;
                    }
                    if (null == expressionFactory) {
                        expressionFactory = context.getApplication().getExpressionFactory();
                    }
                    boolean isAction = false;
                    boolean isActionListener = false;
                    boolean isValidator = false;
                    boolean isValueChangeListener = false;
                    isAction = attrName.equals("action");
                    if (isAction || (isActionListener = attrName.equals("actionListener")) || (isValidator = attrName.equals("validator")) || (isValueChangeListener = attrName.equals("valueChangeListener"))) {
                        target = topLevelComponent.findComponent(curTarget);
                        if (null == targets) {
                            logger.severe("Unable to retarget MethodExpression.  Unable to find inner component with id " + targets + ".");
                            continue;
                        }
                        if (isAction) {
                            expectedReturnType = Object.class;
                            expectedParameters = new Class[]{};
                            toApply = expressionFactory.createMethodExpression(context.getELContext(), valueExpression.getExpressionString(), expectedReturnType, expectedParameters);
                            ((ActionSource2)target).setActionExpression(toApply);
                            continue;
                        }
                        if (isActionListener) {
                            expectedReturnType = Void.TYPE;
                            expectedParameters = new Class[]{ActionEvent.class};
                            toApply = expressionFactory.createMethodExpression(context.getELContext(), valueExpression.getExpressionString(), expectedReturnType, expectedParameters);
                            ((ActionSource2)target).addActionListener((ActionListener)new MethodExpressionActionListener(toApply));
                            continue;
                        }
                        if (isValidator) {
                            expectedReturnType = Void.TYPE;
                            expectedParameters = new Class[]{FacesContext.class, UIComponent.class, Object.class};
                            toApply = expressionFactory.createMethodExpression(context.getELContext(), valueExpression.getExpressionString(), expectedReturnType, expectedParameters);
                            ((EditableValueHolder)target).addValidator((Validator)new MethodExpressionValidator(toApply));
                            continue;
                        }
                        if (!isValueChangeListener) continue;
                        expectedReturnType = Void.TYPE;
                        expectedParameters = new Class[]{ValueChangeEvent.class};
                        toApply = expressionFactory.createMethodExpression(context.getELContext(), valueExpression.getExpressionString(), expectedReturnType, expectedParameters);
                        ((EditableValueHolder)target).addValueChangeListener((ValueChangeListener)new MethodExpressionValueChangeListener(toApply));
                        continue;
                    }
                    assert (null != methodSignature);
                    i = (methodSignature = methodSignature.trim()).indexOf(" ");
                    if (-1 != i) {
                        strValue = methodSignature.substring(0, i);
                        try {
                            expectedReturnType = Util.getTypeFromString(strValue);
                            break block26;
                        }
                        catch (ClassNotFoundException cnfe) {
                            logger.log(Level.SEVERE, "Unable to determine expected return type for " + methodSignature, cnfe);
                            continue;
                        }
                    }
                    logger.severe("Unable to determine expected return type for " + methodSignature);
                    continue;
                }
                i = methodSignature.indexOf("(");
                if (-1 != i && -1 != (j = methodSignature.indexOf(")", i + 1))) {
                    strValue = methodSignature.substring(i + 1, j);
                    if (0 < strValue.length()) {
                        String[] params = strValue.split(",");
                        expectedParameters = new Class[params.length];
                        boolean exceptionThrown = false;
                        for (i = 0; i < params.length; ++i) {
                            try {
                                expectedParameters[i] = Util.getTypeFromString(params[i]);
                                continue;
                            }
                            catch (ClassNotFoundException cnfe) {
                                logger.log(Level.SEVERE, "Unable to determine expected return type for " + methodSignature, cnfe);
                                exceptionThrown = true;
                                break;
                            }
                        }
                        if (exceptionThrown) {
                            continue;
                        }
                    } else {
                        expectedParameters = new Class[]{};
                    }
                }
                assert (null != expectedReturnType);
                assert (null != expectedParameters);
                toApply = expressionFactory.createMethodExpression(context.getELContext(), valueExpression.getExpressionString(), expectedReturnType, expectedParameters);
                topLevelComponent.getAttributes().put(attrName, toApply);
            }
        }
    }

    public UIViewRoot createView(FacesContext context, String viewId) {
        Util.notNull("context", context);
        String actualViewId = this.derivePhysicalViewId(context, viewId);
        return this.pdlFactory.getPageDeclarationLanguage(actualViewId).createView(context, actualViewId);
    }

    public Locale calculateLocale(FacesContext context) {
        Locale perf;
        Util.notNull("context", context);
        Locale result = null;
        Iterator locales = context.getExternalContext().getRequestLocales();
        while (locales.hasNext() && (result = this.findMatch(context, perf = (Locale)locales.next())) == null) {
        }
        if (result == null) {
            result = context.getApplication().getDefaultLocale() == null ? Locale.getDefault() : context.getApplication().getDefaultLocale();
        }
        return result;
    }

    public String calculateRenderKitId(FacesContext context) {
        Util.notNull("context", context);
        Map requestParamMap = context.getExternalContext().getRequestParameterMap();
        String result = (String)requestParamMap.get("javax.faces.RenderKitId");
        if (result == null && null == (result = context.getApplication().getDefaultRenderKitId())) {
            result = "HTML_BASIC";
        }
        return result;
    }

    public void writeState(FacesContext context) throws IOException {
        Util.notNull("context", context);
        if (!context.getPartialViewContext().isAjaxRequest()) {
            WriteBehindStateWriter writer;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Begin writing marker for viewId " + context.getViewRoot().getViewId());
            }
            if ((writer = WriteBehindStateWriter.getCurrentInstance()) != null) {
                writer.writingState();
            }
            context.getResponseWriter().write("~com.sun.faces.saveStateFieldMarker~");
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("End writing marker for viewId " + context.getViewRoot().getViewId());
            }
        }
    }

    public String getActionURL(FacesContext context, String viewId) {
        Util.notNull("context", context);
        Util.notNull("viewId", viewId);
        if (viewId.charAt(0) != '/') {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.ILLEGAL_VIEW_ID", viewId);
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "jsf.illegal_view_id_error", viewId);
            }
            throw new IllegalArgumentException(message);
        }
        ExternalContext extContext = context.getExternalContext();
        String contextPath = extContext.getRequestContextPath();
        String mapping = Util.getFacesMapping(context);
        if (mapping == null) {
            return contextPath + viewId;
        }
        if (Util.isPrefixMapped(mapping)) {
            if (mapping.equals("/*")) {
                return contextPath + viewId;
            }
            return contextPath + mapping + viewId;
        }
        int period = viewId.lastIndexOf(46);
        if (period < 0) {
            return contextPath + viewId + mapping;
        }
        if (!viewId.endsWith(mapping)) {
            return contextPath + viewId.substring(0, period) + mapping;
        }
        return contextPath + viewId;
    }

    public String getResourceURL(FacesContext context, String path) {
        ExternalContext extContext = context.getExternalContext();
        if (path.charAt(0) == '/') {
            return extContext.getRequestContextPath() + path;
        }
        return path;
    }

    public PageDeclarationLanguage getPageDeclarationLanguage(FacesContext context, String viewId) {
        String actualViewId = this.derivePhysicalViewId(context, viewId);
        return this.pdlFactory.getPageDeclarationLanguage(actualViewId);
    }

    protected Locale findMatch(FacesContext context, Locale pref) {
        Locale defaultLocale;
        Locale result = null;
        Iterator it = context.getApplication().getSupportedLocales();
        while (it.hasNext()) {
            Locale supportedLocale = (Locale)it.next();
            if (pref.equals(supportedLocale)) {
                result = supportedLocale;
                break;
            }
            if (!pref.getLanguage().equals(supportedLocale.getLanguage()) || supportedLocale.getCountry().length() != 0) continue;
            result = supportedLocale;
        }
        if (null == result && (defaultLocale = context.getApplication().getDefaultLocale()) != null) {
            if (pref.equals(defaultLocale)) {
                result = defaultLocale;
            } else if (pref.getLanguage().equals(defaultLocale.getLanguage()) && defaultLocale.getCountry().length() == 0) {
                result = defaultLocale;
            }
        }
        return result;
    }

    protected String normalizeRequestURI(String uri, String mapping) {
        if (mapping == null || !Util.isPrefixMapped(mapping)) {
            return uri;
        }
        int length = mapping.length() + 1;
        StringBuilder builder = new StringBuilder(length);
        builder.append(mapping).append('/');
        String mappingMod = builder.toString();
        boolean logged = false;
        while (uri.startsWith(mappingMod)) {
            if (!logged && logger.isLoggable(Level.WARNING)) {
                logged = true;
                logger.log(Level.WARNING, "jsf.viewhandler.requestpath.recursion", new Object[]{uri, mapping});
            }
            uri = uri.substring(length - 1);
        }
        return uri;
    }

    protected void send404Error(FacesContext context) {
        HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
        try {
            context.responseComplete();
            response.sendError(404);
        }
        catch (IOException ioe) {
            throw new FacesException((Throwable)ioe);
        }
    }

    protected String convertViewId(FacesContext context, String viewId) {
        StringBuilder buffer = new StringBuilder(viewId);
        for (String ext : this.configuredExtensions) {
            if (viewId.endsWith(ext)) {
                return viewId;
            }
            int extIdx = viewId.lastIndexOf(46);
            if (extIdx != -1) {
                buffer.replace(extIdx, viewId.length(), ext);
            } else {
                buffer.append(ext);
            }
            String convertedViewId = buffer.toString();
            try {
                if (context.getExternalContext().getResource(convertedViewId) != null) {
                    return convertedViewId;
                }
                buffer.setLength(0);
                buffer.append(viewId);
            }
            catch (MalformedURLException e) {
                if (!logger.isLoggable(Level.SEVERE)) continue;
                logger.log(Level.SEVERE, e.toString(), e);
            }
        }
        return viewId;
    }

    protected String derivePhysicalViewId(FacesContext ctx, String viewId) {
        String mapping;
        if (viewId != null && (mapping = Util.getFacesMapping(ctx)) != null) {
            if (!Util.isPrefixMapped(mapping)) {
                viewId = this.convertViewId(ctx, viewId);
            } else if ((viewId = this.normalizeRequestURI(viewId, mapping)).equals(mapping)) {
                this.send404Error(ctx);
            }
        }
        return viewId;
    }
}

