/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.context;

import com.sun.faces.util.FacesLogger;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.ExceptionHandler;
import javax.faces.context.ExceptionHandlerWrapper;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialResponseWriter;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ExceptionEvent;
import javax.faces.event.ExceptionEventContext;
import javax.faces.event.PhaseId;
import javax.faces.event.SystemEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AjaxExceptionHandlerImpl
extends ExceptionHandlerWrapper {
    private static final Logger LOGGER = FacesLogger.CONTEXT.getLogger();
    private static final String LOG_BEFORE_KEY = "jsf.context.exception.handler.log_before";
    private static final String LOG_AFTER_KEY = "jsf.context.exception.handler.log_after";
    private static final String LOG_KEY = "jsf.context.exception.handler.log";
    private LinkedList<ExceptionEvent> unhandledExceptions;
    private LinkedList<ExceptionEvent> handledExceptions;
    private ExceptionEvent handled;
    private ExceptionHandler exceptionHandler = null;

    public AjaxExceptionHandlerImpl(ExceptionHandler handler) {
        this.exceptionHandler = handler;
    }

    public ExceptionHandler getWrapped() {
        return this.exceptionHandler;
    }

    public ExceptionEvent getHandledExceptionEvent() {
        return this.handled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle() throws FacesException {
        Iterator<ExceptionEvent> i = this.getUnhandledExceptionEvents().iterator();
        while (i.hasNext()) {
            ExceptionEvent event = i.next();
            ExceptionEventContext context = (ExceptionEventContext)event.getSource();
            try {
                Throwable t = context.getException();
                if (this.isRethrown(t)) {
                    this.handled = event;
                    Throwable unwrapped = this.getRootCause(t);
                    if (unwrapped != null) {
                        this.handlePartialResponseError(context.getContext(), unwrapped);
                        continue;
                    }
                    if (t instanceof FacesException) {
                        this.handlePartialResponseError(context.getContext(), t);
                        continue;
                    }
                    this.handlePartialResponseError(context.getContext(), new FacesException(t.getMessage(), t));
                    continue;
                }
                this.log(context);
            }
            finally {
                if (this.handledExceptions == null) {
                    this.handledExceptions = new LinkedList();
                }
                this.handledExceptions.add(event);
                i.remove();
            }
        }
    }

    public void processEvent(SystemEvent event) throws AbortProcessingException {
        if (event != null) {
            if (this.unhandledExceptions == null) {
                this.unhandledExceptions = new LinkedList();
            }
            this.unhandledExceptions.add((ExceptionEvent)event);
        }
    }

    public Iterable<ExceptionEvent> getUnhandledExceptionEvents() {
        return this.unhandledExceptions != null ? this.unhandledExceptions : Collections.emptyList();
    }

    public Iterable<ExceptionEvent> getHandledExceptionEvents() {
        return this.handledExceptions != null ? this.handledExceptions : Collections.emptyList();
    }

    private void handlePartialResponseError(FacesContext context, Throwable t) {
        block4: {
            try {
                PartialResponseWriter writer = context.getPartialViewContext().getPartialResponseWriter();
                writer.startDocument();
                writer.startError(t.getClass().toString());
                if (t.getCause() != null) {
                    writer.write(t.getCause().getMessage());
                } else {
                    writer.write(t.getMessage());
                }
                writer.endError();
                writer.endDocument();
                context.responseComplete();
            }
            catch (IOException ioe) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block4;
                LOGGER.log(Level.SEVERE, ioe.toString(), ioe);
            }
        }
    }

    private boolean isRethrown(Throwable t) {
        return !(t instanceof AbortProcessingException);
    }

    private void log(ExceptionEventContext exceptionContext) {
        UIComponent c = exceptionContext.getComponent();
        boolean beforePhase = exceptionContext.inBeforePhase();
        boolean afterPhase = exceptionContext.inAfterPhase();
        PhaseId phaseId = exceptionContext.getPhaseId();
        Throwable t = exceptionContext.getException();
        String key = this.getLoggingKey(beforePhase, afterPhase);
        if (LOGGER.isLoggable(Level.SEVERE)) {
            LOGGER.log(Level.SEVERE, key, new Object[]{t.getClass().getName(), phaseId.toString(), c != null ? c.getClientId(exceptionContext.getContext()) : "", t.getMessage()});
            LOGGER.log(Level.SEVERE, t.getMessage(), t);
        }
    }

    private String getLoggingKey(boolean beforePhase, boolean afterPhase) {
        if (beforePhase) {
            return LOG_BEFORE_KEY;
        }
        if (afterPhase) {
            return LOG_AFTER_KEY;
        }
        return LOG_KEY;
    }
}

