/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.tag;

import com.sun.faces.facelets.tag.TagLibrary;
import com.sun.faces.facelets.tag.jsf.CompositeComponentTagLibrary;
import com.sun.faces.util.Util;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.application.ProjectStage;
import javax.faces.context.FacesContext;
import javax.faces.webapp.pdl.facelets.tag.TagConfig;
import javax.faces.webapp.pdl.facelets.tag.TagHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CompositeTagLibrary
implements TagLibrary {
    private TagLibrary[] libraries;

    public CompositeTagLibrary(TagLibrary[] libraries) {
        Util.notNull("libraries", libraries);
        this.libraries = libraries;
    }

    @Override
    public boolean containsNamespace(String ns) {
        boolean result = true;
        for (int i = 0; i < this.libraries.length; ++i) {
            if (!this.libraries[i].containsNamespace(ns)) continue;
            return true;
        }
        CompositeComponentTagLibrary toTest = new CompositeComponentTagLibrary(ns);
        if (toTest.tagLibraryForNSExists(ns)) {
            TagLibrary[] librariesPlusOne = new TagLibrary[this.libraries.length + 1];
            System.arraycopy(this.libraries, 0, librariesPlusOne, 0, this.libraries.length);
            librariesPlusOne[this.libraries.length] = new CompositeComponentTagLibrary(ns);
            for (int i = 0; i < this.libraries.length; ++i) {
                this.libraries[i] = null;
            }
            this.libraries = librariesPlusOne;
            return true;
        }
        FacesContext context = FacesContext.getCurrentInstance();
        if (ProjectStage.Development == context.getApplication().getProjectStage() && !ns.equals("http://www.w3.org/1999/xhtml") && !this.getNamespaceMessageMap(context).containsKey(ns)) {
            context.addMessage(null, new FacesMessage(FacesMessage.SEVERITY_WARN, "Warning: This page calls for XML namespace " + ns + " but no taglibrary exists for that namespace.", ""));
            this.getNamespaceMessageMap(context).put(ns, Boolean.TRUE);
        }
        return false;
    }

    private Map<String, Boolean> getNamespaceMessageMap(FacesContext context) {
        HashMap result = null;
        result = (HashMap)context.getAttributes().get("facelets.namespaceMessageMap");
        if (null == result) {
            result = new HashMap();
            context.getAttributes().put("facelets.namespaceMessageMap", result);
        }
        return result;
    }

    @Override
    public boolean containsTagHandler(String ns, String localName) {
        for (int i = 0; i < this.libraries.length; ++i) {
            if (!this.libraries[i].containsTagHandler(ns, localName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public TagHandler createTagHandler(String ns, String localName, TagConfig tag) throws FacesException {
        for (int i = 0; i < this.libraries.length; ++i) {
            if (!this.libraries[i].containsTagHandler(ns, localName)) continue;
            return this.libraries[i].createTagHandler(ns, localName, tag);
        }
        return null;
    }

    @Override
    public boolean containsFunction(String ns, String name) {
        for (int i = 0; i < this.libraries.length; ++i) {
            if (!this.libraries[i].containsFunction(ns, name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Method createFunction(String ns, String name) {
        for (int i = 0; i < this.libraries.length; ++i) {
            if (!this.libraries[i].containsFunction(ns, name)) continue;
            return this.libraries[i].createFunction(ns, name);
        }
        return null;
    }
}

