/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.scripting;

import com.sun.faces.scripting.GroovyHelper;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import groovy.util.GroovyScriptEngine;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GroovyHelperImpl
extends GroovyHelper {
    private static final Logger LOGGER = FacesLogger.APPLICATION.getLogger();
    private static final String SCRIPT_PATH = "/WEB-INF/groovy/";
    private MojarraGroovyClassLoader loader;

    GroovyHelperImpl() throws Exception {
        FacesContext ctx = FacesContext.getCurrentInstance();
        ExternalContext extContext = ctx.getExternalContext();
        ClassLoader curLoader = Thread.currentThread().getContextClassLoader();
        URL[] combinedRoots = this.getResourceRoots(extContext, curLoader);
        if (0 < combinedRoots.length) {
            GroovyScriptEngine engine = new GroovyScriptEngine(combinedRoots, curLoader);
            this.loader = new MojarraGroovyClassLoader(engine);
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, "Groovy support enabled.");
            }
            extContext.getApplicationMap().put("com.sun.faces.groovyhelper", this);
        }
    }

    private URL[] getResourceRoots(ExternalContext extContext, ClassLoader curLoader) throws IOException {
        URL[] combinedRoots = null;
        Enumeration<URL> classpathResourceEnumeration = curLoader.getResources("META-INF/resources/");
        ArrayList<URL> classpathResourceList = new ArrayList<URL>();
        while (classpathResourceEnumeration.hasMoreElements()) {
            classpathResourceList.add(classpathResourceEnumeration.nextElement());
        }
        URL u = extContext.getResource(SCRIPT_PATH);
        URL[] webappRoots = this.getWebappResourceRoots(extContext);
        URL[] classpathRoots = new URL[classpathResourceList.size()];
        classpathResourceList.toArray(classpathRoots);
        if (null != u || 0 < webappRoots.length || 0 < classpathRoots.length) {
            combinedRoots = new URL[webappRoots.length + classpathRoots.length + (null != u ? 1 : 0)];
            System.arraycopy(webappRoots, 0, combinedRoots, 0, webappRoots.length);
            System.arraycopy(classpathRoots, 0, combinedRoots, webappRoots.length, classpathRoots.length);
            if (null != u) {
                combinedRoots[webappRoots.length + classpathRoots.length] = u;
            }
        } else {
            combinedRoots = new URL[]{};
        }
        return combinedRoots;
    }

    private URL[] getWebappResourceRoots(ExternalContext extContext) {
        URL[] result = null;
        int size = 0;
        int i = 0;
        Set resourceRoots = extContext.getResourcePaths("/resources/");
        if (null != resourceRoots && !resourceRoots.isEmpty()) {
            for (String cur : resourceRoots) {
                if (!cur.endsWith("/")) continue;
                ++size;
            }
            result = new URL[size];
            for (String cur : resourceRoots) {
                if (!cur.endsWith("/")) continue;
                try {
                    result[i++] = extContext.getResource(cur);
                }
                catch (MalformedURLException ex) {
                    Logger.getLogger(GroovyHelperImpl.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        if (null == result) {
            result = new URL[]{};
        }
        return result;
    }

    private URL[] getClasspathResourceRoots() {
        URL[] result = null;
        return result;
    }

    @Override
    public void addURL(URL toAdd) {
        this.loader.getGroovyScriptEngine().getGroovyClassLoader().addURL(toAdd);
    }

    @Override
    public Class<?> loadScript(String name) {
        try {
            String script = name;
            if (script.endsWith(".groovy")) {
                script = script.substring(0, script.indexOf(".groovy"));
            }
            return Util.loadClass(script, this);
        }
        catch (Exception e) {
            throw new FacesException((Throwable)e);
        }
    }

    @Override
    public void setClassLoader() {
        Thread.currentThread().setContextClassLoader(this.loader);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MojarraGroovyClassLoader
    extends URLClassLoader {
        private GroovyScriptEngine gse;

        public MojarraGroovyClassLoader(GroovyScriptEngine gse) {
            super(new URL[0], (ClassLoader)gse.getGroovyClassLoader());
            this.gse = gse;
        }

        public GroovyScriptEngine getGroovyScriptEngine() {
            return this.gse;
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            Class c;
            if (name == null) {
                throw new NullPointerException();
            }
            try {
                c = this.gse.getGroovyClassLoader().getParent().loadClass(name);
            }
            catch (ClassNotFoundException cnfe) {
                try {
                    c = this.gse.loadScriptByName(name);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            if (c == null) {
                throw new ClassNotFoundException(name);
            }
            return c;
        }
    }
}

