/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.tag;

import com.sun.faces.facelets.el.ELText;
import com.sun.faces.facelets.el.TagMethodExpression;
import com.sun.faces.facelets.el.TagValueExpression;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ExpressionFactory;
import javax.el.MethodExpression;
import javax.el.MethodInfo;
import javax.el.ValueExpression;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.webapp.pdl.facelets.FaceletContext;
import javax.faces.webapp.pdl.facelets.tag.Location;
import javax.faces.webapp.pdl.facelets.tag.TagAttribute;
import javax.faces.webapp.pdl.facelets.tag.TagAttributeException;

public final class TagAttributeImpl
extends TagAttribute {
    private final boolean literal;
    private final String localName;
    private final Location location;
    private final String namespace;
    private final String qName;
    private final String value;
    private String string;

    public TagAttributeImpl(Location location, String ns, String localName, String qName, String value) {
        this.location = location;
        this.namespace = ns;
        this.localName = localName;
        this.qName = qName;
        this.value = value;
        try {
            this.literal = ELText.isLiteral(this.value);
        }
        catch (ELException e) {
            throw new TagAttributeException((TagAttribute)this, (Throwable)e);
        }
    }

    public boolean getBoolean(FaceletContext ctx) {
        if (this.literal) {
            return Boolean.valueOf(this.value);
        }
        return (Boolean)this.getObject(ctx, Boolean.class);
    }

    public int getInt(FaceletContext ctx) {
        if (this.literal) {
            return Integer.parseInt(this.value);
        }
        return ((Number)this.getObject(ctx, Integer.class)).intValue();
    }

    public String getLocalName() {
        return this.localName;
    }

    public Location getLocation() {
        return this.location;
    }

    public MethodExpression getMethodExpression(FaceletContext ctx, Class type, Class[] paramTypes) {
        MethodExpression result = null;
        String specialPrefix = "#{compositeComponent.attrs.";
        int specialPrefixLen = "#{compositeComponent.attrs.".length();
        try {
            ExpressionFactory f = ctx.getExpressionFactory();
            if (this.value.startsWith("#{compositeComponent.attrs.") && specialPrefixLen < this.value.length() && -1 == this.value.indexOf(".", specialPrefixLen)) {
                String attrName = this.value.substring(specialPrefixLen, this.value.length() - 1);
                result = new AttributeLookupMethodExpression(this.value, attrName);
            }
            if (null == result) {
                result = new TagMethodExpression(this, f.createMethodExpression((ELContext)ctx, this.value, type, paramTypes));
            }
        }
        catch (Exception e) {
            throw new TagAttributeException((TagAttribute)this, (Throwable)e);
        }
        return result;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Object getObject(FaceletContext ctx) {
        return this.getObject(ctx, Object.class);
    }

    public String getQName() {
        return this.qName;
    }

    public String getValue() {
        return this.value;
    }

    public String getValue(FaceletContext ctx) {
        if (this.literal) {
            return this.value;
        }
        return (String)this.getObject(ctx, String.class);
    }

    public Object getObject(FaceletContext ctx, Class type) {
        if (this.literal) {
            if (String.class.equals((Object)type)) {
                return this.value;
            }
            try {
                return ctx.getExpressionFactory().coerceToType((Object)this.value, type);
            }
            catch (Exception e) {
                throw new TagAttributeException((TagAttribute)this, (Throwable)e);
            }
        }
        ValueExpression ve = this.getValueExpression(ctx, type);
        try {
            return ve.getValue((ELContext)ctx);
        }
        catch (Exception e) {
            throw new TagAttributeException((TagAttribute)this, (Throwable)e);
        }
    }

    public ValueExpression getValueExpression(FaceletContext ctx, Class type) {
        try {
            ExpressionFactory f = ctx.getExpressionFactory();
            return new TagValueExpression(this, f.createValueExpression((ELContext)ctx, this.value, type));
        }
        catch (Exception e) {
            throw new TagAttributeException((TagAttribute)this, (Throwable)e);
        }
    }

    public boolean isLiteral() {
        return this.literal;
    }

    public String toString() {
        if (this.string == null) {
            this.string = this.location + " " + this.qName + "=\"" + this.value + "\"";
        }
        return this.string;
    }

    private static class AttributeLookupMethodExpression
    extends MethodExpression
    implements StateHolder {
        private String attrName = null;
        private String expressionString = null;
        private boolean isTransient = false;

        public AttributeLookupMethodExpression(String expressionString, String attrName) {
            if (null == expressionString || null == attrName) {
                throw new NullPointerException("null MethodExpression");
            }
            this.expressionString = expressionString;
            this.attrName = attrName;
        }

        public AttributeLookupMethodExpression() {
        }

        public boolean isTransient() {
            return this.isTransient;
        }

        public void setTransient(boolean isTransient) {
            this.isTransient = isTransient;
        }

        public void restoreState(FacesContext context, Object stateObj) {
            String[] state = (String[])stateObj;
            this.attrName = state[0];
            this.expressionString = state[1];
        }

        public Object saveState(FacesContext arg0) {
            String[] state = new String[]{this.attrName, this.expressionString};
            return state;
        }

        public MethodInfo getMethodInfo(ELContext arg0) {
            return null;
        }

        public Object invoke(ELContext elContext, Object[] arg1) {
            FacesContext context = (FacesContext)elContext.getContext(FacesContext.class);
            UIComponent composite = UIComponent.getCurrentCompositeComponent((FacesContext)context);
            MethodExpression me = (MethodExpression)composite.getAttributes().get(this.attrName);
            return me.invoke(elContext, arg1);
        }

        public String getExpressionString() {
            return this.expressionString;
        }

        public boolean equals(Object otherObj) {
            boolean result = false;
            if (otherObj instanceof AttributeLookupMethodExpression) {
                AttributeLookupMethodExpression other = (AttributeLookupMethodExpression)((Object)otherObj);
                result = this.expressionString.equals(other.expressionString);
            }
            return result;
        }

        public boolean isLiteralText() {
            return this.expressionString.startsWith("#{") && this.expressionString.endsWith("}");
        }

        public int hashCode() {
            return this.expressionString.hashCode();
        }
    }
}

