/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.resource;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.application.resource.ResourceInfo;
import com.sun.faces.application.resource.ResourceManager;
import com.sun.faces.util.Util;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.faces.application.Resource;
import javax.faces.context.FacesContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceImpl
extends Resource
implements Externalizable {
    private static final String RFC1123_DATE_PATTERN = "EEE, dd MMM yyyy HH:mm:ss zzz";
    private static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    private transient ResourceInfo resourceInfo;
    private transient Map<String, String> responseHeaders;
    private long initialTime;
    private long maxAge;

    public ResourceImpl() {
    }

    public ResourceImpl(ResourceInfo resourceInfo, String contentType, long initialTime, long maxAge) {
        this.resourceInfo = resourceInfo;
        super.setResourceName(resourceInfo.getName());
        super.setLibraryName(resourceInfo.getLibraryInfo() != null ? resourceInfo.getLibraryInfo().getName() : null);
        super.setContentType(contentType);
        this.initialTime = initialTime;
        this.maxAge = maxAge;
    }

    public InputStream getInputStream() throws IOException {
        return this.resourceInfo.getHelper().getInputStream(this.resourceInfo, FacesContext.getCurrentInstance());
    }

    public URL getURL() {
        FacesContext ctx = FacesContext.getCurrentInstance();
        return this.resourceInfo.getHelper().getURL(this.resourceInfo, ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getResponseHeaders() {
        if (this.isResourceRequest()) {
            if (this.responseHeaders == null) {
                this.responseHeaders = new HashMap<String, String>(6, 1.0f);
            }
            long expiresTime = new Date().getTime() + this.maxAge;
            SimpleDateFormat format = new SimpleDateFormat(RFC1123_DATE_PATTERN, Locale.US);
            format.setTimeZone(GMT);
            this.responseHeaders.put("Expires", format.format(new Date(expiresTime)));
            URL url = this.getURL();
            InputStream in = null;
            try {
                URLConnection conn = url.openConnection();
                conn.setUseCaches(false);
                conn.connect();
                in = conn.getInputStream();
                long lastModified = conn.getLastModified();
                long contentLength = conn.getContentLength();
                if (lastModified == 0L) {
                    lastModified = this.initialTime;
                }
                this.responseHeaders.put("Last-Modified", format.format(new Date(lastModified)));
                if (lastModified != 0L && contentLength != -1L) {
                    this.responseHeaders.put("ETag", "W/\"" + contentLength + '-' + lastModified + '\"');
                }
            }
            catch (IOException ignored) {
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ignored) {}
                }
            }
            return this.responseHeaders;
        }
        return Collections.emptyMap();
    }

    public String getRequestPath() {
        String localePrefix;
        FacesContext context = FacesContext.getCurrentInstance();
        String facesServletMapping = Util.getFacesMapping(context);
        String uri = Util.isPrefixMapped(facesServletMapping) ? facesServletMapping + "/javax.faces.resource" + '/' + this.getResourceName() : "/javax.faces.resource/" + this.getResourceName() + facesServletMapping;
        boolean queryStarted = false;
        if (null != this.getLibraryName()) {
            queryStarted = true;
            uri = uri + "?ln=" + this.getLibraryName();
        }
        String version = "";
        if (this.resourceInfo.getLibraryInfo() != null && this.resourceInfo.getLibraryInfo().getVersion() != null) {
            version = version + this.resourceInfo.getLibraryInfo().getVersion().toString();
        }
        if (this.resourceInfo.getVersion() != null) {
            version = version + this.resourceInfo.getVersion().toString();
        }
        if (version.length() > 0) {
            uri = uri + (queryStarted ? "&v=" : "?v=") + version;
        }
        if ((localePrefix = this.resourceInfo.getLocalePrefix()) != null) {
            uri = uri + (queryStarted ? "&loc=" : "?loc=") + localePrefix;
        }
        uri = context.getApplication().getViewHandler().getResourceURL(context, uri);
        return uri;
    }

    public boolean userAgentNeedsUpdate(FacesContext context) {
        Map requestHeaders = context.getExternalContext().getRequestHeaderMap();
        return !requestHeaders.containsKey("If-Modified-Since") || this.resourceInfo.getHelper().getLastModified(this.resourceInfo, context) > this.initialTime;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.getResourceName());
        out.writeObject(this.getLibraryName());
        out.writeObject(this.getContentType());
        out.writeLong(this.initialTime);
        out.writeLong(this.maxAge);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.setResourceName((String)in.readObject());
        this.setLibraryName((String)in.readObject());
        this.setContentType((String)in.readObject());
        this.initialTime = in.readLong();
        this.maxAge = in.readLong();
        ResourceManager manager = ApplicationAssociate.getInstance(FacesContext.getCurrentInstance().getExternalContext()).getResourceManager();
        this.resourceInfo = manager.findResource(this.getLibraryName(), this.getResourceName(), this.getContentType(), FacesContext.getCurrentInstance());
    }

    private boolean isResourceRequest() {
        FacesContext ctx = FacesContext.getCurrentInstance();
        return ctx.getApplication().getResourceHandler().isResourceRequest(ctx);
    }
}

