/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config.processor;

import com.sun.faces.config.DocumentInfo;
import com.sun.faces.config.processor.AbstractConfigProcessor;
import com.sun.faces.util.FacesLogger;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FactoryFinder;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LifecycleConfigProcessor
extends AbstractConfigProcessor {
    private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();
    private static final String LIFECYCLE = "lifecycle";
    private static final String PHASE_LISTENER = "phase-listener";

    public void process(DocumentInfo[] documentInfos) throws Exception {
        LifecycleFactory factory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
        for (int i = 0; i < documentInfos.length; ++i) {
            String namespace;
            Document document;
            NodeList lifecycles;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Processing lifecycle elements for document: ''{0}''", documentInfos[i].getSourceURL()));
            }
            if ((lifecycles = (document = documentInfos[i].getDocument()).getElementsByTagNameNS(namespace = document.getDocumentElement().getNamespaceURI(), LIFECYCLE)) == null) continue;
            int csize = lifecycles.getLength();
            for (int c = 0; c < csize; ++c) {
                Node n = lifecycles.item(c);
                if (n.getNodeType() != 1) continue;
                NodeList listeners = ((Element)n).getElementsByTagNameNS(namespace, PHASE_LISTENER);
                this.addPhaseListeners(factory, listeners);
            }
        }
        this.invokeNext(documentInfos);
    }

    private void addPhaseListeners(LifecycleFactory factory, NodeList phaseListeners) {
        if (phaseListeners != null && phaseListeners.getLength() > 0) {
            int size = phaseListeners.getLength();
            for (int i = 0; i < size; ++i) {
                Object plInstance;
                Node plNode = phaseListeners.item(i);
                String pl = this.getNodeText(plNode);
                if (pl == null || (plInstance = this.createInstance(pl, PhaseListener.class, null, plNode)) == null) continue;
                Iterator t = factory.getLifecycleIds();
                while (t.hasNext()) {
                    String lfId = (String)t.next();
                    Lifecycle lifecycle = factory.getLifecycle(lfId);
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, MessageFormat.format("Adding PhaseListener ''{0}'' to lifecycle ''{0}}", pl, lfId));
                    }
                    lifecycle.addPhaseListener((PhaseListener)plInstance);
                }
            }
        }
    }
}

