/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config.processor;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.config.ConfigurationException;
import com.sun.faces.config.DocumentInfo;
import com.sun.faces.config.processor.AbstractConfigProcessor;
import com.sun.faces.facelets.compiler.Compiler;
import com.sun.faces.facelets.tag.TagLibrary;
import com.sun.faces.facelets.tag.TagLibraryImpl;
import com.sun.faces.facelets.tag.jsf.CompositeComponentTagLibrary;
import com.sun.faces.facelets.util.ReflectionUtil;
import com.sun.faces.util.FacesLogger;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FaceletTaglibConfigProcessor
extends AbstractConfigProcessor {
    private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();
    private static final String LIBRARY_CLASS = "library-class";
    private static final String TAGLIB_NAMESPACE = "namespace";
    private static final String TAG = "tag";
    private static final String FUNCTION = "function";
    private static final String TAG_NAME = "tag-name";
    private static final String COMPONENT = "component";
    private static final String VALIDATOR = "validator";
    private static final String CONVERTER = "converter";
    private static final String BEHAVIOR = "behavior";
    private static final String SOURCE = "source";
    private static final String HANDLER_CLASS = "handler-class";
    private static final String VALIDATOR_ID = "validator-id";
    private static final String CONVERTER_ID = "converter-id";
    private static final String BEHAVIOR_ID = "behavior-id";
    private static final String COMPONENT_TYPE = "component-type";
    private static final String RENDERER_TYPE = "renderer-type";
    private static final String FUNCTION_NAME = "function-name";
    private static final String FUNCTION_CLASS = "function-class";
    private static final String FUNCTION_SIGNATURE = "function-signature";
    private static final String COMPOSITE_LIBRARY_NAME = "composite-library-name";

    public void process(DocumentInfo[] documentInfos) throws Exception {
        ApplicationAssociate associate = ApplicationAssociate.getInstance(FacesContext.getCurrentInstance().getExternalContext());
        assert (associate != null);
        Compiler compiler = associate.getCompiler();
        int length = documentInfos.length;
        for (int i = 0; i < length; ++i) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Processing facelet-taglibrary document: ''{0}''", documentInfos[i].getSourceURL()));
            }
            Document document = documentInfos[i].getDocument();
            String namespace = document.getDocumentElement().getNamespaceURI();
            Element documentElement = document.getDocumentElement();
            NodeList libraryClass = documentElement.getElementsByTagNameNS(namespace, LIBRARY_CLASS);
            if (libraryClass != null && libraryClass.getLength() > 0) {
                this.processTaglibraryClass(libraryClass, compiler);
                continue;
            }
            this.processTagLibrary(documentElement, namespace, compiler);
        }
        this.invokeNext(documentInfos);
    }

    private void processTaglibraryClass(NodeList libraryClass, Compiler compiler) {
        Node n = libraryClass.item(0);
        String className = this.getNodeText(n);
        TagLibrary taglib = (TagLibrary)this.createInstance(className, n);
        compiler.addTagLibrary(taglib);
    }

    private void processTagLibrary(Element documentElement, String namespace, Compiler compiler) {
        NodeList children = documentElement.getChildNodes();
        if (children != null && children.getLength() > 0) {
            TagLibraryImpl taglibrary;
            String taglibNamespace = null;
            String compositeLibraryName = null;
            int ilen = children.getLength();
            for (int i = 0; i < ilen; ++i) {
                Node n = children.item(i);
                if (TAGLIB_NAMESPACE.equals(n.getLocalName())) {
                    taglibNamespace = this.getNodeText(n);
                    continue;
                }
                if (!COMPOSITE_LIBRARY_NAME.equals(n.getLocalName())) continue;
                compositeLibraryName = this.getNodeText(n);
            }
            if (compositeLibraryName != null) {
                taglibrary = new CompositeComponentTagLibrary(taglibNamespace, compositeLibraryName);
                compiler.addTagLibrary(taglibrary);
            } else {
                taglibrary = new TagLibraryImpl(taglibNamespace);
            }
            NodeList tags = documentElement.getElementsByTagNameNS(namespace, TAG);
            this.processTags(documentElement, tags, taglibrary);
            NodeList functions = documentElement.getElementsByTagNameNS(namespace, FUNCTION);
            this.processFunctions(functions, taglibrary);
            compiler.addTagLibrary(taglibrary);
        }
    }

    private void processTags(Element documentElement, NodeList tags, TagLibraryImpl taglibrary) {
        if (tags != null && tags.getLength() > 0) {
            int ilen = tags.getLength();
            for (int i = 0; i < ilen; ++i) {
                Node tagNode = tags.item(i);
                NodeList children = tagNode.getChildNodes();
                String tagName = null;
                NodeList component = null;
                NodeList converter = null;
                NodeList validator = null;
                NodeList behavior = null;
                Node source = null;
                Node handlerClass = null;
                int jlen = children.getLength();
                for (int j = 0; j < jlen; ++j) {
                    Node n = children.item(j);
                    if (TAG_NAME.equals(n.getLocalName())) {
                        tagName = this.getNodeText(n);
                        continue;
                    }
                    if (COMPONENT.equals(n.getLocalName())) {
                        component = n.getChildNodes();
                        continue;
                    }
                    if (CONVERTER.equals(n.getLocalName())) {
                        converter = n.getChildNodes();
                        continue;
                    }
                    if (VALIDATOR.equals(n.getLocalName())) {
                        validator = n.getChildNodes();
                        continue;
                    }
                    if (BEHAVIOR.equals(n.getLocalName())) {
                        behavior = n.getChildNodes();
                        continue;
                    }
                    if (SOURCE.equals(n.getLocalName())) {
                        source = n;
                        continue;
                    }
                    if (!HANDLER_CLASS.equals(n.getLocalName())) continue;
                    handlerClass = n;
                }
                if (component != null) {
                    this.processComponent(component, taglibrary, tagName);
                    continue;
                }
                if (converter != null) {
                    this.processConverter(converter, taglibrary, tagName);
                    continue;
                }
                if (validator != null) {
                    this.processValidator(validator, taglibrary, tagName);
                    continue;
                }
                if (behavior != null) {
                    this.processBehavior(behavior, taglibrary, tagName);
                    continue;
                }
                if (source != null) {
                    this.processSource(documentElement, source, taglibrary, tagName);
                    continue;
                }
                if (handlerClass == null) continue;
                this.processHandlerClass(handlerClass, taglibrary, tagName);
            }
        }
    }

    private void processBehavior(NodeList behavior, TagLibraryImpl taglibrary, String tagName) {
        if (behavior != null && behavior.getLength() > 0) {
            String behaviorId = null;
            String handlerClass = null;
            int ilen = behavior.getLength();
            for (int i = 0; i < ilen; ++i) {
                Node n = behavior.item(i);
                if (BEHAVIOR_ID.equals(n.getLocalName())) {
                    behaviorId = this.getNodeText(n);
                    continue;
                }
                if (!HANDLER_CLASS.equals(n.getLocalName())) continue;
                handlerClass = this.getNodeText(n);
            }
            if (handlerClass != null) {
                try {
                    Class<?> clazz = this.loadClass(handlerClass, this, null);
                    taglibrary.putBehavior(tagName, behaviorId, clazz);
                }
                catch (ClassNotFoundException e) {
                    throw new ConfigurationException(e);
                }
            } else {
                taglibrary.putBehavior(tagName, behaviorId);
            }
        }
    }

    private void processHandlerClass(Node handlerClass, TagLibraryImpl taglibrary, String name) {
        block7: {
            String className = this.getNodeText(handlerClass);
            if (className == null) {
                throw new ConfigurationException("The tag named " + name + " from namespace " + taglibrary.getNamespace() + " has a null handler-class defined");
            }
            try {
                try {
                    Class<?> clazz = this.loadClass(className, this, null);
                    taglibrary.putTagHandler(name, clazz);
                }
                catch (NoClassDefFoundError defNotFound) {
                    String message = defNotFound.toString();
                    if (message.contains("com/sun/facelets/") || message.contains("com.sun.facelets.")) {
                        if (LOGGER.isLoggable(Level.WARNING)) {
                            LOGGER.log(Level.WARNING, "jsf.config.legacy.facelet.warning", new Object[]{handlerClass});
                        }
                        break block7;
                    }
                    throw defNotFound;
                }
            }
            catch (ClassNotFoundException cnfe) {
                throw new ConfigurationException(cnfe);
            }
        }
    }

    private void processSource(Element documentElement, Node source, TagLibraryImpl taglibrary, String name) {
        String docURI = documentElement.getOwnerDocument().getDocumentURI();
        String s = this.getNodeText(source);
        try {
            URL url = new URL(new URL(docURI), s);
            taglibrary.putUserTag(name, url);
        }
        catch (MalformedURLException e) {
            throw new FacesException((Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processValidator(NodeList validator, TagLibraryImpl taglibrary, String name) {
        if (validator == null || validator.getLength() <= 0) return;
        String validatorId = null;
        String handlerClass = null;
        int ilen = validator.getLength();
        for (int i = 0; i < ilen; ++i) {
            Node n = validator.item(i);
            if (VALIDATOR_ID.equals(n.getLocalName())) {
                validatorId = this.getNodeText(n);
                continue;
            }
            if (!HANDLER_CLASS.equals(n.getLocalName())) continue;
            handlerClass = this.getNodeText(n);
        }
        if (handlerClass != null) {
            try {
                Class<?> clazz = this.loadClass(handlerClass, this, null);
                taglibrary.putValidator(name, validatorId, clazz);
                return;
            }
            catch (NoClassDefFoundError defNotFound) {
                String message = defNotFound.toString();
                if (!message.contains("com/sun/facelets/") && !message.contains("com.sun.facelets.")) throw defNotFound;
                if (!LOGGER.isLoggable(Level.WARNING)) return;
                LOGGER.log(Level.WARNING, "jsf.config.legacy.facelet.warning", new Object[]{handlerClass});
                return;
            }
            catch (ClassNotFoundException e) {
                throw new ConfigurationException(e);
            }
        } else {
            taglibrary.putValidator(name, validatorId);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processConverter(NodeList converter, TagLibraryImpl taglibrary, String name) {
        if (converter == null || converter.getLength() <= 0) return;
        String converterId = null;
        String handlerClass = null;
        int ilen = converter.getLength();
        for (int i = 0; i < ilen; ++i) {
            Node n = converter.item(i);
            if (CONVERTER_ID.equals(n.getLocalName())) {
                converterId = this.getNodeText(n);
                continue;
            }
            if (!HANDLER_CLASS.equals(n.getLocalName())) continue;
            handlerClass = this.getNodeText(n);
        }
        if (handlerClass != null) {
            try {
                Class<?> clazz = this.loadClass(handlerClass, this, null);
                taglibrary.putConverter(name, converterId, clazz);
                return;
            }
            catch (NoClassDefFoundError defNotFound) {
                String message = defNotFound.toString();
                if (!message.contains("com/sun/facelets/") && !message.contains("com.sun.facelets.")) throw defNotFound;
                if (!LOGGER.isLoggable(Level.WARNING)) return;
                LOGGER.log(Level.WARNING, "jsf.config.legacy.facelet.warning", new Object[]{handlerClass});
                return;
            }
            catch (ClassNotFoundException e) {
                throw new ConfigurationException(e);
            }
        } else {
            taglibrary.putConverter(name, converterId);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processComponent(NodeList component, TagLibraryImpl taglibrary, String name) {
        if (component == null || component.getLength() <= 0) return;
        String componentType = null;
        String rendererType = null;
        String handlerClass = null;
        int ilen = component.getLength();
        for (int i = 0; i < ilen; ++i) {
            Node n = component.item(i);
            if (COMPONENT_TYPE.equals(n.getLocalName())) {
                componentType = this.getNodeText(n);
                continue;
            }
            if (RENDERER_TYPE.equals(n.getLocalName())) {
                rendererType = this.getNodeText(n);
                continue;
            }
            if (!HANDLER_CLASS.equals(n.getLocalName())) continue;
            handlerClass = this.getNodeText(n);
        }
        if (handlerClass != null) {
            try {
                Class<?> clazz = this.loadClass(handlerClass, this, null);
                taglibrary.putComponent(name, componentType, rendererType, clazz);
                return;
            }
            catch (NoClassDefFoundError defNotFound) {
                String message = defNotFound.toString();
                if (!message.contains("com/sun/facelets/") && !message.contains("com.sun.facelets.")) throw defNotFound;
                if (!LOGGER.isLoggable(Level.WARNING)) return;
                LOGGER.log(Level.WARNING, "jsf.config.legacy.facelet.warning", new Object[]{handlerClass});
                return;
            }
            catch (ClassNotFoundException e) {
                throw new ConfigurationException(e);
            }
        } else {
            taglibrary.putComponent(name, componentType, rendererType);
        }
    }

    private void processFunctions(NodeList functions, TagLibraryImpl taglibrary) {
        if (functions != null && functions.getLength() > 0) {
            int ilen = functions.getLength();
            for (int i = 0; i < ilen; ++i) {
                NodeList children = functions.item(i).getChildNodes();
                String functionName = null;
                String functionClass = null;
                String functionSignature = null;
                int jlen = children.getLength();
                for (int j = 0; j < jlen; ++j) {
                    Node n = children.item(j);
                    if (FUNCTION_NAME.equals(n.getLocalName())) {
                        functionName = this.getNodeText(n);
                        continue;
                    }
                    if (FUNCTION_CLASS.equals(n.getLocalName())) {
                        functionClass = this.getNodeText(n);
                        continue;
                    }
                    if (!FUNCTION_SIGNATURE.equals(n.getLocalName())) continue;
                    functionSignature = this.getNodeText(n);
                }
                try {
                    Class<?> clazz = this.loadClass(functionClass, this, null);
                    Method m = FaceletTaglibConfigProcessor.createMethod(clazz, functionSignature);
                    taglibrary.putFunction(functionName, m);
                    continue;
                }
                catch (Exception e) {
                    throw new ConfigurationException(e);
                }
            }
        }
    }

    private static Method createMethod(Class type, String signature) throws Exception {
        Class[] pc;
        int pos = signature.indexOf(32);
        if (pos == -1) {
            throw new Exception("Must Provide Return Type: " + signature);
        }
        int pos2 = signature.indexOf(40, pos + 1);
        if (pos2 == -1) {
            throw new Exception("Must provide a method name, followed by '(': " + signature);
        }
        String mn = signature.substring(pos + 1, pos2).trim();
        pos = signature.indexOf(41, pos2 + 1);
        if (pos == -1) {
            throw new Exception("Must close parentheses, ')' missing: " + signature);
        }
        String[] ps = signature.substring(pos2 + 1, pos).trim().split(",");
        if (ps.length == 1 && "".equals(ps[0])) {
            pc = new Class[]{};
        } else {
            pc = new Class[ps.length];
            for (int i = 0; i < pc.length; ++i) {
                pc[i] = ReflectionUtil.forName(ps[i].trim());
            }
        }
        try {
            return type.getMethod(mn, pc);
        }
        catch (NoSuchMethodException e) {
            throw new Exception("No Function Found on type: " + type.getName() + " with signature: " + signature);
        }
    }
}

