/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.renderkit.Attribute;
import com.sun.faces.renderkit.AttributeManager;
import com.sun.faces.renderkit.html_basic.BaseTableRenderer;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableRenderer
extends BaseTableRenderer {
    private static final Attribute[] ATTRIBUTES = AttributeManager.getAttributes(AttributeManager.Key.DATATABLE);

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        this.rendererParamsNotNull(context, component);
        if (!this.shouldEncode(component)) {
            return;
        }
        UIData data = (UIData)component;
        data.setRowIndex(-1);
        ResponseWriter writer = context.getResponseWriter();
        this.renderTableStart(context, component, writer, ATTRIBUTES);
        this.renderCaption(context, (UIComponent)data, writer);
        this.renderColumnGroups(context, (UIComponent)data);
        this.renderHeader(context, component, writer);
        this.renderFooter(context, component, writer);
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        this.rendererParamsNotNull(context, component);
        if (!this.shouldEncodeChildren(component)) {
            return;
        }
        UIData data = (UIData)component;
        ResponseWriter writer = context.getResponseWriter();
        BaseTableRenderer.TableMetaInfo info = this.getMetaInfo(context, (UIComponent)data);
        if (info.columns.isEmpty()) {
            this.renderEmptyTableBody(writer, (UIComponent)data);
            return;
        }
        int processed = 0;
        int rowIndex = data.getFirst() - 1;
        int rows = data.getRows();
        List<Integer> bodyRows = this.getBodyRows(data);
        boolean hasBodyRows = bodyRows != null && !bodyRows.isEmpty();
        boolean wroteTableBody = false;
        if (!hasBodyRows) {
            this.renderTableBodyStart(context, component, writer);
        }
        boolean renderedRow = false;
        while (rows <= 0 || ++processed <= rows) {
            data.setRowIndex(++rowIndex);
            if (!data.isRowAvailable()) break;
            if (hasBodyRows && bodyRows.contains(data.getRowIndex())) {
                if (wroteTableBody) {
                    writer.endElement("tbody");
                }
                writer.startElement("tbody", (UIComponent)data);
                wroteTableBody = true;
            }
            this.renderRowStart(context, component, writer);
            this.renderRow(context, component, null, writer);
            this.renderRowEnd(context, component, writer);
            renderedRow = true;
        }
        if (!renderedRow) {
            this.renderEmptyTableRow(writer, (UIComponent)data);
        }
        this.renderTableBodyEnd(context, component, writer);
        data.setRowIndex(-1);
    }

    @Override
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        this.rendererParamsNotNull(context, component);
        if (!this.shouldEncode(component)) {
            return;
        }
        this.clearMetaInfo(context, component);
        ((UIData)component).setRowIndex(-1);
        this.renderTableEnd(context, component, context.getResponseWriter());
    }

    @Override
    public boolean getRendersChildren() {
        return true;
    }

    private List<Integer> getBodyRows(UIData data) {
        String[] rows;
        ArrayList<Integer> result = null;
        String bodyRows = (String)data.getAttributes().get("bodyrows");
        if (bodyRows != null && (rows = Util.split(bodyRows, ",")) != null) {
            result = new ArrayList<Integer>(rows.length);
            for (String curRow : rows) {
                result.add(Integer.valueOf(curRow));
            }
        }
        return result;
    }

    protected void renderColumnGroups(FacesContext context, UIComponent table) throws IOException {
        UIComponent colGroups = this.getFacet(table, "colgroups");
        if (colGroups != null) {
            this.encodeRecursive(context, colGroups);
        }
    }

    @Override
    protected void renderFooter(FacesContext context, UIComponent table, ResponseWriter writer) throws IOException {
        BaseTableRenderer.TableMetaInfo info = this.getMetaInfo(context, table);
        UIComponent footer = this.getFacet(table, "footer");
        if (footer == null && !info.hasFooterFacets) {
            return;
        }
        String footerClass = (String)table.getAttributes().get("footerClass");
        writer.startElement("tfoot", table);
        writer.writeText((Object)"\n", table, null);
        if (info.hasFooterFacets) {
            writer.startElement("tr", table);
            writer.writeText((Object)"\n", table, null);
            for (UIColumn column : info.columns) {
                String columnFooterClass = (String)column.getAttributes().get("footerClass");
                writer.startElement("td", (UIComponent)column);
                if (columnFooterClass != null) {
                    writer.writeAttribute("class", (Object)columnFooterClass, "columnFooterClass");
                } else if (footerClass != null) {
                    writer.writeAttribute("class", (Object)footerClass, "footerClass");
                }
                UIComponent facet = this.getFacet((UIComponent)column, "footer");
                if (facet != null) {
                    this.encodeRecursive(context, facet);
                }
                writer.endElement("td");
                writer.writeText((Object)"\n", table, null);
            }
            this.renderRowEnd(context, table, writer);
        }
        if (footer != null) {
            writer.startElement("tr", footer);
            writer.startElement("td", footer);
            if (footerClass != null) {
                writer.writeAttribute("class", (Object)footerClass, "footerClass");
            }
            if (info.columns.size() > 1) {
                writer.writeAttribute("colspan", (Object)String.valueOf(info.columns.size()), null);
            }
            this.encodeRecursive(context, footer);
            writer.endElement("td");
            this.renderRowEnd(context, table, writer);
        }
        writer.endElement("tfoot");
        writer.writeText((Object)"\n", table, null);
    }

    @Override
    protected void renderHeader(FacesContext context, UIComponent table, ResponseWriter writer) throws IOException {
        BaseTableRenderer.TableMetaInfo info = this.getMetaInfo(context, table);
        UIComponent header = this.getFacet(table, "header");
        if (header == null && !info.hasHeaderFacets) {
            return;
        }
        String headerClass = (String)table.getAttributes().get("headerClass");
        writer.startElement("thead", table);
        writer.writeText((Object)"\n", table, null);
        if (header != null) {
            writer.startElement("tr", header);
            writer.startElement("th", header);
            if (headerClass != null) {
                writer.writeAttribute("class", (Object)headerClass, "headerClass");
            }
            if (info.columns.size() > 1) {
                writer.writeAttribute("colspan", (Object)String.valueOf(info.columns.size()), null);
            }
            writer.writeAttribute("scope", (Object)"colgroup", null);
            this.encodeRecursive(context, header);
            writer.endElement("th");
            this.renderRowEnd(context, table, writer);
        }
        if (info.hasHeaderFacets) {
            writer.startElement("tr", table);
            writer.writeText((Object)"\n", table, null);
            for (UIColumn column : info.columns) {
                String columnHeaderClass = (String)column.getAttributes().get("headerClass");
                writer.startElement("th", (UIComponent)column);
                if (columnHeaderClass != null) {
                    writer.writeAttribute("class", (Object)columnHeaderClass, "columnHeaderClass");
                } else if (headerClass != null) {
                    writer.writeAttribute("class", (Object)headerClass, "headerClass");
                }
                writer.writeAttribute("scope", (Object)"col", null);
                UIComponent facet = this.getFacet((UIComponent)column, "header");
                if (facet != null) {
                    this.encodeRecursive(context, facet);
                }
                writer.endElement("th");
                writer.writeText((Object)"\n", table, null);
            }
            this.renderRowEnd(context, table, writer);
        }
        writer.endElement("thead");
        writer.writeText((Object)"\n", table, null);
    }

    @Override
    protected void renderRow(FacesContext context, UIComponent table, UIComponent child, ResponseWriter writer) throws IOException {
        BaseTableRenderer.TableMetaInfo info = this.getMetaInfo(context, table);
        info.newRow();
        for (UIColumn column : info.columns) {
            boolean isRowHeader = Boolean.TRUE.equals(column.getAttributes().get("rowHeader"));
            if (isRowHeader) {
                writer.startElement("th", (UIComponent)column);
                writer.writeAttribute("scope", (Object)"row", null);
            } else {
                writer.startElement("td", (UIComponent)column);
            }
            String columnClass = info.getCurrentColumnClass();
            if (columnClass != null) {
                writer.writeAttribute("class", (Object)columnClass, "columnClasses");
            }
            Iterator<UIComponent> gkids = this.getChildren((UIComponent)column);
            while (gkids.hasNext()) {
                this.encodeRecursive(context, gkids.next());
            }
            if (isRowHeader) {
                writer.endElement("th");
            } else {
                writer.endElement("td");
            }
            writer.writeText((Object)"\n", table, null);
        }
    }

    private void renderEmptyTableBody(ResponseWriter writer, UIComponent component) throws IOException {
        writer.startElement("tbody", component);
        this.renderEmptyTableRow(writer, component);
        writer.endElement("tbody");
    }

    private void renderEmptyTableRow(ResponseWriter writer, UIComponent component) throws IOException {
        writer.startElement("tr", component);
        writer.startElement("td", component);
        writer.endElement("td");
        writer.endElement("tr");
    }
}

