package javax.slee.facilities;

/**
 * This interface is implemented by timer events generated by the Timer
 * Facility.
 * <p>
 * The event type name of timer events is
 * "<code>javax.slee.facilities.TimerEvent</code>".
 */
public interface TimerEvent {
    /**
     * Get the timer ID of the timer that fired this event.
     * @return the timer ID.
     */
    public TimerID getTimerID();

    /**
     * Get the time that this timer event was scheduled to be fired.
     * @return the time (in ms since January 1, 1970 UTC) that this timer 
     *   event was scheduled to be fired.
     * @see #getExpiryTime
     */
    public long getScheduledTime();

    /**
     * Get the time that the timer event was actually fired. This time should
     * be close to the current time (unless the event has been delayed in the
     * event router or by other higher priority SBB entities).
     * @return the time (in ms since January 1, 1970 UTC) that this timer
     *  event was fired.
     * @see #getScheduledTime
     */
    public long getExpiryTime();

    /**
     * Get the period of the timer.
     * @return the period of the timer.  For non-repeating timers, the value
     *   returned is <code>Long.MAX_VALUE</code>.
     */
    public long getPeriod();

    /**
     * Get the number of repetitions the timer was set with.  This is the
     * same as the repetitions specified when the timer was set.
     * @return the number of repetitions for the timer.  For
     *  infinitely-repeating timers, the value returned is <code>0</code>. 
     *  For non-repeating timers the value returned is <code>1</code>.
     */
    public int getNumRepetitions();

    /**
     * Get the number of repetitions remaining for the timer.
     * @return the number of remaining repetitions.  For infinitely-repeating
     *  timers, the value returned is always <code>Integer.MAX_VALUE</code>.
     *  For finitely-repeating timers the value is <code>getNumRepetitions() -
     *  iteration number</code>. For non-repeating timers, the value returned
     *  is <code>0</code>.  
     */
    public int getRemainingRepetitions();

    /**
     * Get the number of timer events missed between the firing of the timer's
     * last timer event and this timer event.
     * @return the number of missed repetitions.
     */
    public int getMissedRepetitions();
}

