package javax.slee.profile;

/**
 * This exception wraps an exception thrown by profile management code implemented by
 * an SBB developer.  It is included in the <code>throws</code> clause of business
 * methods included in <code>ProfileMBean</clde> classes generated by the SLEE.
 */
public class ProfileImplementationException extends Exception {
    /**
     * Create a <code>ProfileImplementationException</code> with a detail message and cause.
     * @param cause the reason this exception was thrown.
     */
    public ProfileImplementationException(Throwable cause) {
        super("Exception thrown by Profile Abstract Class implementation code");
        this.cause = cause;
    }

    /**
     * Get the cause (if any) for this exception.
     * @return the cause.
     */
    public Throwable getCause() {
        return cause;
    }


    private final Throwable cause;
}

