/*
 * Decompiled with CFR 0.152.
 */
package javax.slee;

import java.io.Serializable;
import java.io.StreamCorruptedException;

public final class AddressPresentation
implements Serializable {
    public static final int ADDRESS_PRESENTATION_UNDEFINED = 0;
    public static final int ADDRESS_PRESENTATION_ALLOWED = 1;
    public static final int ADDRESS_PRESENTATION_RESTRICTED = 2;
    public static final int ADDRESS_PRESENTATION_ADDRESS_NOT_AVAILABLE = 3;
    public static final String UNDEFINED_STRING = "Undefined";
    public static final String ALLOWED_STRING = "Allowed";
    public static final String RESTRICTED_STRING = "Restricted";
    public static final String ADDRESS_NOT_AVAILABLE_STRING = "Address Not Available";
    public static final AddressPresentation UNDEFINED = new AddressPresentation(0);
    public static final AddressPresentation ALLOWED = new AddressPresentation(1);
    public static final AddressPresentation RESTRICTED = new AddressPresentation(2);
    public static final AddressPresentation ADDRESS_NOT_AVAILABLE = new AddressPresentation(3);
    private final int value;

    public static AddressPresentation fromInt(int value) throws IllegalArgumentException {
        switch (value) {
            case 0: {
                return UNDEFINED;
            }
            case 1: {
                return ALLOWED;
            }
            case 2: {
                return RESTRICTED;
            }
            case 3: {
                return ADDRESS_NOT_AVAILABLE;
            }
        }
        throw new IllegalArgumentException("Invalid value: " + value);
    }

    public static AddressPresentation fromString(String value) throws NullPointerException, IllegalArgumentException {
        if (value == null) {
            throw new NullPointerException("value is null");
        }
        if (value.equalsIgnoreCase(UNDEFINED_STRING)) {
            return UNDEFINED;
        }
        if (value.equalsIgnoreCase(ALLOWED_STRING)) {
            return ALLOWED;
        }
        if (value.equalsIgnoreCase(RESTRICTED_STRING)) {
            return RESTRICTED;
        }
        if (value.equalsIgnoreCase(ADDRESS_NOT_AVAILABLE_STRING)) {
            return ADDRESS_NOT_AVAILABLE;
        }
        throw new IllegalArgumentException("Invalid value: " + value);
    }

    public int toInt() {
        return this.value;
    }

    public boolean isUndefined() {
        return this.value == 0;
    }

    public boolean isAllowed() {
        return this.value == 1;
    }

    public boolean isRestricted() {
        return this.value == 2;
    }

    public boolean isAddressNotAvailable() {
        return this.value == 3;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return obj instanceof AddressPresentation && ((AddressPresentation)obj).value == this.value;
    }

    public int hashCode() {
        return this.value;
    }

    public String toString() {
        switch (this.value) {
            case 0: {
                return UNDEFINED_STRING;
            }
            case 1: {
                return ALLOWED_STRING;
            }
            case 2: {
                return RESTRICTED_STRING;
            }
            case 3: {
                return ADDRESS_NOT_AVAILABLE_STRING;
            }
        }
        return "AddressPresentation in Unknown and Invalid State";
    }

    private AddressPresentation(int value) {
        this.value = value;
    }

    private Object readResolve() throws StreamCorruptedException {
        try {
            return AddressPresentation.fromInt(this.value);
        }
        catch (IllegalArgumentException iae) {
            throw new StreamCorruptedException("Invalid internal state found");
        }
    }
}

