/*
 * Decompiled with CFR 0.152.
 */
package javax.slee;

import java.io.Serializable;

public abstract class ComponentID
implements Comparable,
Serializable,
Cloneable {
    private final String name;
    private final String vendor;
    private final String version;
    private final String componentType;
    private final int hash;

    protected ComponentID(String name, String vendor, String version) {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        if (vendor == null) {
            throw new NullPointerException("vendor is null");
        }
        if (version == null) {
            throw new NullPointerException("version is null");
        }
        this.name = name;
        this.vendor = vendor;
        this.version = version;
        String className = this.getClassName();
        this.componentType = className.substring(className.lastIndexOf(46) + 1);
        this.hash = className.hashCode() ^ this.rotateLeft(name.hashCode(), 3) ^ this.rotateLeft(vendor.hashCode(), 12) ^ this.rotateLeft(version.hashCode(), 21);
    }

    public final String getName() {
        return this.name;
    }

    public final String getVendor() {
        return this.vendor;
    }

    public final String getVersion() {
        return this.version;
    }

    public final boolean equals(Object obj) {
        return obj == this || obj instanceof ComponentID && this.compareTo(obj) == 0;
    }

    public final int hashCode() {
        return this.hash;
    }

    public final String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.componentType).append("[name=").append(this.name).append(",vendor=").append(this.vendor).append(",version=").append(this.version).append(']');
        return buf.toString();
    }

    public abstract int compareTo(Object var1);

    protected final int compareTo(String thisClassName, ComponentID that) {
        int typeComparison = thisClassName.compareTo(that.getClassName());
        if (typeComparison != 0) {
            return typeComparison;
        }
        int nameComparison = this.name.compareTo(that.name);
        if (nameComparison != 0) {
            return nameComparison;
        }
        int vendorComparison = this.vendor.compareTo(that.vendor);
        if (vendorComparison != 0) {
            return vendorComparison;
        }
        return this.version.compareTo(that.version);
    }

    protected abstract String getClassName();

    private int rotateLeft(int value, int bits) {
        long l = (long)value & 0xFFFFFFFFL;
        return (int)(l <<= bits) | (int)(l >> 32);
    }
}

