/*
 * Decompiled with CFR 0.152.
 */
package javax.slee.facilities;

import java.io.Serializable;
import java.io.StreamCorruptedException;

public final class Level
implements Serializable {
    public static final int LEVEL_OFF = 0;
    public static final int LEVEL_SEVERE = 1;
    public static final int LEVEL_WARNING = 2;
    public static final int LEVEL_INFO = 3;
    public static final int LEVEL_CONFIG = 4;
    public static final int LEVEL_FINE = 5;
    public static final int LEVEL_FINER = 6;
    public static final int LEVEL_FINEST = 7;
    public static final Level OFF = new Level(0);
    public static final Level SEVERE = new Level(1);
    public static final Level WARNING = new Level(2);
    public static final Level INFO = new Level(3);
    public static final Level CONFIG = new Level(4);
    public static final Level FINE = new Level(5);
    public static final Level FINER = new Level(6);
    public static final Level FINEST = new Level(7);
    private final int level;

    public static Level fromInt(int level) throws IllegalArgumentException {
        switch (level) {
            case 0: {
                return OFF;
            }
            case 1: {
                return SEVERE;
            }
            case 2: {
                return WARNING;
            }
            case 3: {
                return INFO;
            }
            case 4: {
                return CONFIG;
            }
            case 5: {
                return FINE;
            }
            case 6: {
                return FINER;
            }
            case 7: {
                return FINEST;
            }
        }
        throw new IllegalArgumentException("Invalid level: " + level);
    }

    public int toInt() {
        return this.level;
    }

    public boolean isOff() {
        return this.level == 0;
    }

    public boolean isSevere() {
        return this.level == 1;
    }

    public boolean isWarning() {
        return this.level == 2;
    }

    public boolean isMinor() {
        return this.level == 3;
    }

    public boolean isConfig() {
        return this.level == 4;
    }

    public boolean isFine() {
        return this.level == 5;
    }

    public boolean isFiner() {
        return this.level == 6;
    }

    public boolean isFinest() {
        return this.level == 7;
    }

    public boolean isHigherLevel(Level other) throws NullPointerException {
        if (other == null) {
            throw new NullPointerException("other is null");
        }
        return this.level < other.level;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return obj instanceof Level && ((Level)obj).level == this.level;
    }

    public int hashCode() {
        return this.level;
    }

    public String toString() {
        switch (this.level) {
            case 0: {
                return "Off";
            }
            case 1: {
                return "Severe";
            }
            case 2: {
                return "Warning";
            }
            case 3: {
                return "Info";
            }
            case 4: {
                return "Config";
            }
            case 5: {
                return "Fine";
            }
            case 6: {
                return "Finer";
            }
            case 7: {
                return "Finest";
            }
        }
        return "Level in Unknown and Invalid State";
    }

    private Level(int level) {
        this.level = level;
    }

    private Object readResolve() throws StreamCorruptedException {
        if (this.level == 0) {
            return OFF;
        }
        if (this.level == 1) {
            return SEVERE;
        }
        if (this.level == 2) {
            return WARNING;
        }
        if (this.level == 3) {
            return INFO;
        }
        if (this.level == 4) {
            return CONFIG;
        }
        if (this.level == 5) {
            return FINE;
        }
        if (this.level == 6) {
            return FINER;
        }
        if (this.level == 7) {
            return FINEST;
        }
        throw new StreamCorruptedException("Invalid internal state found");
    }
}

