/*
 * Decompiled with CFR 0.152.
 */
package javax.slee.management;

import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.slee.facilities.AlarmLevel;
import javax.slee.facilities.Level;
import javax.slee.management.AlarmNotification;

public class AlarmLevelFilter
implements NotificationFilter {
    private final Level minLevel_10;
    private final AlarmLevel minLevel_11;

    public AlarmLevelFilter(Level minLevel) {
        this.minLevel_10 = minLevel;
        this.minLevel_11 = null;
    }

    public AlarmLevelFilter(AlarmLevel minLevel) {
        this.minLevel_10 = null;
        this.minLevel_11 = minLevel;
    }

    public boolean isNotificationEnabled(Notification notification) {
        if (!(notification instanceof AlarmNotification)) {
            return false;
        }
        if (this.minLevel_10 != null) {
            Level alarmLevel = ((AlarmNotification)notification).getLevel();
            return alarmLevel != null && !this.minLevel_10.isHigherLevel(alarmLevel);
        }
        AlarmLevel alarmLevel = ((AlarmNotification)notification).getAlarmLevel();
        return alarmLevel != null && !this.minLevel_11.isHigherLevel(alarmLevel);
    }
}

