/*
 * Decompiled with CFR 0.152.
 */
package javax.slee.management;

import java.util.HashMap;
import java.util.Iterator;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.slee.management.AlarmNotification;

public class AlarmThresholdFilter
implements NotificationFilter {
    private final int threshold;
    private final long period;
    private final HashMap knownAlarms = new HashMap();

    public AlarmThresholdFilter(int threshold, long period) {
        this.threshold = threshold;
        this.period = period;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNotificationEnabled(Notification notification) {
        if (!(notification instanceof AlarmNotification)) {
            return false;
        }
        HashMap hashMap = this.knownAlarms;
        synchronized (hashMap) {
            this.clearStaleTimeouts();
            NotificationInfo info = (NotificationInfo)this.knownAlarms.get(notification);
            if (info == null) {
                this.knownAlarms.put(notification, new NotificationInfo(System.currentTimeMillis()));
                return false;
            }
            if (++info.count == this.threshold) {
                this.knownAlarms.remove(notification);
                return true;
            }
            return false;
        }
    }

    private void clearStaleTimeouts() {
        Iterator iterator = this.knownAlarms.values().iterator();
        long currentTime = System.currentTimeMillis();
        while (iterator.hasNext()) {
            NotificationInfo info = (NotificationInfo)iterator.next();
            if (info.firstSeenTime + this.period >= currentTime) continue;
            iterator.remove();
        }
    }

    private final class NotificationInfo {
        final long firstSeenTime;
        int count = 0;

        NotificationInfo(long currentTime) {
            this.firstSeenTime = currentTime;
        }
    }
}

