/*
 * Decompiled with CFR 0.152.
 */
package javax.slee.management;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import javax.slee.ComponentID;
import javax.slee.management.DeployableUnitID;
import javax.slee.management.VendorExtensionUtils;
import javax.slee.management.VendorExtensions;

public class DeployableUnitDescriptor
implements VendorExtensions,
Serializable {
    private final DeployableUnitID id;
    private final Date deploymentDate;
    private final ComponentID[] components;
    private static volatile boolean vendorDataSerializationEnabled = false;
    private static volatile boolean vendorDataDeserializationEnabled = false;
    private transient Object vendorData;

    public DeployableUnitDescriptor(DeployableUnitID id, Date deploymentDate, ComponentID[] components) {
        this.id = id;
        this.deploymentDate = deploymentDate;
        this.components = components;
    }

    public DeployableUnitID getID() {
        return this.id;
    }

    public String getURL() {
        return this.id.getURL();
    }

    public Date getDeploymentDate() {
        return this.deploymentDate;
    }

    public ComponentID[] getComponents() {
        return this.components;
    }

    public static void enableVendorDataSerialization() {
        vendorDataSerializationEnabled = true;
    }

    public static void disableVendorDataSerialization() {
        vendorDataSerializationEnabled = false;
    }

    public static void enableVendorDataDeserialization() {
        vendorDataDeserializationEnabled = true;
    }

    public static void disableVendorDataDeserialization() {
        vendorDataDeserializationEnabled = false;
    }

    public void setVendorData(Object vendorData) {
        this.vendorData = vendorData;
    }

    public Object getVendorData() {
        return this.vendorData;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DeployableUnitDescriptor)) {
            return false;
        }
        DeployableUnitDescriptor that = (DeployableUnitDescriptor)obj;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("DeployableUnit[url=").append(this.id.getURL()).append(",deployment date=").append(this.deploymentDate).append(",components=").append(Arrays.asList(this.components).toString());
        if (this.vendorData != null) {
            buf.append(",vendor data=").append(this.vendorData);
        }
        buf.append(']');
        return buf.toString();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        VendorExtensionUtils.writeObject(out, vendorDataSerializationEnabled ? this.vendorData : null);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.vendorData = VendorExtensionUtils.readObject(in, vendorDataDeserializationEnabled);
    }
}

