/*
 * Decompiled with CFR 0.152.
 */
package javax.slee.management;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.management.Notification;
import javax.slee.management.ResourceAdaptorEntityState;
import javax.slee.management.ResourceManagementMBean;
import javax.slee.management.VendorExtensionUtils;
import javax.slee.management.VendorExtensions;

public final class ResourceAdaptorEntityStateChangeNotification
extends Notification
implements VendorExtensions {
    private final String entityName;
    private final ResourceAdaptorEntityState newState;
    private final ResourceAdaptorEntityState oldState;
    private static volatile boolean vendorDataSerializationEnabled = false;
    private static volatile boolean vendorDataDeserializationEnabled = false;
    private transient Object vendorData;

    public ResourceAdaptorEntityStateChangeNotification(ResourceManagementMBean resourceManagementMBean, String entityName, ResourceAdaptorEntityState newState, ResourceAdaptorEntityState oldState, long sequenceNumber) throws NullPointerException {
        super("javax.slee.management.resourceadaptorentitystatechange", resourceManagementMBean, sequenceNumber, System.currentTimeMillis(), "Resource adaptor entity " + entityName + " state changed from " + oldState + " to " + newState);
        if (resourceManagementMBean == null) {
            throw new NullPointerException("resourceManagementMBean is null");
        }
        if (entityName == null) {
            throw new NullPointerException("entityName is null");
        }
        if (newState == null) {
            throw new NullPointerException("newState is null");
        }
        if (oldState == null) {
            throw new NullPointerException("oldState is null");
        }
        this.entityName = entityName;
        this.newState = newState;
        this.oldState = oldState;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public ResourceAdaptorEntityState getNewState() {
        return this.newState;
    }

    public ResourceAdaptorEntityState getOldState() {
        return this.oldState;
    }

    public static void enableVendorDataSerialization() {
        vendorDataSerializationEnabled = true;
    }

    public static void disableVendorDataSerialization() {
        vendorDataSerializationEnabled = false;
    }

    public static void enableVendorDataDeserialization() {
        vendorDataDeserializationEnabled = true;
    }

    public static void disableVendorDataDeserialization() {
        vendorDataDeserializationEnabled = false;
    }

    public void setVendorData(Object vendorData) {
        this.vendorData = vendorData;
    }

    public Object getVendorData() {
        return this.vendorData;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("ResourceAdaptorEntityStateChangeNotification[timestamp=").append(this.getTimeStamp()).append(",entity name=").append(this.entityName).append(",old state=").append(this.oldState).append(",new state=").append(this.newState);
        if (this.vendorData != null) {
            buf.append(",vendor data=").append(this.vendorData);
        }
        buf.append("]");
        return buf.toString();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        VendorExtensionUtils.writeObject(out, vendorDataSerializationEnabled ? this.vendorData : null);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.vendorData = VendorExtensionUtils.readObject(in, vendorDataDeserializationEnabled);
    }
}

