/*
 * Decompiled with CFR 0.152.
 */
package javax.slee.management;

import javax.management.ObjectName;
import javax.slee.SbbID;
import javax.slee.ServiceID;
import javax.slee.management.AbstractNotificationSource;
import javax.slee.management.NotificationSource;

public final class SbbNotification
extends AbstractNotificationSource
implements NotificationSource {
    public static final String ALARM_NOTIFICATION_TYPE = "javax.slee.management.alarm.sbb";
    public static final String TRACE_NOTIFICATION_TYPE = "javax.slee.management.trace.sbb";
    public static final String USAGE_NOTIFICATION_TYPE = "javax.slee.management.usage.sbb";
    public static final String SERVICE_NAME_KEY = "serviceName";
    public static final String SERVICE_VENDOR_KEY = "serviceVendor";
    public static final String SERVICE_VERSION_KEY = "serviceVersion";
    public static final String SBB_NAME_KEY = "sbbName";
    public static final String SBB_VENDOR_KEY = "sbbVendor";
    public static final String SBB_VERSION_KEY = "sbbVersion";
    private final ServiceID service;
    private final SbbID sbb;
    private static final String TYPE = SbbNotification.class.getName();

    public SbbNotification(ServiceID service, SbbID sbb) {
        if (service == null) {
            throw new NullPointerException("service is null");
        }
        if (sbb == null) {
            throw new NullPointerException("sbb is null");
        }
        this.service = service;
        this.sbb = sbb;
    }

    public ServiceID getService() {
        return this.service;
    }

    public SbbID getSbb() {
        return this.sbb;
    }

    public String getAlarmNotificationType() {
        return ALARM_NOTIFICATION_TYPE;
    }

    public String getTraceNotificationType() {
        return TRACE_NOTIFICATION_TYPE;
    }

    public String getUsageNotificationType() {
        return USAGE_NOTIFICATION_TYPE;
    }

    public static String getUsageMBeanProperties(ServiceID service, SbbID sbb) {
        if (service == null) {
            throw new NullPointerException("service is null");
        }
        if (sbb == null) {
            throw new NullPointerException("sbb is null");
        }
        StringBuffer buf = new StringBuffer();
        buf.append(SERVICE_NAME_KEY).append('=').append(ObjectName.quote(service.getName())).append(',');
        buf.append(SERVICE_VENDOR_KEY).append('=').append(ObjectName.quote(service.getVendor())).append(',');
        buf.append(SERVICE_VERSION_KEY).append('=').append(ObjectName.quote(service.getVersion())).append(',');
        buf.append(SBB_NAME_KEY).append('=').append(ObjectName.quote(sbb.getName())).append(',');
        buf.append(SBB_VENDOR_KEY).append('=').append(ObjectName.quote(sbb.getVendor())).append(',');
        buf.append(SBB_VERSION_KEY).append('=').append(ObjectName.quote(sbb.getVersion()));
        return buf.toString();
    }

    public String getUsageMBeanProperties() {
        return SbbNotification.getUsageMBeanProperties(this.service, this.sbb);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SbbNotification)) {
            return false;
        }
        SbbNotification that = (SbbNotification)obj;
        return this.service.equals(that.service) && this.sbb.equals(that.sbb);
    }

    public int hashCode() {
        return this.service.hashCode() ^ this.sbb.hashCode();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("SbbNotification[service=").append(this.service).append(",sbb=").append(this.sbb).append(']');
        return buf.toString();
    }

    public int compareTo(Object obj) {
        if (obj == null) {
            throw new NullPointerException("obj is null");
        }
        if (obj == this) {
            return 0;
        }
        if (obj instanceof SbbNotification) {
            SbbNotification that = (SbbNotification)obj;
            int serviceComparison = this.service.compareTo(that.service);
            return serviceComparison != 0 ? serviceComparison : this.sbb.compareTo(that.sbb);
        }
        return super.compareTo(TYPE, obj);
    }

    protected String getClassName() {
        return TYPE;
    }
}

