/*
 * Decompiled with CFR 0.152.
 */
package javax.slee.management;

import javax.slee.management.PeerUnavailableException;
import javax.slee.management.SleeProvider;

public final class SleeProviderFactory {
    public static SleeProvider getSleeProvider(String peerClassName) throws NullPointerException, PeerUnavailableException {
        ClassLoader classloader = SleeProviderFactory.class.getClassLoader();
        if (classloader == null) {
            classloader = ClassLoader.getSystemClassLoader();
        }
        return SleeProviderFactory.getSleeProvider(peerClassName, classloader);
    }

    public static SleeProvider getSleeProvider(String peerClassName, ClassLoader classloader) throws NullPointerException, PeerUnavailableException {
        if (peerClassName == null) {
            throw new NullPointerException("peerClassName is null");
        }
        if (peerClassName.length() == 0) {
            throw new PeerUnavailableException("peerClassName is zero-length");
        }
        try {
            return (SleeProvider)classloader.loadClass(peerClassName).newInstance();
        }
        catch (Throwable t) {
            throw new PeerUnavailableException("Peer class could not be instantiated", t);
        }
    }
}

