/*
 * Decompiled with CFR 0.152.
 */
package javax.slee.management;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.management.Notification;
import javax.slee.management.SleeManagementMBean;
import javax.slee.management.SleeState;
import javax.slee.management.VendorExtensionUtils;
import javax.slee.management.VendorExtensions;

public final class SleeStateChangeNotification
extends Notification
implements VendorExtensions {
    private final SleeState newState;
    private final SleeState oldState;
    private static volatile boolean vendorDataSerializationEnabled = false;
    private static volatile boolean vendorDataDeserializationEnabled = false;
    private transient Object vendorData;

    public SleeStateChangeNotification(SleeManagementMBean sleeManagementMBean, SleeState newState, SleeState oldState, long sequenceNumber) throws NullPointerException {
        super("javax.slee.management.sleestatechange", sleeManagementMBean, sequenceNumber, System.currentTimeMillis(), "SLEE state changed from " + oldState + " to " + newState);
        if (sleeManagementMBean == null) {
            throw new NullPointerException("sleeManagementMBean is null");
        }
        if (newState == null) {
            throw new NullPointerException("newState is null");
        }
        if (oldState == null) {
            throw new NullPointerException("oldState is null");
        }
        this.newState = newState;
        this.oldState = oldState;
    }

    public SleeState getNewState() {
        return this.newState;
    }

    public SleeState getOldState() {
        return this.oldState;
    }

    public static void enableVendorDataSerialization() {
        vendorDataSerializationEnabled = true;
    }

    public static void disableVendorDataSerialization() {
        vendorDataSerializationEnabled = false;
    }

    public static void enableVendorDataDeserialization() {
        vendorDataDeserializationEnabled = true;
    }

    public static void disableVendorDataDeserialization() {
        vendorDataDeserializationEnabled = false;
    }

    public void setVendorData(Object vendorData) {
        this.vendorData = vendorData;
    }

    public Object getVendorData() {
        return this.vendorData;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("SleeStateChangeNotification[timestamp=").append(this.getTimeStamp()).append(",old state=").append(this.oldState).append(",new state=").append(this.newState);
        if (this.vendorData != null) {
            buf.append(",vendor data=").append(this.vendorData);
        }
        buf.append("]");
        return buf.toString();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        VendorExtensionUtils.writeObject(out, vendorDataSerializationEnabled ? this.vendorData : null);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.vendorData = VendorExtensionUtils.readObject(in, vendorDataDeserializationEnabled);
    }
}

