/*
 * Decompiled with CFR 0.152.
 */
package javax.slee.management;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.rmi.MarshalledObject;
import javax.management.Notification;
import javax.slee.facilities.Level;
import javax.slee.facilities.TraceLevel;
import javax.slee.management.NotificationSource;
import javax.slee.management.TraceMBean;
import javax.slee.management.VendorExtensionUtils;
import javax.slee.management.VendorExtensions;

public final class TraceNotification
extends Notification
implements VendorExtensions {
    private final NotificationSource notificationSource;
    private final String tracerName;
    private final Object messageSource;
    private final Level level_10;
    private final TraceLevel level_11;
    private transient Throwable cause;
    private static volatile boolean vendorDataSerializationEnabled = false;
    private static volatile boolean vendorDataDeserializationEnabled = false;
    private transient Object vendorData;

    public TraceNotification(TraceMBean traceMBean, String messageType, Object messageSource, Level traceLevel, String message, Throwable cause, long sequenceNumber, long timestamp) throws NullPointerException, IllegalArgumentException {
        super("javax.slee.management.trace", traceMBean, sequenceNumber, timestamp, message);
        if (traceMBean == null) {
            throw new NullPointerException("traceMBean is null");
        }
        if (messageType == null) {
            throw new NullPointerException("messageType is null");
        }
        if (traceLevel == null) {
            throw new NullPointerException("traceLevel is null");
        }
        if (message == null) {
            throw new NullPointerException("message is null");
        }
        if (traceLevel.isOff()) {
            throw new IllegalArgumentException("traceLevel cannot be Level.OFF");
        }
        this.tracerName = messageType;
        this.messageSource = messageSource;
        this.level_10 = traceLevel;
        this.cause = cause;
        this.notificationSource = null;
        this.level_11 = null;
    }

    public TraceNotification(String type, TraceMBean traceMBean, NotificationSource notificationSource, String tracerName, TraceLevel traceLevel, String message, Throwable cause, long sequenceNumber, long timestamp) throws NullPointerException, IllegalArgumentException {
        super(type, traceMBean, sequenceNumber, timestamp, message);
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        if (traceMBean == null) {
            throw new NullPointerException("traceMBean is null");
        }
        if (notificationSource == null) {
            throw new NullPointerException("notificationSource is null");
        }
        if (tracerName == null) {
            throw new NullPointerException("tracerName is null");
        }
        if (traceLevel == null) {
            throw new NullPointerException("traceLevel is null");
        }
        if (message == null) {
            throw new NullPointerException("message is null");
        }
        if (traceLevel.isOff()) {
            throw new IllegalArgumentException("level cannot be Level.OFF");
        }
        this.notificationSource = notificationSource;
        this.tracerName = tracerName;
        this.level_11 = traceLevel;
        this.cause = cause;
        this.messageSource = notificationSource;
        this.level_10 = Level.fromInt(traceLevel.toInt());
    }

    public NotificationSource getNotificationSource() {
        return this.notificationSource;
    }

    public String getMessageType() {
        return this.tracerName;
    }

    public String getTracerName() {
        return this.tracerName;
    }

    public Object getMessageSource() {
        return this.messageSource;
    }

    public Level getLevel() {
        return this.level_10;
    }

    public TraceLevel getTraceLevel() {
        return this.level_11;
    }

    public Throwable getCause() {
        return this.cause;
    }

    public static void enableVendorDataSerialization() {
        vendorDataSerializationEnabled = true;
    }

    public static void disableVendorDataSerialization() {
        vendorDataSerializationEnabled = false;
    }

    public static void enableVendorDataDeserialization() {
        vendorDataDeserializationEnabled = true;
    }

    public static void disableVendorDataDeserialization() {
        vendorDataDeserializationEnabled = false;
    }

    public void setVendorData(Object vendorData) {
        this.vendorData = vendorData;
    }

    public Object getVendorData() {
        return this.vendorData;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TraceNotification)) {
            return false;
        }
        TraceNotification that = (TraceNotification)obj;
        if (this.notificationSource == null) {
            if (that.notificationSource != null) {
                return false;
            }
            return this.tracerName.equals(that.tracerName) && this.level_10.equals(that.level_10) && this.messageSource.equals(that.messageSource) && this.getMessage().equals(that.getMessage());
        }
        if (that.notificationSource == null) {
            return false;
        }
        return ((Object)this.notificationSource).equals(that.notificationSource) && this.tracerName.equals(that.tracerName) && this.level_11.equals(that.level_11) && this.getMessage().equals(that.getMessage());
    }

    public int hashCode() {
        return this.getMessage().hashCode();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("TraceNotification[");
        if (this.notificationSource == null) {
            buf.append("type=").append(this.getType()).append(",timestamp=").append(this.getTimeStamp()).append(",msgType=").append(this.tracerName).append(",source=").append(this.messageSource).append(",level=").append(this.level_10).append(",message=").append(this.getMessage()).append(",cause=").append(this.cause);
        } else {
            buf.append("type=").append(this.getType()).append(",tracer=").append(this.tracerName).append(",source=").append(this.notificationSource).append(",level=").append(this.level_11).append(",message=").append(this.getMessage()).append(",cause=").append(this.cause).append(",timestamp=").append(this.getTimeStamp());
        }
        if (this.vendorData != null) {
            buf.append(",vendor data=").append(this.vendorData);
        }
        return buf.toString();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        VendorExtensionUtils.writeObject(out, vendorDataSerializationEnabled ? this.vendorData : null);
        if (this.cause != null) {
            out.writeBoolean(true);
            out.writeObject(new MarshalledObject<Throwable>(this.cause));
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            this.cause.printStackTrace(pw);
            pw.flush();
            out.writeUTF(sw.getBuffer().toString());
        } else {
            out.writeBoolean(false);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.vendorData = VendorExtensionUtils.readObject(in, vendorDataDeserializationEnabled);
        if (in.readBoolean()) {
            try {
                this.cause = (Throwable)((MarshalledObject)in.readObject()).get();
            }
            catch (ClassNotFoundException cnfe) {
                // empty catch block
            }
            String causeString = in.readUTF();
            if (this.cause == null) {
                this.cause = new Exception("Undeserializable cause, original cause stack trace follows: " + causeString);
            }
        }
    }
}

