/*
 * Decompiled with CFR 0.152.
 */
package javax.slee.profile.query;

import javax.slee.profile.query.CompositeQueryExpression;
import javax.slee.profile.query.QueryExpression;

public final class Not
extends QueryExpression {
    private final QueryExpression expr;

    public Not(QueryExpression expr) {
        if (expr == null) {
            throw new NullPointerException("expr is null");
        }
        this.expr = expr;
    }

    public QueryExpression getExpression() {
        return this.expr;
    }

    protected void toString(StringBuffer buf) {
        buf.append("!(");
        this.expr.toString(buf);
        buf.append(')');
    }

    void checkForCycles(QueryExpression expr) throws IllegalArgumentException {
        if (expr == this) {
            throw new IllegalArgumentException("Cyclic expression detected");
        }
        QueryExpression nested = this.expr;
        if (nested instanceof CompositeQueryExpression) {
            ((CompositeQueryExpression)nested).checkForCycles(expr);
        } else if (nested instanceof Not) {
            ((Not)nested).checkForCycles(expr);
        }
    }
}

