/*
 * Decompiled with CFR 0.152.
 */
package javax.slee.resource;

public class FailureReason {
    public static final int REASON_OTHER_REASON = 0;
    public static final int REASON_EVENT_QUEUE_FULL = -1;
    public static final int REASON_EVENT_QUEUE_TIMEOUT = -2;
    public static final int REASON_SYSTEM_OVERLOAD = -3;
    public static final int REASON_EVENT_MARSHALING_ERROR = -4;
    public static final int REASON_FIRING_TRANSACTION_ROLLED_BACK = -5;
    public static final FailureReason OTHER_REASON = new FailureReason(0);
    public static final FailureReason EVENT_QUEUE_FULL = new FailureReason(-1);
    public static final FailureReason EVENT_QUEUE_TIMEOUT = new FailureReason(-2);
    public static final FailureReason SYSTEM_OVERLOAD = new FailureReason(-3);
    public static final FailureReason EVENT_MARSHALING_ERROR = new FailureReason(-4);
    public static final FailureReason FIRING_TRANSACTION_ROLLED_BACK = new FailureReason(-5);
    private final int reason;

    public static FailureReason fromInt(int reason) throws IllegalArgumentException {
        switch (reason) {
            case 0: {
                return OTHER_REASON;
            }
            case -1: {
                return EVENT_QUEUE_FULL;
            }
            case -2: {
                return EVENT_QUEUE_TIMEOUT;
            }
            case -3: {
                return SYSTEM_OVERLOAD;
            }
            case -4: {
                return EVENT_MARSHALING_ERROR;
            }
            case -5: {
                return FIRING_TRANSACTION_ROLLED_BACK;
            }
        }
        if (reason > 0) {
            return new FailureReason(reason);
        }
        throw new IllegalArgumentException("Invalid failure reason: " + reason);
    }

    public final int toInt() {
        return this.reason;
    }

    public final boolean isOtherReason() {
        return this.reason >= 0;
    }

    public final boolean isEventQueueFull() {
        return this.reason == -1;
    }

    public final boolean isEventQueueTimeout() {
        return this.reason == -2;
    }

    public final boolean isSystemOverLoad() {
        return this.reason == -3;
    }

    public final boolean isEventMarshalingError() {
        return this.reason == -4;
    }

    public final boolean isFiringTransactionRolledBack() {
        return this.reason == -5;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return obj instanceof FailureReason && ((FailureReason)obj).reason == this.reason;
    }

    public final int hashCode() {
        return this.reason;
    }

    public String toString() {
        switch (this.reason) {
            case 0: {
                return "Other reason";
            }
            case -1: {
                return "Event queue full";
            }
            case -2: {
                return "Event timed out while queued";
            }
            case -3: {
                return "System overload";
            }
            case -4: {
                return "Event marshaling error";
            }
            case -5: {
                return "Firing transaction rolled back";
            }
        }
        return "Vendor-defined reason: " + this.reason;
    }

    protected FailureReason(int reason) {
        if (reason <= 0 && !this.getClass().equals(FailureReason.class)) {
            throw new IllegalArgumentException("Invalid vendor-defined reason code: " + reason);
        }
        this.reason = reason;
    }

    protected final int getReason() {
        return this.reason;
    }

    private Object readResolve() {
        return FailureReason.fromInt(this.reason);
    }
}

