/*
 * Decompiled with CFR 0.152.
 */
package javax.time;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.time.Duration;
import javax.time.InstantProvider;
import javax.time.MathUtils;
import javax.time.calendar.OffsetDateTime;
import javax.time.calendar.ZoneOffset;

public final class Instant
implements InstantProvider,
Comparable<Instant>,
Serializable {
    public static final Instant EPOCH = new Instant(0L, 0);
    private static final long serialVersionUID = 1L;
    static final BigInteger BILLION = BigInteger.valueOf(1000000000L);
    private static final int NANOS_PER_SECOND = 1000000000;
    private final long seconds;
    private final int nanos;

    static void checkNotNull(Object object, String errorMessage) {
        if (object == null) {
            throw new NullPointerException(errorMessage);
        }
    }

    public static Instant seconds(long seconds) {
        return Instant.create(seconds, 0);
    }

    public static Instant seconds(long epochSeconds, long nanoAdjustment) {
        long secs = MathUtils.safeAdd(epochSeconds, nanoAdjustment / 1000000000L);
        int nos = (int)(nanoAdjustment % 1000000000L);
        if (nos < 0) {
            nos += 1000000000;
            secs = MathUtils.safeDecrement(secs);
        }
        return Instant.create(secs, nos);
    }

    public static Instant seconds(BigDecimal seconds) {
        Instant.checkNotNull(seconds, "Seconds must not be null");
        return Instant.nanos(seconds.movePointRight(9).toBigIntegerExact());
    }

    public static Instant millis(long millis) {
        long secs = millis / 1000L;
        int mos = (int)(millis % 1000L);
        if (mos < 0) {
            mos += 1000;
            --secs;
        }
        return Instant.create(secs, mos * 1000000);
    }

    public static Instant nanos(long nanos) {
        long secs = nanos / 1000000000L;
        int nos = (int)(nanos % 1000000000L);
        if (nos < 0) {
            nos += 1000000000;
            --secs;
        }
        return Instant.create(secs, nos);
    }

    public static Instant nanos(BigInteger nanos) {
        Instant.checkNotNull(nanos, "Nanos must not be null");
        BigInteger[] divRem = nanos.divideAndRemainder(BILLION);
        if (divRem[0].bitLength() > 63) {
            throw new ArithmeticException("Exceeds capacity of Duration: " + nanos);
        }
        return Instant.seconds(divRem[0].longValue(), divRem[1].intValue());
    }

    public static Instant from(InstantProvider instantProvider) {
        Instant.checkNotNull(instantProvider, "InstantProvider must not be null");
        Instant provided = instantProvider.toInstant();
        Instant.checkNotNull(provided, "The implementation of InstantProvider must not return null");
        return provided;
    }

    public static Instant parse(String text) {
        Instant.checkNotNull(text, "Text to parse must not be null");
        throw new UnsupportedOperationException();
    }

    private static Instant create(long seconds, int nanoAdjustment) {
        if ((seconds | (long)nanoAdjustment) == 0L) {
            return EPOCH;
        }
        return new Instant(seconds, nanoAdjustment);
    }

    private Instant(long epochSeconds, int nanos) {
        this.seconds = epochSeconds;
        this.nanos = nanos;
    }

    private Object readResolve() {
        return (this.seconds | (long)this.nanos) == 0L ? EPOCH : this;
    }

    public long getEpochSeconds() {
        return this.seconds;
    }

    public int getNanoOfSecond() {
        return this.nanos;
    }

    public Instant plus(Duration duration) {
        long secsToAdd = duration.getSeconds();
        int nanosToAdd = duration.getNanosInSecond();
        if (secsToAdd == 0L && nanosToAdd == 0) {
            return this;
        }
        long secs = MathUtils.safeAdd(this.seconds, secsToAdd);
        int nos = this.nanos + nanosToAdd;
        if (nos >= 1000000000) {
            nos -= 1000000000;
            secs = MathUtils.safeIncrement(secs);
        }
        return Instant.create(secs, nos);
    }

    public Instant plusSeconds(long secondsToAdd) {
        if (secondsToAdd == 0L) {
            return this;
        }
        long secs = MathUtils.safeAdd(this.seconds, secondsToAdd);
        return Instant.create(secs, this.nanos);
    }

    public Instant plusMillis(long millisToAdd) {
        if (millisToAdd == 0L) {
            return this;
        }
        long secondsToAdd = millisToAdd / 1000L;
        int nos = (int)(millisToAdd % 1000L) * 1000000;
        if ((nos += this.nanos) < 0) {
            nos += 1000000000;
            --secondsToAdd;
        } else if (nos >= 1000000000) {
            nos -= 1000000000;
            ++secondsToAdd;
        }
        return Instant.create(MathUtils.safeAdd(this.seconds, secondsToAdd), nos);
    }

    public Instant plusNanos(long nanosToAdd) {
        if (nanosToAdd == 0L) {
            return this;
        }
        long secondsToAdd = nanosToAdd / 1000000000L;
        int nos = (int)(nanosToAdd % 1000000000L);
        if ((nos += this.nanos) < 0) {
            nos += 1000000000;
            --secondsToAdd;
        } else if (nos >= 1000000000) {
            nos -= 1000000000;
            ++secondsToAdd;
        }
        return Instant.create(MathUtils.safeAdd(this.seconds, secondsToAdd), nos);
    }

    public Instant minus(Duration duration) {
        long secsToSubtract = duration.getSeconds();
        int nanosToSubtract = duration.getNanosInSecond();
        if (secsToSubtract == 0L && nanosToSubtract == 0) {
            return this;
        }
        long secs = MathUtils.safeSubtract(this.seconds, secsToSubtract);
        int nos = this.nanos - nanosToSubtract;
        if (nos < 0) {
            nos += 1000000000;
            secs = MathUtils.safeDecrement(secs);
        }
        return Instant.create(secs, nos);
    }

    public Instant minusSeconds(long secondsToSubtract) {
        if (secondsToSubtract == 0L) {
            return this;
        }
        long secs = MathUtils.safeSubtract(this.seconds, secondsToSubtract);
        return Instant.create(secs, this.nanos);
    }

    public Instant minusMillis(long millisToSubtract) {
        if (millisToSubtract == 0L) {
            return this;
        }
        long secondsToSubtract = millisToSubtract / 1000L;
        int nos = (int)(millisToSubtract % 1000L) * 1000000;
        if ((nos = this.nanos - nos) < 0) {
            nos += 1000000000;
            ++secondsToSubtract;
        } else if (nos >= 1000000000) {
            nos -= 1000000000;
            --secondsToSubtract;
        }
        return Instant.create(MathUtils.safeSubtract(this.seconds, secondsToSubtract), nos);
    }

    public Instant minusNanos(long nanosToSubtract) {
        if (nanosToSubtract == 0L) {
            return this;
        }
        long secondsToSubtract = nanosToSubtract / 1000000000L;
        int nos = (int)(nanosToSubtract % 1000000000L);
        if ((nos = this.nanos - nos) < 0) {
            nos += 1000000000;
            ++secondsToSubtract;
        } else if (nos >= 1000000000) {
            nos -= 1000000000;
            --secondsToSubtract;
        }
        return Instant.create(MathUtils.safeSubtract(this.seconds, secondsToSubtract), nos);
    }

    public BigDecimal toEpochSeconds() {
        return BigDecimal.valueOf(this.seconds).add(BigDecimal.valueOf(this.nanos, 9));
    }

    public BigInteger toEpochNanos() {
        return BigInteger.valueOf(this.seconds).multiply(BILLION).add(BigInteger.valueOf(this.nanos));
    }

    public long toEpochMillisLong() {
        long millis = MathUtils.safeMultiply(this.seconds, 1000);
        return millis + (long)(this.nanos / 1000000);
    }

    @Override
    public Instant toInstant() {
        return this;
    }

    @Override
    public int compareTo(Instant otherInstant) {
        int cmp = MathUtils.safeCompare(this.seconds, otherInstant.seconds);
        if (cmp != 0) {
            return cmp;
        }
        return MathUtils.safeCompare(this.nanos, otherInstant.nanos);
    }

    public boolean isAfter(Instant otherInstant) {
        return this.compareTo(otherInstant) > 0;
    }

    public boolean isBefore(Instant otherInstant) {
        return this.compareTo(otherInstant) < 0;
    }

    public boolean equals(Object otherInstant) {
        if (this == otherInstant) {
            return true;
        }
        if (otherInstant instanceof Instant) {
            Instant other = (Instant)otherInstant;
            return this.seconds == other.seconds && this.nanos == other.nanos;
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.seconds ^ this.seconds >>> 32) + 51 * this.nanos;
    }

    public String toString() {
        return OffsetDateTime.fromInstant(this, ZoneOffset.UTC).toLocalDateTime().toString() + 'Z';
    }
}

