/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar;

import java.util.Locale;
import javax.time.calendar.ISOChronology;
import javax.time.calendar.IllegalCalendarFieldValueException;
import javax.time.calendar.format.DateTimeFormatterBuilder;

public enum AmPmOfDay {
    AM,
    PM;


    public static AmPmOfDay of(int amPmOfDay) {
        switch (amPmOfDay) {
            case 0: {
                return AM;
            }
            case 1: {
                return PM;
            }
        }
        throw new IllegalCalendarFieldValueException(ISOChronology.amPmOfDayRule(), amPmOfDay, 0, 1);
    }

    public int getValue() {
        return this.ordinal();
    }

    public String getShortText(Locale locale) {
        return ISOChronology.amPmOfDayRule().getText(this.getValue(), locale, DateTimeFormatterBuilder.TextStyle.SHORT);
    }

    public String getText(Locale locale) {
        return ISOChronology.amPmOfDayRule().getText(this.getValue(), locale, DateTimeFormatterBuilder.TextStyle.FULL);
    }

    public boolean isAm() {
        return this == AM;
    }

    public boolean isPm() {
        return this == PM;
    }
}

