/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar;

import java.io.Serializable;
import javax.time.calendar.DateResolver;
import javax.time.calendar.ISOChronology;
import javax.time.calendar.LocalDate;
import javax.time.calendar.MonthOfYear;

public final class CalendricalContext
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final boolean strict;
    private final DateResolver dateResolver;
    private final boolean checkUnusedFields;

    public CalendricalContext(boolean strict, boolean checkUnusedFields) {
        this.strict = strict;
        this.dateResolver = null;
        this.checkUnusedFields = checkUnusedFields;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public boolean isCheckUnusedFields() {
        return this.checkUnusedFields;
    }

    public DateResolver getDateResolver() {
        return this.dateResolver;
    }

    public LocalDate resolveDate(int year, int month, int dayOfMonth) {
        if (this.dateResolver != null) {
            ISOChronology.yearRule().checkValue(year);
            ISOChronology.dayOfMonthRule().checkValue(dayOfMonth);
            return this.dateResolver.resolveDate(year, MonthOfYear.of(month), dayOfMonth);
        }
        if (this.strict) {
            return LocalDate.of(year, month, dayOfMonth);
        }
        if (month >= 1 && month <= 12) {
            if (dayOfMonth >= 1 && dayOfMonth <= 28) {
                return LocalDate.of(year, month, dayOfMonth);
            }
            return LocalDate.of(year, month, 1).plusDays((long)dayOfMonth - 1L);
        }
        return LocalDate.of(year, 1, 1).plusMonths(month).plusMonths(-1).plusDays((long)dayOfMonth - 1L);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CalendricalContext) {
            CalendricalContext other = (CalendricalContext)obj;
            return this.strict == other.strict && (this.dateResolver == other.dateResolver || this.dateResolver != null && this.dateResolver.equals(other.dateResolver)) && this.checkUnusedFields == other.checkUnusedFields;
        }
        return false;
    }

    public int hashCode() {
        return (this.strict ? 1 : 0) + (this.dateResolver == null ? 0 : this.dateResolver.hashCode()) + (this.checkUnusedFields ? 1 : 0);
    }
}

