/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar;

import java.io.Serializable;
import javax.time.calendar.Calendrical;
import javax.time.calendar.CalendricalMatcher;
import javax.time.calendar.DayOfWeek;
import javax.time.calendar.ISOChronology;
import javax.time.calendar.MonthOfYear;

public final class CalendricalMatchers {
    private CalendricalMatchers() {
    }

    public static CalendricalMatcher leapYear() {
        return Impl.LEAP_YEAR;
    }

    public static CalendricalMatcher leapDay() {
        return Impl.LEAP_DAY;
    }

    public static CalendricalMatcher lastDayOfMonth() {
        return Impl.LAST_DAY_OF_MONTH;
    }

    public static CalendricalMatcher lastDayOfYear() {
        return Impl.LAST_DAY_OF_YEAR;
    }

    public static CalendricalMatcher weekendDay() {
        return Impl.WEEKEND_DAY;
    }

    public static CalendricalMatcher nonWeekendDay() {
        return Impl.NON_WEEKEND_DAY;
    }

    public static CalendricalMatcher firstInMonth(DayOfWeek dayOfWeek) {
        if (dayOfWeek == null) {
            throw new NullPointerException("DayOfWeek must not be null");
        }
        return new DayOfWeekInMonth(1, dayOfWeek);
    }

    public static CalendricalMatcher dayOfWeekInMonth(int ordinal, DayOfWeek dayOfWeek) {
        if (ordinal < 1 || ordinal > 5) {
            throw new IllegalArgumentException("Illegal value for ordinal, value " + ordinal + " is not in the range 1 to 5");
        }
        if (dayOfWeek == null) {
            throw new NullPointerException("DayOfWeek must not be null");
        }
        return new DayOfWeekInMonth(ordinal, dayOfWeek);
    }

    private static final class DayOfWeekInMonth
    implements CalendricalMatcher,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final int ordinal;
        private final DayOfWeek dayOfWeek;

        private DayOfWeekInMonth(int ordinal, DayOfWeek dayOfWeek) {
            this.ordinal = ordinal;
            this.dayOfWeek = dayOfWeek;
        }

        @Override
        public boolean matchesCalendrical(Calendrical calendrical) {
            Integer domVal = calendrical.get(ISOChronology.dayOfMonthRule());
            DayOfWeek dow = calendrical.get(ISOChronology.dayOfWeekRule());
            if (dow != this.dayOfWeek || domVal == null) {
                return false;
            }
            return (domVal - 1) / 7 == this.ordinal - 1;
        }

        public boolean equals(Object obj) {
            if (obj instanceof DayOfWeekInMonth) {
                DayOfWeekInMonth other = (DayOfWeekInMonth)obj;
                return this.ordinal == other.ordinal && this.dayOfWeek == other.dayOfWeek;
            }
            return false;
        }

        public int hashCode() {
            return this.ordinal + 8 * this.dayOfWeek.ordinal();
        }
    }

    private static enum Impl implements CalendricalMatcher
    {
        LEAP_YEAR{

            @Override
            public boolean matchesCalendrical(Calendrical calendrical) {
                Integer yearVal = calendrical.get(ISOChronology.yearRule());
                return yearVal != null && ISOChronology.isLeapYear(yearVal);
            }
        }
        ,
        LEAP_DAY{

            @Override
            public boolean matchesCalendrical(Calendrical calendrical) {
                MonthOfYear moy = calendrical.get(ISOChronology.monthOfYearRule());
                Integer domVal = calendrical.get(ISOChronology.dayOfMonthRule());
                return domVal != null && domVal == 29 && moy == MonthOfYear.FEBRUARY;
            }
        }
        ,
        LAST_DAY_OF_MONTH{

            @Override
            public boolean matchesCalendrical(Calendrical calendrical) {
                Integer yearVal = calendrical.get(ISOChronology.yearRule());
                MonthOfYear moy = calendrical.get(ISOChronology.monthOfYearRule());
                Integer domVal = calendrical.get(ISOChronology.dayOfMonthRule());
                return yearVal != null && moy != null && domVal != null && domVal.intValue() == moy.getLastDayOfMonth(ISOChronology.isLeapYear(yearVal));
            }
        }
        ,
        LAST_DAY_OF_YEAR{

            @Override
            public boolean matchesCalendrical(Calendrical calendrical) {
                MonthOfYear moy = calendrical.get(ISOChronology.monthOfYearRule());
                Integer domVal = calendrical.get(ISOChronology.dayOfMonthRule());
                return domVal != null && domVal == 31 && moy == MonthOfYear.DECEMBER;
            }
        }
        ,
        WEEKEND_DAY{

            @Override
            public boolean matchesCalendrical(Calendrical calendrical) {
                DayOfWeek dow = calendrical.get(ISOChronology.dayOfWeekRule());
                return dow == DayOfWeek.SATURDAY || dow == DayOfWeek.SUNDAY;
            }
        }
        ,
        NON_WEEKEND_DAY{

            @Override
            public boolean matchesCalendrical(Calendrical calendrical) {
                DayOfWeek dow = calendrical.get(ISOChronology.dayOfWeekRule());
                return dow != null && dow != DayOfWeek.SATURDAY && dow != DayOfWeek.SUNDAY;
            }
        };

    }
}

