/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.time.CalendricalException;
import javax.time.calendar.Calendrical;
import javax.time.calendar.CalendricalContext;
import javax.time.calendar.CalendricalRule;
import javax.time.calendar.ISOChronology;
import javax.time.calendar.InvalidCalendarFieldException;
import javax.time.period.Period;

public final class CalendricalMerger
implements Calendrical {
    private final Map<CalendricalRule<?>, Object> inputMap = new ConcurrentHashMap();
    private final Map<CalendricalRule<?>, Object> processingMap = new ConcurrentHashMap();
    private CalendricalContext context;
    private Iterator<CalendricalRule<?>> iterator;
    private Period overflow = Period.ZERO;

    public CalendricalMerger(CalendricalContext context) {
        ISOChronology.checkNotNull(context, null);
        this.context = context;
    }

    public CalendricalMerger(CalendricalContext context, Map<CalendricalRule<?>, Object> inputMap) {
        ISOChronology.checkNotNull(context, null);
        ISOChronology.checkNotNull(inputMap, null);
        this.inputMap.putAll(inputMap);
        this.context = context;
    }

    public Map<CalendricalRule<?>, Object> getInputMap() {
        return this.inputMap;
    }

    public CalendricalContext getContext() {
        return this.context;
    }

    public void setContext(CalendricalContext context) {
        ISOChronology.checkNotNull(context, "CalendricalContext must not be null");
        this.context = context;
    }

    public Period getOverflow() {
        return this.overflow;
    }

    public void addToOverflow(Period additionalOverflow) {
        if (this.overflow.getYears() != 0 && additionalOverflow.getYears() != 0 || this.overflow.getMonths() != 0 && additionalOverflow.getMonths() != 0 || this.overflow.getDays() != 0 && additionalOverflow.getDays() != 0 || this.overflow.getHours() != 0 && additionalOverflow.getHours() != 0 || this.overflow.getMinutes() != 0 && additionalOverflow.getMinutes() != 0 || this.overflow.getSeconds() != 0 && additionalOverflow.getSeconds() != 0 || this.overflow.getNanos() != 0L && additionalOverflow.getNanos() != 0L) {
            throw new CalendricalException("Unable to complete merge as input contains two conflicting out of range values");
        }
        this.overflow = this.overflow.plus(additionalOverflow);
    }

    @Override
    public <T> T get(CalendricalRule<T> rule) {
        ISOChronology.checkNotNull(rule, "CalendricalRule must not be null");
        T value = this.getValue(rule);
        return value != null ? value : rule.deriveValueFrom(this);
    }

    public <T> T getValue(CalendricalRule<T> rule) {
        return rule.reify(this.processingMap.get(rule));
    }

    public <T> void storeMerged(CalendricalRule<T> rule, T value) {
        ISOChronology.checkNotNull(rule, "CalendricalRule must not be null");
        ISOChronology.checkNotNull(value, "Value must not be null");
        T oldValue = this.getValue(rule);
        if (oldValue != null) {
            if (!oldValue.equals(value)) {
                throw new InvalidCalendarFieldException("Merge resulted in two different values, " + value + " and " + oldValue + ", for " + rule.getID() + " given input " + this.inputMap, rule);
            }
            return;
        }
        this.processingMap.put(rule, value);
        this.iterator = this.processingMap.keySet().iterator();
    }

    public void removeProcessed(CalendricalRule<?> rule) {
        ISOChronology.checkNotNull(rule, "CalendricalRule must not be null");
        this.processingMap.remove(rule);
    }

    public Calendrical merge() {
        this.processingMap.clear();
        if (this.inputMap.size() > 0) {
            this.interpret();
            this.mergeLoop();
            ISOChronology.INSTANCE.merge(this);
            if (this.processingMap.size() > 1) {
                this.removeDerivable();
            }
        }
        return this;
    }

    private void mergeLoop() {
        this.iterator = this.inputMap.keySet().iterator();
        for (int protect = 0; this.iterator.hasNext() && protect < 100; ++protect) {
            this.iterator.next().merge(this);
        }
        if (this.iterator.hasNext()) {
            throw new CalendricalException("Merge fields failed, infinite loop blocked, probably caused by an incorrectly implemented field rule");
        }
    }

    private void interpret() {
        for (Map.Entry<CalendricalRule<?>, Object> entry : this.inputMap.entrySet()) {
            CalendricalRule<?> rule = entry.getKey();
            Object value = rule.interpretValue(this, entry.getValue());
            this.processingMap.put(rule, value);
        }
    }

    private void removeDerivable() {
        Iterator<CalendricalRule<?>> it = this.processingMap.keySet().iterator();
        while (it.hasNext()) {
            Object derivedValue = it.next().derive(this);
            if (derivedValue == null) continue;
            it.remove();
        }
    }
}

