/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar;

import java.io.Serializable;
import java.util.Comparator;
import javax.time.CalendricalException;
import javax.time.calendar.Calendrical;
import javax.time.calendar.CalendricalMerger;
import javax.time.calendar.Chronology;
import javax.time.calendar.ISOChronology;
import javax.time.calendar.PeriodUnit;
import javax.time.calendar.UnsupportedRuleException;

public abstract class CalendricalRule<T>
implements Comparable<CalendricalRule<T>>,
Comparator<Calendrical>,
Serializable {
    private static final long serialVersionUID = 36518675L;
    private final Class<T> reified;
    private final Chronology chronology;
    private final String id;
    private final String name;
    private final PeriodUnit periodUnit;
    private final PeriodUnit periodRange;

    protected CalendricalRule(Class<T> reifiedClass, Chronology chronology, String name, PeriodUnit periodUnit, PeriodUnit periodRange) {
        if (reifiedClass == null) {
            throw new NullPointerException("Reified class must not be null");
        }
        if (chronology == null) {
            throw new NullPointerException("Chronology must not be null");
        }
        if (name == null) {
            throw new NullPointerException("Name must not be null");
        }
        if (periodUnit == null && periodRange != null) {
            throw new NullPointerException("Peiod unit must not be null if period range is non-null");
        }
        this.reified = reifiedClass;
        this.chronology = chronology;
        this.id = chronology.getName() + '.' + name;
        this.name = name;
        this.periodUnit = periodUnit;
        this.periodRange = periodRange;
    }

    public final Chronology getChronology() {
        return this.chronology;
    }

    public final String getID() {
        return this.id;
    }

    public final String getName() {
        return this.name;
    }

    public PeriodUnit getPeriodUnit() {
        return this.periodUnit;
    }

    public PeriodUnit getPeriodRange() {
        return this.periodRange;
    }

    public final Class<T> getReifiedType() {
        return this.reified;
    }

    public final T reify(Object value) {
        if (value == null) {
            return null;
        }
        if (this.reified.isInstance(value)) {
            return (T)value;
        }
        throw new ClassCastException("Value of type " + value.getClass().getName() + " cannot be cast to type " + this.reified.getName());
    }

    public final T getValue(Calendrical calendrical) {
        ISOChronology.checkNotNull(calendrical, "Calendrical must not be null");
        return calendrical.get(this);
    }

    public final T getValueChecked(Calendrical calendrical) {
        T value = this.getValue(calendrical);
        if (value == null) {
            throw new UnsupportedRuleException(this);
        }
        return value;
    }

    public final <R> R deriveValueFor(CalendricalRule<R> rule, T value, Calendrical calendrical) {
        ISOChronology.checkNotNull(rule, "CalendricalRule must not be null");
        ISOChronology.checkNotNull(value, "Value must not be null");
        ISOChronology.checkNotNull(calendrical, "Calendrical must not be null");
        if (rule.equals(this)) {
            return rule.reify(value);
        }
        return rule.derive(calendrical);
    }

    public final T deriveValueFrom(Calendrical calendrical) {
        ISOChronology.checkNotNull(calendrical, "Calendrical must not be null");
        return this.derive(calendrical);
    }

    protected T derive(Calendrical calendrical) {
        return null;
    }

    final T interpretValue(CalendricalMerger merger, Object value) {
        if (this.reified.isInstance(value)) {
            return this.reify(value);
        }
        T result = this.interpret(merger, value);
        if (result != null) {
            return result;
        }
        throw new CalendricalException("Unable to complete merge as input contains an unknown type  for rule '" + this.getName() + "': " + value.getClass().getName());
    }

    protected T interpret(CalendricalMerger merger, Object value) {
        return null;
    }

    protected void merge(CalendricalMerger merger) {
    }

    @Override
    public int compare(Calendrical cal1, Calendrical cal2) {
        Comparable value1 = (Comparable)cal1.get(this);
        Object value2 = cal2.get(this);
        if (value1 == null && value2 == null) {
            return 0;
        }
        if (value1 == null) {
            return 1;
        }
        if (value2 == null) {
            return -1;
        }
        return value1.compareTo(value2);
    }

    @Override
    public int compareTo(CalendricalRule<T> other) {
        if (this.getPeriodUnit() == null) {
            if (other.getPeriodUnit() == null) {
                return this.getID().compareTo(other.getID());
            }
            return 1;
        }
        if (other.getPeriodUnit() == null) {
            return -1;
        }
        int cmp = this.getPeriodUnit().compareTo(other.getPeriodUnit());
        if (cmp != 0) {
            return cmp;
        }
        if (this.getPeriodRange() == null) {
            if (other.getPeriodRange() == null) {
                return this.getID().compareTo(other.getID());
            }
            return 1;
        }
        if (other.getPeriodRange() == null) {
            return -1;
        }
        cmp = this.getPeriodRange().compareTo(other.getPeriodRange());
        if (cmp != 0) {
            return cmp;
        }
        return this.getID().compareTo(other.getID());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.id.equals(((CalendricalRule)obj).id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return this.id;
    }
}

