/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar;

import java.io.Serializable;
import javax.time.calendar.Calendrical;
import javax.time.calendar.CalendricalMatcher;
import javax.time.calendar.CalendricalMerger;
import javax.time.calendar.CalendricalRule;
import javax.time.calendar.DateAdjuster;
import javax.time.calendar.DateProvider;
import javax.time.calendar.DateResolver;
import javax.time.calendar.DateTimeProvider;
import javax.time.calendar.DayOfWeek;
import javax.time.calendar.ISOChronology;
import javax.time.calendar.LocalDate;
import javax.time.calendar.LocalTime;
import javax.time.calendar.MonthOfYear;
import javax.time.calendar.OffsetDateTime;
import javax.time.calendar.TimeAdjuster;
import javax.time.calendar.TimeProvider;
import javax.time.calendar.TimeZone;
import javax.time.calendar.Year;
import javax.time.calendar.ZoneOffset;
import javax.time.calendar.ZoneResolver;
import javax.time.calendar.ZoneResolvers;
import javax.time.calendar.ZonedDateTime;
import javax.time.calendar.format.DateTimeFormatters;
import javax.time.period.Period;
import javax.time.period.PeriodProvider;

public final class LocalDateTime
implements Calendrical,
DateTimeProvider,
Comparable<LocalDateTime>,
CalendricalMatcher,
DateAdjuster,
TimeAdjuster,
Serializable {
    private static final long serialVersionUID = 1153828870L;
    private final LocalDate date;
    private final LocalTime time;

    public static LocalDateTime midnight(int year, MonthOfYear monthOfYear, int dayOfMonth) {
        LocalDate date = LocalDate.of(year, monthOfYear, dayOfMonth);
        return new LocalDateTime(date, LocalTime.MIDNIGHT);
    }

    public static LocalDateTime midnight(int year, int monthOfYear, int dayOfMonth) {
        LocalDate date = LocalDate.of(year, monthOfYear, dayOfMonth);
        return new LocalDateTime(date, LocalTime.MIDNIGHT);
    }

    public static LocalDateTime midnightFrom(DateProvider dateProvider) {
        LocalDate date = LocalDate.from(dateProvider);
        return new LocalDateTime(date, LocalTime.MIDNIGHT);
    }

    public static LocalDateTime of(int year, MonthOfYear monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour) {
        LocalDate date = LocalDate.of(year, monthOfYear, dayOfMonth);
        LocalTime time = LocalTime.of(hourOfDay, minuteOfHour);
        return new LocalDateTime(date, time);
    }

    public static LocalDateTime of(int year, MonthOfYear monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour, int secondOfMinute) {
        LocalDate date = LocalDate.of(year, monthOfYear, dayOfMonth);
        LocalTime time = LocalTime.of(hourOfDay, minuteOfHour, secondOfMinute);
        return new LocalDateTime(date, time);
    }

    public static LocalDateTime of(int year, MonthOfYear monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour, int secondOfMinute, int nanoOfSecond) {
        LocalDate date = LocalDate.of(year, monthOfYear, dayOfMonth);
        LocalTime time = LocalTime.of(hourOfDay, minuteOfHour, secondOfMinute, nanoOfSecond);
        return new LocalDateTime(date, time);
    }

    public static LocalDateTime of(int year, int monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour) {
        LocalDate date = LocalDate.of(year, monthOfYear, dayOfMonth);
        LocalTime time = LocalTime.of(hourOfDay, minuteOfHour);
        return new LocalDateTime(date, time);
    }

    public static LocalDateTime of(int year, int monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour, int secondOfMinute) {
        LocalDate date = LocalDate.of(year, monthOfYear, dayOfMonth);
        LocalTime time = LocalTime.of(hourOfDay, minuteOfHour, secondOfMinute);
        return new LocalDateTime(date, time);
    }

    public static LocalDateTime of(int year, int monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour, int secondOfMinute, int nanoOfSecond) {
        LocalDate date = LocalDate.of(year, monthOfYear, dayOfMonth);
        LocalTime time = LocalTime.of(hourOfDay, minuteOfHour, secondOfMinute, nanoOfSecond);
        return new LocalDateTime(date, time);
    }

    public static LocalDateTime from(DateProvider dateProvider, TimeProvider timeProvider) {
        LocalDate date = LocalDate.from(dateProvider);
        LocalTime time = LocalTime.from(timeProvider);
        return new LocalDateTime(date, time);
    }

    public static LocalDateTime from(DateTimeProvider dateTimeProvider) {
        ISOChronology.checkNotNull(dateTimeProvider, "DateTimeProvider must not be null");
        LocalDateTime result = dateTimeProvider.toLocalDateTime();
        ISOChronology.checkNotNull(result, "DateTimeProvider implementation must not return null");
        return result;
    }

    public static LocalDateTime parse(String text) {
        return DateTimeFormatters.isoLocalDateTime().parse(text, LocalDateTime.rule());
    }

    private LocalDateTime(LocalDate date, LocalTime time) {
        this.date = date;
        this.time = time;
    }

    private LocalDateTime with(LocalDate newDate, LocalTime newTime) {
        if (this.date == newDate && this.time == newTime) {
            return this;
        }
        return new LocalDateTime(newDate, newTime);
    }

    public ISOChronology getChronology() {
        return ISOChronology.INSTANCE;
    }

    @Override
    public <T> T get(CalendricalRule<T> rule) {
        return LocalDateTime.rule().deriveValueFor(rule, this, this);
    }

    public int getYear() {
        return this.date.getYear();
    }

    public MonthOfYear getMonthOfYear() {
        return this.date.getMonthOfYear();
    }

    public int getDayOfMonth() {
        return this.date.getDayOfMonth();
    }

    public int getDayOfYear() {
        return this.date.getDayOfYear();
    }

    public DayOfWeek getDayOfWeek() {
        return this.date.getDayOfWeek();
    }

    public int getHourOfDay() {
        return this.time.getHourOfDay();
    }

    public int getMinuteOfHour() {
        return this.time.getMinuteOfHour();
    }

    public int getSecondOfMinute() {
        return this.time.getSecondOfMinute();
    }

    public int getNanoOfSecond() {
        return this.time.getNanoOfSecond();
    }

    public LocalDateTime with(DateAdjuster adjuster) {
        return this.with(this.date.with(adjuster), this.time);
    }

    public LocalDateTime with(TimeAdjuster adjuster) {
        return this.with(this.date, this.time.with(adjuster));
    }

    public LocalDateTime withYear(int year) {
        return this.with(this.date.withYear(year), this.time);
    }

    public LocalDateTime withYear(int year, DateResolver dateResolver) {
        return this.with(this.date.withYear(year, dateResolver), this.time);
    }

    public LocalDateTime withMonthOfYear(int monthOfYear) {
        return this.with(this.date.withMonthOfYear(monthOfYear), this.time);
    }

    public LocalDateTime withMonthOfYear(int monthOfYear, DateResolver dateResolver) {
        return this.with(this.date.withMonthOfYear(monthOfYear, dateResolver), this.time);
    }

    public LocalDateTime with(MonthOfYear monthOfYear) {
        return this.with(this.date.with(monthOfYear), this.time);
    }

    public LocalDateTime with(MonthOfYear monthOfYear, DateResolver dateResolver) {
        return this.with(this.date.with(monthOfYear, dateResolver), this.time);
    }

    public LocalDateTime withDayOfMonth(int dayOfMonth) {
        return this.with(this.date.withDayOfMonth(dayOfMonth), this.time);
    }

    public LocalDateTime withDayOfMonth(int dayOfMonth, DateResolver dateResolver) {
        return this.with(this.date.withDayOfMonth(dayOfMonth, dateResolver), this.time);
    }

    public LocalDateTime withDayOfYear(int dayOfYear) {
        return this.with(this.date.withDayOfYear(dayOfYear), this.time);
    }

    public LocalDateTime withDate(int year, MonthOfYear monthOfYear, int dayOfMonth) {
        if (year == this.getYear() && monthOfYear == this.getMonthOfYear() && dayOfMonth == this.getDayOfMonth()) {
            return this;
        }
        LocalDate newDate = LocalDate.of(year, monthOfYear, dayOfMonth);
        return this.with(newDate, this.time);
    }

    public LocalDateTime withDate(int year, int monthOfYear, int dayOfMonth) {
        if (year == this.getYear() && monthOfYear == this.getMonthOfYear().getValue() && dayOfMonth == this.getDayOfMonth()) {
            return this;
        }
        LocalDate newDate = LocalDate.of(year, monthOfYear, dayOfMonth);
        return this.with(newDate, this.time);
    }

    public LocalDateTime withHourOfDay(int hourOfDay) {
        LocalTime newTime = this.time.withHourOfDay(hourOfDay);
        return this.with(this.date, newTime);
    }

    public LocalDateTime withMinuteOfHour(int minuteOfHour) {
        LocalTime newTime = this.time.withMinuteOfHour(minuteOfHour);
        return this.with(this.date, newTime);
    }

    public LocalDateTime withSecondOfMinute(int secondOfMinute) {
        LocalTime newTime = this.time.withSecondOfMinute(secondOfMinute);
        return this.with(this.date, newTime);
    }

    public LocalDateTime withNanoOfSecond(int nanoOfSecond) {
        LocalTime newTime = this.time.withNanoOfSecond(nanoOfSecond);
        return this.with(this.date, newTime);
    }

    public LocalDateTime withTime(int hourOfDay, int minuteOfHour) {
        return this.withTime(hourOfDay, minuteOfHour, 0, 0);
    }

    public LocalDateTime withTime(int hourOfDay, int minuteOfHour, int secondOfMinute) {
        return this.withTime(hourOfDay, minuteOfHour, secondOfMinute, 0);
    }

    public LocalDateTime withTime(int hourOfDay, int minuteOfHour, int secondOfMinute, int nanoOfSecond) {
        if (hourOfDay == this.getHourOfDay() && minuteOfHour == this.getMinuteOfHour() && secondOfMinute == this.getSecondOfMinute() && nanoOfSecond == this.getNanoOfSecond()) {
            return this;
        }
        LocalTime newTime = LocalTime.of(hourOfDay, minuteOfHour, secondOfMinute, nanoOfSecond);
        return this.with(this.date, newTime);
    }

    public LocalDateTime plus(PeriodProvider periodProvider) {
        Period period = Period.from(periodProvider);
        LocalDate date = this.date.plusYears(period.getYears()).plusMonths(period.getMonths()).plusDays(period.getDays());
        LocalTime.Overflow overflow = this.time.plusWithOverflow(period.getHours(), period.getMinutes(), period.getSeconds(), period.getNanos());
        LocalDateTime result = overflow.toLocalDateTime(date);
        return result.equals(this) ? this : result;
    }

    public LocalDateTime plusYears(int years) {
        LocalDate newDate = this.date.plusYears(years);
        return this.with(newDate, this.time);
    }

    public LocalDateTime plusYears(int years, DateResolver dateResolver) {
        LocalDate newDate = this.date.plusYears(years, dateResolver);
        return this.with(newDate, this.time);
    }

    public LocalDateTime plusMonths(int months) {
        LocalDate newDate = this.date.plusMonths(months);
        return this.with(newDate, this.time);
    }

    public LocalDateTime plusMonths(int months, DateResolver dateResolver) {
        LocalDate newDate = this.date.plusMonths(months, dateResolver);
        return this.with(newDate, this.time);
    }

    public LocalDateTime plusWeeks(int weeks) {
        LocalDate newDate = this.date.plusWeeks(weeks);
        return this.with(newDate, this.time);
    }

    public LocalDateTime plusDays(long days) {
        LocalDate newDate = this.date.plusDays(days);
        return this.with(newDate, this.time);
    }

    public LocalDateTime plusHours(int hours) {
        LocalTime.Overflow overflow = this.time.plusWithOverflow(hours, 0, 0, 0L);
        LocalDate newDate = this.date.plusDays(overflow.getOverflowDays());
        return this.with(newDate, overflow.getResultTime());
    }

    public LocalDateTime plusMinutes(int minutes) {
        LocalTime.Overflow overflow = this.time.plusWithOverflow(0, minutes, 0, 0L);
        LocalDate newDate = this.date.plusDays(overflow.getOverflowDays());
        return this.with(newDate, overflow.getResultTime());
    }

    public LocalDateTime plusSeconds(int seconds) {
        LocalTime.Overflow overflow = this.time.plusWithOverflow(0, 0, seconds, 0L);
        LocalDate newDate = this.date.plusDays(overflow.getOverflowDays());
        return this.with(newDate, overflow.getResultTime());
    }

    public LocalDateTime plusNanos(long nanos) {
        LocalTime.Overflow overflow = this.time.plusWithOverflow(0, 0, 0, nanos);
        LocalDate newDate = this.date.plusDays(overflow.getOverflowDays());
        return this.with(newDate, overflow.getResultTime());
    }

    public LocalDateTime minus(PeriodProvider periodProvider) {
        Period period = Period.from(periodProvider);
        LocalDate date = this.date.minusYears(period.getYears()).minusMonths(period.getMonths()).minusDays(period.getDays());
        LocalTime.Overflow overflow = this.time.minusWithOverflow(period.getHours(), period.getMinutes(), period.getSeconds(), period.getNanos());
        LocalDateTime result = overflow.toLocalDateTime(date);
        return result.equals(this) ? this : result;
    }

    public LocalDateTime minusYears(int years) {
        LocalDate newDate = this.date.minusYears(years);
        return this.with(newDate, this.time);
    }

    public LocalDateTime minusYears(int years, DateResolver dateResolver) {
        LocalDate newDate = this.date.minusYears(years, dateResolver);
        return this.with(newDate, this.time);
    }

    public LocalDateTime minusMonths(int months) {
        LocalDate newDate = this.date.minusMonths(months);
        return this.with(newDate, this.time);
    }

    public LocalDateTime minusMonths(int months, DateResolver dateResolver) {
        LocalDate newDate = this.date.minusMonths(months, dateResolver);
        return this.with(newDate, this.time);
    }

    public LocalDateTime minusWeeks(int weeks) {
        LocalDate newDate = this.date.minusWeeks(weeks);
        return this.with(newDate, this.time);
    }

    public LocalDateTime minusDays(long days) {
        LocalDate newDate = this.date.minusDays(days);
        return this.with(newDate, this.time);
    }

    public LocalDateTime minusHours(int hours) {
        LocalTime.Overflow overflow = this.time.minusWithOverflow(hours, 0, 0, 0L);
        LocalDate newDate = this.date.plusDays(overflow.getOverflowDays());
        return this.with(newDate, overflow.getResultTime());
    }

    public LocalDateTime minusMinutes(int minutes) {
        LocalTime.Overflow overflow = this.time.minusWithOverflow(0, minutes, 0, 0L);
        LocalDate newDate = this.date.plusDays(overflow.getOverflowDays());
        return this.with(newDate, overflow.getResultTime());
    }

    public LocalDateTime minusSeconds(int seconds) {
        LocalTime.Overflow overflow = this.time.minusWithOverflow(0, 0, seconds, 0L);
        LocalDate newDate = this.date.plusDays(overflow.getOverflowDays());
        return this.with(newDate, overflow.getResultTime());
    }

    public LocalDateTime minusNanos(long nanos) {
        LocalTime.Overflow overflow = this.time.minusWithOverflow(0, 0, 0, nanos);
        LocalDate newDate = this.date.plusDays(overflow.getOverflowDays());
        return this.with(newDate, overflow.getResultTime());
    }

    public boolean matches(CalendricalMatcher matcher) {
        return matcher.matchesCalendrical(this);
    }

    @Override
    public boolean matchesCalendrical(Calendrical calendrical) {
        return this.equals(calendrical.get(LocalDateTime.rule()));
    }

    @Override
    public LocalDate adjustDate(LocalDate date) {
        return this.date.adjustDate(date);
    }

    @Override
    public LocalTime adjustTime(LocalTime time) {
        return this.time.adjustTime(time);
    }

    public OffsetDateTime atOffset(ZoneOffset offset) {
        return OffsetDateTime.from(this, offset);
    }

    public ZonedDateTime atZone(TimeZone zone) {
        return ZonedDateTime.from(this, zone, ZoneResolvers.postTransition());
    }

    public ZonedDateTime atZone(TimeZone zone, ZoneResolver resolver) {
        return ZonedDateTime.from(this, zone, resolver);
    }

    @Override
    public LocalDate toLocalDate() {
        return this.date;
    }

    @Override
    public LocalTime toLocalTime() {
        return this.time;
    }

    @Override
    public LocalDateTime toLocalDateTime() {
        return this;
    }

    public Year toYear() {
        return this.date.toYear();
    }

    @Override
    public int compareTo(LocalDateTime other) {
        int cmp = this.date.compareTo(other.date);
        if (cmp == 0) {
            cmp = this.time.compareTo(other.time);
        }
        return cmp;
    }

    public boolean isAfter(LocalDateTime other) {
        return this.compareTo(other) > 0;
    }

    public boolean isBefore(LocalDateTime other) {
        return this.compareTo(other) < 0;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof LocalDateTime) {
            LocalDateTime dt = (LocalDateTime)other;
            return this.date.equals(dt.date) && this.time.equals(dt.time);
        }
        return false;
    }

    public int hashCode() {
        return this.date.hashCode() ^ this.time.hashCode();
    }

    public String toString() {
        return this.date + "T" + this.time;
    }

    public static CalendricalRule<LocalDateTime> rule() {
        return Rule.INSTANCE;
    }

    static final class Rule
    extends CalendricalRule<LocalDateTime>
    implements Serializable {
        private static final CalendricalRule<LocalDateTime> INSTANCE = new Rule();
        private static final long serialVersionUID = 1L;

        private Rule() {
            super(LocalDateTime.class, ISOChronology.INSTANCE, "LocalDateTime", ISOChronology.periodNanos(), null);
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        protected LocalDateTime derive(Calendrical calendrical) {
            OffsetDateTime odt = calendrical.get(OffsetDateTime.rule());
            return odt != null ? odt.toLocalDateTime() : null;
        }

        @Override
        protected void merge(CalendricalMerger merger) {
            ZoneOffset offset = merger.getValue(ZoneOffset.rule());
            if (offset != null) {
                LocalDateTime dateTime = merger.getValue(this);
                merger.storeMerged(OffsetDateTime.rule(), OffsetDateTime.from(dateTime, offset));
                merger.removeProcessed(this);
                merger.removeProcessed(ZoneOffset.rule());
            }
        }
    }
}

