/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar;

import java.io.Serializable;
import javax.time.Instant;
import javax.time.InstantProvider;
import javax.time.MathUtils;
import javax.time.calendar.Calendrical;
import javax.time.calendar.CalendricalMatcher;
import javax.time.calendar.CalendricalRule;
import javax.time.calendar.DateAdjuster;
import javax.time.calendar.DateProvider;
import javax.time.calendar.DateResolver;
import javax.time.calendar.DateTimeProvider;
import javax.time.calendar.DayOfWeek;
import javax.time.calendar.ISOChronology;
import javax.time.calendar.LocalDate;
import javax.time.calendar.LocalDateTime;
import javax.time.calendar.LocalTime;
import javax.time.calendar.MonthOfYear;
import javax.time.calendar.OffsetDate;
import javax.time.calendar.OffsetTime;
import javax.time.calendar.TimeAdjuster;
import javax.time.calendar.TimeProvider;
import javax.time.calendar.TimeZone;
import javax.time.calendar.Year;
import javax.time.calendar.ZoneOffset;
import javax.time.calendar.ZoneResolver;
import javax.time.calendar.ZoneResolvers;
import javax.time.calendar.ZonedDateTime;
import javax.time.calendar.format.DateTimeFormatters;
import javax.time.period.PeriodProvider;

public final class OffsetDateTime
implements Calendrical,
InstantProvider,
DateTimeProvider,
CalendricalMatcher,
DateAdjuster,
TimeAdjuster,
Comparable<OffsetDateTime>,
Serializable {
    private static final long serialVersionUID = -456761901L;
    private final LocalDateTime dateTime;
    private final ZoneOffset offset;

    public static OffsetDateTime midnight(int year, MonthOfYear monthOfYear, int dayOfMonth, ZoneOffset offset) {
        LocalDateTime dt = LocalDateTime.midnight(year, monthOfYear, dayOfMonth);
        return new OffsetDateTime(dt, offset);
    }

    public static OffsetDateTime midnight(int year, int monthOfYear, int dayOfMonth, ZoneOffset offset) {
        LocalDateTime dt = LocalDateTime.midnight(year, monthOfYear, dayOfMonth);
        return new OffsetDateTime(dt, offset);
    }

    public static OffsetDateTime midnightFrom(DateProvider dateProvider, ZoneOffset offset) {
        LocalDateTime dt = LocalDateTime.midnightFrom(dateProvider);
        return new OffsetDateTime(dt, offset);
    }

    public static OffsetDateTime of(int year, MonthOfYear monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour, ZoneOffset offset) {
        LocalDateTime dt = LocalDateTime.of(year, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour);
        return new OffsetDateTime(dt, offset);
    }

    public static OffsetDateTime of(int year, MonthOfYear monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour, int secondOfMinute, ZoneOffset offset) {
        LocalDateTime dt = LocalDateTime.of(year, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour, secondOfMinute);
        return new OffsetDateTime(dt, offset);
    }

    public static OffsetDateTime of(int year, MonthOfYear monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour, int secondOfMinute, int nanoOfSecond, ZoneOffset offset) {
        LocalDateTime dt = LocalDateTime.of(year, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour, secondOfMinute, nanoOfSecond);
        return new OffsetDateTime(dt, offset);
    }

    public static OffsetDateTime of(int year, int monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour, ZoneOffset offset) {
        LocalDateTime dt = LocalDateTime.of(year, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour);
        return new OffsetDateTime(dt, offset);
    }

    public static OffsetDateTime of(int year, int monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour, int secondOfMinute, ZoneOffset offset) {
        LocalDateTime dt = LocalDateTime.of(year, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour, secondOfMinute);
        return new OffsetDateTime(dt, offset);
    }

    public static OffsetDateTime of(int year, int monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour, int secondOfMinute, int nanoOfSecond, ZoneOffset offset) {
        LocalDateTime dt = LocalDateTime.of(year, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour, secondOfMinute, nanoOfSecond);
        return new OffsetDateTime(dt, offset);
    }

    public static OffsetDateTime from(DateProvider dateProvider, TimeProvider timeProvider, ZoneOffset offset) {
        LocalDateTime dt = LocalDateTime.from(dateProvider, timeProvider);
        return new OffsetDateTime(dt, offset);
    }

    public static OffsetDateTime from(DateTimeProvider dateTimeProvider, ZoneOffset offset) {
        LocalDateTime dt = LocalDateTime.from(dateTimeProvider);
        return new OffsetDateTime(dt, offset);
    }

    public static OffsetDateTime fromInstant(InstantProvider instantProvider, ZoneOffset offset) {
        Instant instant = Instant.from(instantProvider);
        ISOChronology.checkNotNull(offset, "ZoneOffset must not be null");
        long epochSecs = instant.getEpochSeconds() + (long)offset.getAmountSeconds();
        long yearZeroDays = epochSecs / 86400L + 719528L;
        int secsOfDay = (int)(epochSecs % 86400L);
        if (secsOfDay < 0) {
            secsOfDay += 86400;
            --yearZeroDays;
        }
        LocalDate date = LocalDate.fromYearZeroDays(yearZeroDays);
        LocalTime time = LocalTime.fromSecondOfDay(secsOfDay, instant.getNanoOfSecond());
        LocalDateTime dateTime = LocalDateTime.from(date, time);
        return new OffsetDateTime(dateTime, offset);
    }

    public static OffsetDateTime parse(String text) {
        return DateTimeFormatters.isoOffsetDateTime().parse(text, OffsetDateTime.rule());
    }

    private OffsetDateTime(LocalDateTime dateTime, ZoneOffset offset) {
        if (dateTime == null) {
            throw new NullPointerException("The date-time must not be null");
        }
        if (offset == null) {
            throw new NullPointerException("The zone offset must not be null");
        }
        this.dateTime = dateTime;
        this.offset = offset;
    }

    private OffsetDateTime with(LocalDateTime dateTime, ZoneOffset offset) {
        if (this.dateTime == dateTime && this.offset.equals(offset)) {
            return this;
        }
        return new OffsetDateTime(dateTime, offset);
    }

    public ISOChronology getChronology() {
        return ISOChronology.INSTANCE;
    }

    @Override
    public <T> T get(CalendricalRule<T> rule) {
        return OffsetDateTime.rule().deriveValueFor(rule, this, this);
    }

    public OffsetDateTime withDateTime(DateTimeProvider dateTimeProvider) {
        LocalDateTime localDateTime = LocalDateTime.from(dateTimeProvider);
        return localDateTime.equals(this.dateTime) ? this : new OffsetDateTime(localDateTime, this.offset);
    }

    public ZoneOffset getOffset() {
        return this.offset;
    }

    public OffsetDateTime withOffsetSameLocal(ZoneOffset offset) {
        return this.with(this.dateTime, offset);
    }

    public OffsetDateTime withOffsetSameInstant(ZoneOffset offset) {
        if (offset.equals(this.offset)) {
            return this;
        }
        int difference = offset.getAmountSeconds() - this.offset.getAmountSeconds();
        LocalDateTime adjusted = this.dateTime.plusSeconds(difference);
        return new OffsetDateTime(adjusted, offset);
    }

    public int getYear() {
        return this.dateTime.getYear();
    }

    public MonthOfYear getMonthOfYear() {
        return this.dateTime.getMonthOfYear();
    }

    public int getDayOfMonth() {
        return this.dateTime.getDayOfMonth();
    }

    public int getDayOfYear() {
        return this.dateTime.getDayOfYear();
    }

    public DayOfWeek getDayOfWeek() {
        return this.dateTime.getDayOfWeek();
    }

    public int getHourOfDay() {
        return this.dateTime.getHourOfDay();
    }

    public int getMinuteOfHour() {
        return this.dateTime.getMinuteOfHour();
    }

    public int getSecondOfMinute() {
        return this.dateTime.getSecondOfMinute();
    }

    public int getNanoOfSecond() {
        return this.dateTime.getNanoOfSecond();
    }

    public OffsetDateTime with(DateAdjuster adjuster) {
        return this.with(this.dateTime.with(adjuster), this.offset);
    }

    public OffsetDateTime with(TimeAdjuster adjuster) {
        return this.with(this.dateTime.with(adjuster), this.offset);
    }

    public OffsetDateTime withYear(int year) {
        return this.with(this.dateTime.withYear(year), this.offset);
    }

    public OffsetDateTime withYear(int year, DateResolver dateResolver) {
        return this.with(this.dateTime.withYear(year, dateResolver), this.offset);
    }

    public OffsetDateTime withMonthOfYear(int monthOfYear) {
        return this.with(this.dateTime.withMonthOfYear(monthOfYear), this.offset);
    }

    public OffsetDateTime withMonthOfYear(int monthOfYear, DateResolver dateResolver) {
        return this.with(this.dateTime.withMonthOfYear(monthOfYear, dateResolver), this.offset);
    }

    public OffsetDateTime with(MonthOfYear monthOfYear) {
        return this.with(this.dateTime.with(monthOfYear), this.offset);
    }

    public OffsetDateTime with(MonthOfYear monthOfYear, DateResolver dateResolver) {
        return this.with(this.dateTime.with(monthOfYear, dateResolver), this.offset);
    }

    public OffsetDateTime withDayOfMonth(int dayOfMonth) {
        return this.with(this.dateTime.withDayOfMonth(dayOfMonth), this.offset);
    }

    public OffsetDateTime withDayOfMonth(int dayOfMonth, DateResolver dateResolver) {
        return this.with(this.dateTime.withDayOfMonth(dayOfMonth, dateResolver), this.offset);
    }

    public OffsetDateTime withDayOfYear(int dayOfYear) {
        return this.with(this.dateTime.withDayOfYear(dayOfYear), this.offset);
    }

    public OffsetDateTime withDate(int year, MonthOfYear monthOfYear, int dayOfMonth) {
        return this.with(this.dateTime.withDate(year, monthOfYear, dayOfMonth), this.offset);
    }

    public OffsetDateTime withDate(int year, int monthOfYear, int dayOfMonth) {
        return this.with(this.dateTime.withDate(year, monthOfYear, dayOfMonth), this.offset);
    }

    public OffsetDateTime withHourOfDay(int hourOfDay) {
        LocalDateTime newDT = this.dateTime.withHourOfDay(hourOfDay);
        return newDT == this.dateTime ? this : new OffsetDateTime(newDT, this.offset);
    }

    public OffsetDateTime withMinuteOfHour(int minuteOfHour) {
        LocalDateTime newDT = this.dateTime.withMinuteOfHour(minuteOfHour);
        return newDT == this.dateTime ? this : new OffsetDateTime(newDT, this.offset);
    }

    public OffsetDateTime withSecondOfMinute(int secondOfMinute) {
        LocalDateTime newDT = this.dateTime.withSecondOfMinute(secondOfMinute);
        return newDT == this.dateTime ? this : new OffsetDateTime(newDT, this.offset);
    }

    public OffsetDateTime withNanoOfSecond(int nanoOfSecond) {
        LocalDateTime newDT = this.dateTime.withNanoOfSecond(nanoOfSecond);
        return newDT == this.dateTime ? this : new OffsetDateTime(newDT, this.offset);
    }

    public OffsetDateTime withTime(int hourOfDay, int minuteOfHour) {
        LocalDateTime newDT = this.dateTime.withTime(hourOfDay, minuteOfHour);
        return newDT == this.dateTime ? this : new OffsetDateTime(newDT, this.offset);
    }

    public OffsetDateTime withTime(int hourOfDay, int minuteOfHour, int secondOfMinute) {
        LocalDateTime newDT = this.dateTime.withTime(hourOfDay, minuteOfHour, secondOfMinute);
        return newDT == this.dateTime ? this : new OffsetDateTime(newDT, this.offset);
    }

    public OffsetDateTime withTime(int hourOfDay, int minuteOfHour, int secondOfMinute, int nanoOfSecond) {
        LocalDateTime newDT = this.dateTime.withTime(hourOfDay, minuteOfHour, secondOfMinute, nanoOfSecond);
        return newDT == this.dateTime ? this : new OffsetDateTime(newDT, this.offset);
    }

    public OffsetDateTime plus(PeriodProvider periodProvider) {
        LocalDateTime newDT = this.dateTime.plus(periodProvider);
        return newDT == this.dateTime ? this : new OffsetDateTime(newDT, this.offset);
    }

    public OffsetDateTime plusYears(int years) {
        LocalDateTime newDT = this.dateTime.plusYears(years);
        return newDT == this.dateTime ? this : new OffsetDateTime(newDT, this.offset);
    }

    public OffsetDateTime plusYears(int years, DateResolver dateResolver) {
        LocalDateTime newDT = this.dateTime.plusYears(years, dateResolver);
        return newDT == this.dateTime ? this : new OffsetDateTime(newDT, this.offset);
    }

    public OffsetDateTime plusMonths(int months) {
        LocalDateTime newDT = this.dateTime.plusMonths(months);
        return newDT == this.dateTime ? this : new OffsetDateTime(newDT, this.offset);
    }

    public OffsetDateTime plusMonths(int months, DateResolver dateResolver) {
        LocalDateTime newDT = this.dateTime.plusMonths(months);
        return newDT == this.dateTime ? this : new OffsetDateTime(newDT, this.offset);
    }

    public OffsetDateTime plusWeeks(int weeks) {
        LocalDateTime newDT = this.dateTime.plusWeeks(weeks);
        return newDT == this.dateTime ? this : new OffsetDateTime(newDT, this.offset);
    }

    public OffsetDateTime plusDays(int days) {
        LocalDateTime newDT = this.dateTime.plusDays(days);
        return newDT == this.dateTime ? this : new OffsetDateTime(newDT, this.offset);
    }

    public OffsetDateTime plusHours(int hours) {
        LocalDateTime newDT = this.dateTime.plusHours(hours);
        return newDT == this.dateTime ? this : new OffsetDateTime(newDT, this.offset);
    }

    public OffsetDateTime plusMinutes(int minutes) {
        LocalDateTime newDT = this.dateTime.plusMinutes(minutes);
        return newDT == this.dateTime ? this : new OffsetDateTime(newDT, this.offset);
    }

    public OffsetDateTime plusSeconds(int seconds) {
        LocalDateTime newDT = this.dateTime.plusSeconds(seconds);
        return newDT == this.dateTime ? this : new OffsetDateTime(newDT, this.offset);
    }

    public OffsetDateTime plusNanos(int nanos) {
        LocalDateTime newDT = this.dateTime.plusNanos(nanos);
        return newDT == this.dateTime ? this : new OffsetDateTime(newDT, this.offset);
    }

    public OffsetDateTime minus(PeriodProvider periodProvider) {
        LocalDateTime newDT = this.dateTime.minus(periodProvider);
        return newDT == this.dateTime ? this : new OffsetDateTime(newDT, this.offset);
    }

    public OffsetDateTime minusYears(int years) {
        LocalDateTime newDT = this.dateTime.minusYears(years);
        return newDT == this.dateTime ? this : new OffsetDateTime(newDT, this.offset);
    }

    public OffsetDateTime minusYears(int years, DateResolver dateResolver) {
        LocalDateTime newDT = this.dateTime.minusYears(years, dateResolver);
        return newDT == this.dateTime ? this : new OffsetDateTime(newDT, this.offset);
    }

    public OffsetDateTime minusMonths(int months) {
        LocalDateTime newDT = this.dateTime.minusMonths(months);
        return newDT == this.dateTime ? this : new OffsetDateTime(newDT, this.offset);
    }

    public OffsetDateTime minusMonths(int months, DateResolver dateResolver) {
        LocalDateTime newDT = this.dateTime.minusMonths(months);
        return newDT == this.dateTime ? this : new OffsetDateTime(newDT, this.offset);
    }

    public OffsetDateTime minusWeeks(int weeks) {
        LocalDateTime newDT = this.dateTime.minusWeeks(weeks);
        return newDT == this.dateTime ? this : new OffsetDateTime(newDT, this.offset);
    }

    public OffsetDateTime minusDays(int days) {
        LocalDateTime newDT = this.dateTime.minusDays(days);
        return newDT == this.dateTime ? this : new OffsetDateTime(newDT, this.offset);
    }

    public OffsetDateTime minusHours(int hours) {
        LocalDateTime newDT = this.dateTime.minusHours(hours);
        return newDT == this.dateTime ? this : new OffsetDateTime(newDT, this.offset);
    }

    public OffsetDateTime minusMinutes(int minutes) {
        LocalDateTime newDT = this.dateTime.minusMinutes(minutes);
        return newDT == this.dateTime ? this : new OffsetDateTime(newDT, this.offset);
    }

    public OffsetDateTime minusSeconds(int seconds) {
        LocalDateTime newDT = this.dateTime.minusSeconds(seconds);
        return newDT == this.dateTime ? this : new OffsetDateTime(newDT, this.offset);
    }

    public OffsetDateTime minusNanos(int nanos) {
        LocalDateTime newDT = this.dateTime.minusNanos(nanos);
        return newDT == this.dateTime ? this : new OffsetDateTime(newDT, this.offset);
    }

    public boolean matches(CalendricalMatcher matcher) {
        return matcher.matchesCalendrical(this);
    }

    @Override
    public boolean matchesCalendrical(Calendrical calendrical) {
        return this.equals(calendrical.get(OffsetDateTime.rule()));
    }

    @Override
    public LocalDate adjustDate(LocalDate date) {
        return this.dateTime.adjustDate(date);
    }

    @Override
    public LocalTime adjustTime(LocalTime time) {
        return this.dateTime.adjustTime(time);
    }

    public ZonedDateTime atZoneSameInstant(TimeZone zone) {
        return ZonedDateTime.fromInstant(this, zone);
    }

    public ZonedDateTime atZoneSimilarLocal(TimeZone zone) {
        return ZonedDateTime.from(this, zone, ZoneResolvers.postTransition());
    }

    public ZonedDateTime atZoneSimilarLocal(TimeZone zone, ZoneResolver resolver) {
        return ZonedDateTime.from(this, zone, resolver);
    }

    @Override
    public Instant toInstant() {
        return Instant.seconds(this.toEpochSeconds(), this.getNanoOfSecond());
    }

    @Override
    public LocalDate toLocalDate() {
        return this.dateTime.toLocalDate();
    }

    @Override
    public LocalTime toLocalTime() {
        return this.dateTime.toLocalTime();
    }

    @Override
    public LocalDateTime toLocalDateTime() {
        return this.dateTime;
    }

    public OffsetDate toOffsetDate() {
        return OffsetDate.from(this.dateTime, this.offset);
    }

    public OffsetTime toOffsetTime() {
        return OffsetTime.from(this.dateTime, this.offset);
    }

    public Year toYear() {
        return this.dateTime.toYear();
    }

    public long toEpochSeconds() {
        long epochDays = this.dateTime.toLocalDate().toEpochDays();
        long secs = epochDays * 60L * 60L * 24L + (long)this.dateTime.toLocalTime().toSecondOfDay();
        return secs -= (long)this.offset.getAmountSeconds();
    }

    @Override
    public int compareTo(OffsetDateTime other) {
        if (this.offset.equals(other.offset)) {
            return this.dateTime.compareTo(other.dateTime);
        }
        int compare = MathUtils.safeCompare(this.toEpochSeconds(), other.toEpochSeconds());
        if (compare == 0) {
            compare = this.dateTime.compareTo(other.dateTime);
        }
        return compare;
    }

    public boolean isBefore(OffsetDateTime other) {
        long otherEpochSecs;
        long thisEpochSecs = this.toEpochSeconds();
        return thisEpochSecs < (otherEpochSecs = other.toEpochSeconds()) || thisEpochSecs == otherEpochSecs && this.getNanoOfSecond() < other.getNanoOfSecond();
    }

    public boolean equalInstant(OffsetDateTime other) {
        return this.toEpochSeconds() == other.toEpochSeconds() && this.getNanoOfSecond() == other.getNanoOfSecond();
    }

    public boolean isAfter(OffsetDateTime other) {
        long otherEpochSecs;
        long thisEpochSecs = this.toEpochSeconds();
        return thisEpochSecs > (otherEpochSecs = other.toEpochSeconds()) || thisEpochSecs == otherEpochSecs && this.getNanoOfSecond() > other.getNanoOfSecond();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof OffsetDateTime) {
            OffsetDateTime offsetDateTime = (OffsetDateTime)other;
            return this.dateTime.equals(offsetDateTime.dateTime) && this.offset.equals(offsetDateTime.offset);
        }
        return false;
    }

    public int hashCode() {
        return this.dateTime.hashCode() ^ this.offset.hashCode();
    }

    public String toString() {
        return this.dateTime.toString() + this.offset.toString();
    }

    public static CalendricalRule<OffsetDateTime> rule() {
        return Rule.INSTANCE;
    }

    static final class Rule
    extends CalendricalRule<OffsetDateTime>
    implements Serializable {
        private static final CalendricalRule<OffsetDateTime> INSTANCE = new Rule();
        private static final long serialVersionUID = 1L;

        private Rule() {
            super(OffsetDateTime.class, ISOChronology.INSTANCE, "OffsetDateTime", ISOChronology.periodNanos(), null);
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        protected OffsetDateTime derive(Calendrical calendrical) {
            ZonedDateTime zdt = calendrical.get(ZonedDateTime.rule());
            return zdt != null ? zdt.toOffsetDateTime() : null;
        }
    }
}

