/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar;

import java.io.Serializable;
import javax.time.Instant;
import javax.time.InstantProvider;
import javax.time.calendar.Calendrical;
import javax.time.calendar.CalendricalMatcher;
import javax.time.calendar.CalendricalRule;
import javax.time.calendar.ISOChronology;
import javax.time.calendar.LocalTime;
import javax.time.calendar.OffsetDateTime;
import javax.time.calendar.TimeAdjuster;
import javax.time.calendar.TimeProvider;
import javax.time.calendar.ZoneOffset;
import javax.time.calendar.format.DateTimeFormatters;
import javax.time.period.PeriodProvider;

public final class OffsetTime
implements TimeProvider,
Calendrical,
Comparable<OffsetTime>,
Serializable,
CalendricalMatcher,
TimeAdjuster {
    private static final long serialVersionUID = -1751032571L;
    private final LocalTime time;
    private final ZoneOffset offset;

    public static OffsetTime of(int hourOfDay, int minuteOfHour, ZoneOffset offset) {
        LocalTime time = LocalTime.of(hourOfDay, minuteOfHour);
        return new OffsetTime(time, offset);
    }

    public static OffsetTime of(int hourOfDay, int minuteOfHour, int secondOfMinute, ZoneOffset offset) {
        LocalTime time = LocalTime.of(hourOfDay, minuteOfHour, secondOfMinute);
        return new OffsetTime(time, offset);
    }

    public static OffsetTime of(int hourOfDay, int minuteOfHour, int secondOfMinute, int nanoOfSecond, ZoneOffset offset) {
        LocalTime time = LocalTime.of(hourOfDay, minuteOfHour, secondOfMinute, nanoOfSecond);
        return new OffsetTime(time, offset);
    }

    public static OffsetTime from(TimeProvider timeProvider, ZoneOffset offset) {
        LocalTime time = LocalTime.from(timeProvider);
        return new OffsetTime(time, offset);
    }

    public static OffsetTime fromInstant(InstantProvider instantProvider, ZoneOffset offset) {
        Instant instant = Instant.from(instantProvider);
        ISOChronology.checkNotNull(offset, "ZoneOffset must not be null");
        long secsOfDay = instant.getEpochSeconds() % 86400L;
        secsOfDay = (secsOfDay + (long)offset.getAmountSeconds()) % 86400L;
        if (secsOfDay < 0L) {
            secsOfDay += 86400L;
        }
        LocalTime time = LocalTime.fromSecondOfDay(secsOfDay, instant.getNanoOfSecond());
        return new OffsetTime(time, offset);
    }

    public static OffsetTime parse(String text) {
        return DateTimeFormatters.isoOffsetTime().parse(text, OffsetTime.rule());
    }

    private OffsetTime(LocalTime time, ZoneOffset offset) {
        if (time == null) {
            throw new NullPointerException("The time must not be null");
        }
        if (offset == null) {
            throw new NullPointerException("The zone offset must not be null");
        }
        this.time = time;
        this.offset = offset;
    }

    public ISOChronology getChronology() {
        return ISOChronology.INSTANCE;
    }

    @Override
    public <T> T get(CalendricalRule<T> rule) {
        return OffsetTime.rule().deriveValueFor(rule, this, this);
    }

    public OffsetTime withTime(TimeProvider timeProvider) {
        LocalTime localTime = LocalTime.from(timeProvider);
        return localTime.equals(this.time) ? this : new OffsetTime(localTime, this.offset);
    }

    public ZoneOffset getOffset() {
        return this.offset;
    }

    public OffsetTime withOffset(ZoneOffset offset) {
        return offset != null && offset.equals(this.offset) ? this : new OffsetTime(this.time, offset);
    }

    public OffsetTime adjustLocalTime(ZoneOffset offset) {
        if (offset.equals(this.offset)) {
            return this;
        }
        int difference = offset.getAmountSeconds() - this.offset.getAmountSeconds();
        LocalTime adjusted = this.time.plusSeconds(difference);
        return new OffsetTime(adjusted, offset);
    }

    public int getHourOfDay() {
        return this.time.getHourOfDay();
    }

    public int getMinuteOfHour() {
        return this.time.getMinuteOfHour();
    }

    public int getSecondOfMinute() {
        return this.time.getSecondOfMinute();
    }

    public int getNanoOfSecond() {
        return this.time.getNanoOfSecond();
    }

    public OffsetTime with(TimeAdjuster adjuster) {
        LocalTime newTime = this.time.with(adjuster);
        return newTime == this.time ? this : new OffsetTime(newTime, this.offset);
    }

    public OffsetTime withHourOfDay(int hourOfDay) {
        LocalTime newTime = this.time.withHourOfDay(hourOfDay);
        return newTime == this.time ? this : new OffsetTime(newTime, this.offset);
    }

    public OffsetTime withMinuteOfHour(int minuteOfHour) {
        LocalTime newTime = this.time.withMinuteOfHour(minuteOfHour);
        return newTime == this.time ? this : new OffsetTime(newTime, this.offset);
    }

    public OffsetTime withSecondOfMinute(int secondOfMinute) {
        LocalTime newTime = this.time.withSecondOfMinute(secondOfMinute);
        return newTime == this.time ? this : new OffsetTime(newTime, this.offset);
    }

    public OffsetTime withNanoOfSecond(int nanoOfSecond) {
        LocalTime newTime = this.time.withNanoOfSecond(nanoOfSecond);
        return newTime == this.time ? this : new OffsetTime(newTime, this.offset);
    }

    public OffsetTime plus(PeriodProvider periodProvider) {
        LocalTime newTime = this.time.plus(periodProvider);
        return newTime == this.time ? this : new OffsetTime(newTime, this.offset);
    }

    public OffsetTime plusHours(int hours) {
        LocalTime newTime = this.time.plusHours(hours);
        return newTime == this.time ? this : new OffsetTime(newTime, this.offset);
    }

    public OffsetTime plusMinutes(int minutes) {
        LocalTime newTime = this.time.plusMinutes(minutes);
        return newTime == this.time ? this : new OffsetTime(newTime, this.offset);
    }

    public OffsetTime plusSeconds(int seconds) {
        LocalTime newTime = this.time.plusSeconds(seconds);
        return newTime == this.time ? this : new OffsetTime(newTime, this.offset);
    }

    public OffsetTime plusNanos(int nanos) {
        LocalTime newTime = this.time.plusNanos(nanos);
        return newTime == this.time ? this : new OffsetTime(newTime, this.offset);
    }

    public OffsetTime minus(PeriodProvider periodProvider) {
        LocalTime newTime = this.time.minus(periodProvider);
        return newTime == this.time ? this : new OffsetTime(newTime, this.offset);
    }

    public OffsetTime minusHours(int hours) {
        LocalTime newTime = this.time.minusHours(hours);
        return newTime == this.time ? this : new OffsetTime(newTime, this.offset);
    }

    public OffsetTime minusMinutes(int minutes) {
        LocalTime newTime = this.time.minusMinutes(minutes);
        return newTime == this.time ? this : new OffsetTime(newTime, this.offset);
    }

    public OffsetTime minusSeconds(int seconds) {
        LocalTime newTime = this.time.minusSeconds(seconds);
        return newTime == this.time ? this : new OffsetTime(newTime, this.offset);
    }

    public OffsetTime minusNanos(int nanos) {
        LocalTime newTime = this.time.minusNanos(nanos);
        return newTime == this.time ? this : new OffsetTime(newTime, this.offset);
    }

    public boolean matches(CalendricalMatcher matcher) {
        return matcher.matchesCalendrical(this);
    }

    @Override
    public boolean matchesCalendrical(Calendrical calendrical) {
        return this.equals(calendrical.get(OffsetTime.rule()));
    }

    @Override
    public LocalTime adjustTime(LocalTime time) {
        return this.time.adjustTime(time);
    }

    @Override
    public LocalTime toLocalTime() {
        return this.time;
    }

    @Override
    public int compareTo(OffsetTime other) {
        LocalTime otherUTC;
        if (this.offset.equals(other.offset)) {
            return this.time.compareTo(other.time);
        }
        LocalTime thisUTC = this.time.plusSeconds(-this.offset.getAmountSeconds());
        int compare = thisUTC.compareTo(otherUTC = other.time.plusSeconds(-other.offset.getAmountSeconds()));
        if (compare == 0) {
            compare = this.time.compareTo(other.time);
        }
        return compare;
    }

    public boolean isAfter(OffsetTime other) {
        return this.compareTo(other) > 0;
    }

    public boolean isBefore(OffsetTime other) {
        return this.compareTo(other) < 0;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof OffsetTime) {
            OffsetTime zonedTime = (OffsetTime)other;
            return this.time.equals(zonedTime.time) && this.offset.equals(zonedTime.offset);
        }
        return false;
    }

    public int hashCode() {
        return this.time.hashCode() ^ this.offset.hashCode();
    }

    public String toString() {
        return this.time.toString() + this.offset.toString();
    }

    public static CalendricalRule<OffsetTime> rule() {
        return Rule.INSTANCE;
    }

    static final class Rule
    extends CalendricalRule<OffsetTime>
    implements Serializable {
        private static final CalendricalRule<OffsetTime> INSTANCE = new Rule();
        private static final long serialVersionUID = 1L;

        private Rule() {
            super(OffsetTime.class, ISOChronology.INSTANCE, "OffsetTime", ISOChronology.periodNanos(), ISOChronology.periodDays());
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        protected OffsetTime derive(Calendrical calendrical) {
            OffsetDateTime odt = calendrical.get(OffsetDateTime.rule());
            return odt != null ? odt.toOffsetTime() : null;
        }
    }
}

