/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar;

import java.io.Serializable;
import javax.time.CalendricalException;
import javax.time.MathUtils;
import javax.time.calendar.Calendrical;
import javax.time.calendar.CalendricalMatcher;
import javax.time.calendar.CalendricalRule;
import javax.time.calendar.DateAdjuster;
import javax.time.calendar.DateResolver;
import javax.time.calendar.DateResolvers;
import javax.time.calendar.DateTimeFieldRule;
import javax.time.calendar.ISOChronology;
import javax.time.calendar.InvalidCalendarFieldException;
import javax.time.calendar.LocalDate;
import javax.time.calendar.MonthDay;
import javax.time.calendar.MonthOfYear;
import javax.time.calendar.YearMonth;
import javax.time.period.Period;
import javax.time.period.PeriodProvider;

public final class Year
implements Calendrical,
Comparable<Year>,
Serializable,
DateAdjuster,
CalendricalMatcher {
    public static final int MIN_YEAR = -2147483646;
    public static final int MAX_YEAR = Integer.MAX_VALUE;
    private static final long serialVersionUID = 2751581L;
    private final int year;

    public static DateTimeFieldRule<Integer> rule() {
        return ISOChronology.yearRule();
    }

    public static Year of(int isoYear) {
        Year.rule().checkValue(isoYear);
        return new Year(isoYear);
    }

    public static Year from(Calendrical calendrical) {
        return Year.of(Year.rule().getInt(calendrical));
    }

    private Year(int year) {
        this.year = year;
    }

    public int getValue() {
        return this.year;
    }

    @Override
    public <T> T get(CalendricalRule<T> rule) {
        return Year.rule().deriveValueFor(rule, this.year, this);
    }

    public boolean isLeap() {
        return ISOChronology.isLeapYear(this.year);
    }

    public Year next() {
        if (this.year == Integer.MAX_VALUE) {
            throw new CalendricalException("Year is already at the maximum value");
        }
        return Year.of(this.year + 1);
    }

    public Year nextLeap() {
        Year temp = this.next();
        while (!temp.isLeap()) {
            temp = temp.next();
        }
        return temp;
    }

    public Year previous() {
        if (this.year == -2147483646) {
            throw new CalendricalException("Year is already at the minimum value");
        }
        return Year.of(this.year - 1);
    }

    public Year previousLeap() {
        Year temp = this.previous();
        while (!temp.isLeap()) {
            temp = temp.previous();
        }
        return temp;
    }

    public Year plus(PeriodProvider periodProvider) {
        Period period = Period.from(periodProvider);
        return this.plusYears(period.getYears());
    }

    public Year plusYears(int years) {
        if (years == 0) {
            return this;
        }
        int result = this.year + years;
        if ((this.year ^ result) < 0 && (this.year ^ years) >= 0 || !Year.rule().isValidValue(result)) {
            throw new CalendricalException("Addition exceeds the supported year range: " + this.year + " + " + years);
        }
        return Year.of(result);
    }

    public Year minus(PeriodProvider periodProvider) {
        Period period = Period.from(periodProvider);
        return this.minusYears(period.getYears());
    }

    public Year minusYears(int years) {
        if (years == 0) {
            return this;
        }
        int result = this.year - years;
        if ((this.year ^ result) < 0 && (this.year ^ years) < 0 || !Year.rule().isValidValue(result)) {
            throw new CalendricalException("Subtraction exceeds the supported year range: " + this.year + " + " + years);
        }
        return Year.of(result);
    }

    @Override
    public boolean matchesCalendrical(Calendrical calendrical) {
        Integer calValue = calendrical.get(Year.rule());
        return calValue != null && calValue.intValue() == this.getValue();
    }

    @Override
    public LocalDate adjustDate(LocalDate date) {
        return this.adjustDate(date, DateResolvers.previousValid());
    }

    public LocalDate adjustDate(LocalDate date, DateResolver resolver) {
        return date.withYear(this.year, resolver);
    }

    public int lengthInDays() {
        return this.isLeap() ? 366 : 365;
    }

    public boolean isValidMonthDay(MonthDay monthDay) {
        return monthDay != null && monthDay.isValidYear(this.year);
    }

    public YearMonth atMonth(MonthOfYear monthOfYear) {
        return YearMonth.of(this.year, monthOfYear);
    }

    public YearMonth atMonth(int monthOfYear) {
        return YearMonth.of(this.year, monthOfYear);
    }

    public LocalDate atMonthDay(MonthDay monthDay) {
        return LocalDate.of(this.year, monthDay.getMonthOfYear(), monthDay.getDayOfMonth());
    }

    public LocalDate atDay(int dayOfYear) {
        ISOChronology.dayOfYearRule().checkValue(dayOfYear);
        if (dayOfYear == 366 && !this.isLeap()) {
            throw new InvalidCalendarFieldException("Day of year 366 is invalid for year " + this.year, ISOChronology.dayOfYearRule());
        }
        return LocalDate.of(this.year, 1, 1).plusDays(dayOfYear - 1);
    }

    @Override
    public int compareTo(Year other) {
        return MathUtils.safeCompare(this.year, other.year);
    }

    public boolean isAfter(Year other) {
        return this.year > other.year;
    }

    public boolean isBefore(Year other) {
        return this.year < other.year;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Year) {
            return this.year == ((Year)other).year;
        }
        return false;
    }

    public int hashCode() {
        return this.year;
    }

    public String toString() {
        return "Year=" + Integer.toString(this.year);
    }
}

