/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar;

import javax.time.CalendricalException;
import javax.time.Instant;
import javax.time.calendar.LocalDateTime;
import javax.time.calendar.OffsetDateTime;
import javax.time.calendar.TimeZone;
import javax.time.calendar.ZoneResolver;
import javax.time.calendar.zone.ZoneOffsetTransition;
import javax.time.calendar.zone.ZoneRules;

public final class ZoneResolvers {
    private ZoneResolvers() {
    }

    public static ZoneResolver strict() {
        return Strict.INSTANCE;
    }

    public static ZoneResolver preTransition() {
        return PreTransition.INSTANCE;
    }

    public static ZoneResolver postTransition() {
        return PostTransition.INSTANCE;
    }

    public static ZoneResolver postGapPreOverlap() {
        return PostGapPreOverlap.INSTANCE;
    }

    public static ZoneResolver retainOffset() {
        return RetainOffset.INSTANCE;
    }

    public static ZoneResolver pushForward() {
        return PushForward.INSTANCE;
    }

    public static ZoneResolver combination(ZoneResolver gapResolver, ZoneResolver overlapResolver) {
        gapResolver = gapResolver == null ? ZoneResolvers.strict() : gapResolver;
        ZoneResolver zoneResolver = overlapResolver = overlapResolver == null ? ZoneResolvers.strict() : overlapResolver;
        if (gapResolver == overlapResolver) {
            return gapResolver;
        }
        return new Combination(gapResolver, overlapResolver);
    }

    private static class Combination
    extends ZoneResolver {
        private final ZoneResolver gapResolver;
        private final ZoneResolver overlapResolver;

        public Combination(ZoneResolver gapResolver, ZoneResolver overlapResolver) {
            this.gapResolver = gapResolver;
            this.overlapResolver = overlapResolver;
        }

        @Override
        protected OffsetDateTime handleGap(TimeZone zone, ZoneRules rules, ZoneOffsetTransition discontinuity, LocalDateTime newDateTime, OffsetDateTime oldDateTime) {
            return this.gapResolver.handleGap(zone, rules, discontinuity, newDateTime, oldDateTime);
        }

        @Override
        protected OffsetDateTime handleOverlap(TimeZone zone, ZoneRules rules, ZoneOffsetTransition discontinuity, LocalDateTime newDateTime, OffsetDateTime oldDateTime) {
            return this.overlapResolver.handleOverlap(zone, rules, discontinuity, newDateTime, oldDateTime);
        }
    }

    private static class PushForward
    extends ZoneResolver {
        private static final ZoneResolver INSTANCE = new PushForward();

        private PushForward() {
        }

        @Override
        protected OffsetDateTime handleGap(TimeZone zone, ZoneRules rules, ZoneOffsetTransition discontinuity, LocalDateTime newDateTime, OffsetDateTime oldDateTime) {
            LocalDateTime result = newDateTime.plus(discontinuity.getTransitionSize());
            return OffsetDateTime.from(result, discontinuity.getOffsetAfter());
        }

        @Override
        protected OffsetDateTime handleOverlap(TimeZone zone, ZoneRules rules, ZoneOffsetTransition discontinuity, LocalDateTime newDateTime, OffsetDateTime oldDateTime) {
            return OffsetDateTime.from(newDateTime, discontinuity.getOffsetAfter());
        }
    }

    private static class RetainOffset
    extends ZoneResolver {
        private static final ZoneResolver INSTANCE = new RetainOffset();

        private RetainOffset() {
        }

        @Override
        protected OffsetDateTime handleGap(TimeZone zone, ZoneRules rules, ZoneOffsetTransition discontinuity, LocalDateTime newDateTime, OffsetDateTime oldDateTime) {
            return discontinuity.getDateTimeAfter();
        }

        @Override
        protected OffsetDateTime handleOverlap(TimeZone zone, ZoneRules rules, ZoneOffsetTransition discontinuity, LocalDateTime newDateTime, OffsetDateTime oldDateTime) {
            if (oldDateTime != null && discontinuity.isValidOffset(oldDateTime.getOffset())) {
                return OffsetDateTime.from(newDateTime, oldDateTime.getOffset());
            }
            return OffsetDateTime.from(newDateTime, discontinuity.getOffsetAfter());
        }
    }

    private static class PostGapPreOverlap
    extends ZoneResolver {
        private static final ZoneResolver INSTANCE = new PostGapPreOverlap();

        private PostGapPreOverlap() {
        }

        @Override
        protected OffsetDateTime handleGap(TimeZone zone, ZoneRules rules, ZoneOffsetTransition discontinuity, LocalDateTime newDateTime, OffsetDateTime oldDateTime) {
            return discontinuity.getDateTimeAfter();
        }

        @Override
        protected OffsetDateTime handleOverlap(TimeZone zone, ZoneRules rules, ZoneOffsetTransition discontinuity, LocalDateTime newDateTime, OffsetDateTime oldDateTime) {
            return OffsetDateTime.from(newDateTime, discontinuity.getOffsetBefore());
        }
    }

    private static class PostTransition
    extends ZoneResolver {
        private static final ZoneResolver INSTANCE = new PostTransition();

        private PostTransition() {
        }

        @Override
        protected OffsetDateTime handleGap(TimeZone zone, ZoneRules rules, ZoneOffsetTransition discontinuity, LocalDateTime newDateTime, OffsetDateTime oldDateTime) {
            return discontinuity.getDateTimeAfter();
        }

        @Override
        protected OffsetDateTime handleOverlap(TimeZone zone, ZoneRules rules, ZoneOffsetTransition discontinuity, LocalDateTime newDateTime, OffsetDateTime oldDateTime) {
            return OffsetDateTime.from(newDateTime, discontinuity.getOffsetAfter());
        }
    }

    private static class PreTransition
    extends ZoneResolver {
        private static final ZoneResolver INSTANCE = new PreTransition();

        private PreTransition() {
        }

        @Override
        protected OffsetDateTime handleGap(TimeZone zone, ZoneRules rules, ZoneOffsetTransition discontinuity, LocalDateTime newDateTime, OffsetDateTime oldDateTime) {
            Instant instantBefore = discontinuity.getInstant().minusNanos(1L);
            return OffsetDateTime.fromInstant(instantBefore, discontinuity.getOffsetBefore());
        }

        @Override
        protected OffsetDateTime handleOverlap(TimeZone zone, ZoneRules rules, ZoneOffsetTransition discontinuity, LocalDateTime newDateTime, OffsetDateTime oldDateTime) {
            return OffsetDateTime.from(newDateTime, discontinuity.getOffsetBefore());
        }
    }

    private static class Strict
    extends ZoneResolver {
        private static final Strict INSTANCE = new Strict();

        private Strict() {
        }

        @Override
        protected OffsetDateTime handleGap(TimeZone zone, ZoneRules rules, ZoneOffsetTransition discontinuity, LocalDateTime newDateTime, OffsetDateTime oldDateTime) {
            throw new CalendricalException("Local time " + newDateTime + " does not exist in time zone " + zone + " due to a gap in the local time-line");
        }

        @Override
        protected OffsetDateTime handleOverlap(TimeZone zone, ZoneRules rules, ZoneOffsetTransition discontinuity, LocalDateTime newDateTime, OffsetDateTime oldDateTime) {
            throw new CalendricalException("Local time " + newDateTime + " has two matching offsets, " + discontinuity.getOffsetBefore() + " and " + discontinuity.getOffsetAfter() + ", in time zone " + zone);
        }
    }
}

