/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar;

import java.io.Serializable;
import javax.time.Duration;
import javax.time.Instant;
import javax.time.InstantProvider;
import javax.time.calendar.CalendarConversionException;
import javax.time.calendar.Calendrical;
import javax.time.calendar.CalendricalMatcher;
import javax.time.calendar.CalendricalRule;
import javax.time.calendar.DateAdjuster;
import javax.time.calendar.DateProvider;
import javax.time.calendar.DateTimeProvider;
import javax.time.calendar.DayOfWeek;
import javax.time.calendar.ISOChronology;
import javax.time.calendar.LocalDate;
import javax.time.calendar.LocalDateTime;
import javax.time.calendar.LocalTime;
import javax.time.calendar.MonthOfYear;
import javax.time.calendar.OffsetDate;
import javax.time.calendar.OffsetDateTime;
import javax.time.calendar.OffsetTime;
import javax.time.calendar.TimeAdjuster;
import javax.time.calendar.TimeProvider;
import javax.time.calendar.TimeZone;
import javax.time.calendar.Year;
import javax.time.calendar.ZoneOffset;
import javax.time.calendar.ZoneResolver;
import javax.time.calendar.ZoneResolvers;
import javax.time.calendar.format.DateTimeFormatters;
import javax.time.calendar.zone.ZoneRules;
import javax.time.period.PeriodFields;
import javax.time.period.PeriodProvider;

public final class ZonedDateTime
implements InstantProvider,
DateTimeProvider,
Calendrical,
CalendricalMatcher,
Comparable<ZonedDateTime>,
Serializable {
    private static final long serialVersionUID = -456761901L;
    private final OffsetDateTime dateTime;
    private final TimeZone zone;

    public static ZonedDateTime from(DateProvider dateProvider, TimeProvider timeProvider, TimeZone zone) {
        return ZonedDateTime.from(dateProvider, timeProvider, zone, ZoneResolvers.strict());
    }

    public static ZonedDateTime from(DateProvider dateProvider, TimeProvider timeProvider, TimeZone zone, ZoneResolver resolver) {
        LocalDateTime dt = LocalDateTime.from(dateProvider, timeProvider);
        return ZonedDateTime.resolve(dt, null, zone, resolver);
    }

    public static ZonedDateTime from(DateTimeProvider dateTimeProvider, TimeZone zone) {
        return ZonedDateTime.from(dateTimeProvider, zone, ZoneResolvers.strict());
    }

    public static ZonedDateTime from(DateTimeProvider dateTimeProvider, TimeZone zone, ZoneResolver resolver) {
        LocalDateTime dt = LocalDateTime.from(dateTimeProvider);
        return ZonedDateTime.resolve(dt, null, zone, resolver);
    }

    public static ZonedDateTime of(OffsetDateTime dateTime, TimeZone zone) {
        ISOChronology.checkNotNull(dateTime, "OffsetDateTime must not be null");
        ISOChronology.checkNotNull(zone, "TimeZone must not be null");
        ZoneOffset inputOffset = dateTime.getOffset();
        ZoneRules rules = zone.getRules();
        ZoneRules.OffsetInfo info = rules.getOffsetInfo(dateTime.toLocalDateTime());
        if (!info.isValidOffset(inputOffset)) {
            if (info.isTransition() && info.getTransition().isGap()) {
                throw new CalendarConversionException("The local time " + dateTime.toLocalDateTime() + " does not exist in time zone " + zone + " due to a daylight savings gap");
            }
            throw new CalendarConversionException("The offset in the date-time " + dateTime + " is invalid for time zone " + zone);
        }
        return new ZonedDateTime(dateTime, zone);
    }

    public static ZonedDateTime fromInstant(InstantProvider instantProvider, TimeZone zone) {
        Instant instant = Instant.from(instantProvider);
        ISOChronology.checkNotNull(zone, "TimeZone must not be null");
        ZoneRules rules = zone.getRules();
        OffsetDateTime offsetDT = OffsetDateTime.fromInstant(instant, rules.getOffset(instant));
        return new ZonedDateTime(offsetDT, zone);
    }

    public static ZonedDateTime fromInstant(OffsetDateTime dateTime, TimeZone zone) {
        ISOChronology.checkNotNull(dateTime, "OffsetDateTime must not be null");
        ISOChronology.checkNotNull(zone, "TimeZone must not be null");
        ZoneRules rules = zone.getRules();
        if (!rules.isValidDateTime(dateTime)) {
            ZoneOffset offsetForInstant = rules.getOffset(dateTime);
            dateTime = dateTime.withOffsetSameInstant(offsetForInstant);
        }
        return new ZonedDateTime(dateTime, zone);
    }

    public static ZonedDateTime parse(String text) {
        return DateTimeFormatters.isoZonedDateTime().parse(text, ZonedDateTime.rule());
    }

    private static ZonedDateTime resolve(LocalDateTime dateTime, ZonedDateTime oldDateTime, TimeZone zone, ZoneResolver resolver) {
        ISOChronology.checkNotNull(dateTime, "LocalDateTime must not be null");
        ISOChronology.checkNotNull(zone, "TimeZone must not be null");
        ISOChronology.checkNotNull(resolver, "ZoneResolver must not be null");
        OffsetDateTime offsetDT = resolver.resolve(zone, dateTime, oldDateTime);
        return new ZonedDateTime(offsetDT, zone);
    }

    private ZonedDateTime(OffsetDateTime dateTime, TimeZone zone) {
        this.dateTime = dateTime;
        this.zone = zone;
    }

    public ISOChronology getChronology() {
        return ISOChronology.INSTANCE;
    }

    @Override
    public <T> T get(CalendricalRule<T> rule) {
        return ZonedDateTime.rule().deriveValueFor(rule, this, this);
    }

    public ZonedDateTime withDateTime(DateTimeProvider dateTimeProvider) {
        LocalDateTime localDateTime = LocalDateTime.from(dateTimeProvider);
        return localDateTime.equals(this.dateTime.toLocalDateTime()) ? this : ZonedDateTime.resolve(localDateTime, this, this.zone, ZoneResolvers.retainOffset());
    }

    public ZoneOffset getOffset() {
        return this.dateTime.getOffset();
    }

    public ZonedDateTime withEarlierOffsetAtOverlap() {
        ZoneOffset offset;
        ZoneRules.OffsetInfo info = this.getApplicableRules().getOffsetInfo(this.toLocalDateTime());
        if (info.isTransition() && !(offset = info.getTransition().getOffsetBefore()).equals(this.getOffset())) {
            OffsetDateTime newDT = this.dateTime.withOffsetSameLocal(offset);
            return new ZonedDateTime(newDT, this.zone);
        }
        return this;
    }

    public ZonedDateTime withLaterOffsetAtOverlap() {
        ZoneOffset offset;
        ZoneRules.OffsetInfo info = this.getApplicableRules().getOffsetInfo(this.toLocalDateTime());
        if (info.isTransition() && !(offset = info.getTransition().getOffsetAfter()).equals(this.getOffset())) {
            OffsetDateTime newDT = this.dateTime.withOffsetSameLocal(offset);
            return new ZonedDateTime(newDT, this.zone);
        }
        return this;
    }

    public TimeZone getZone() {
        return this.zone;
    }

    public ZonedDateTime withZoneSameLocal(TimeZone zone) {
        return this.withZoneSameLocal(zone, ZoneResolvers.retainOffset());
    }

    public ZonedDateTime withZoneSameLocal(TimeZone zone, ZoneResolver resolver) {
        ISOChronology.checkNotNull(zone, "TimeZone must not be null");
        ISOChronology.checkNotNull(resolver, "ZoneResolver must not be null");
        return zone == this.zone ? this : ZonedDateTime.resolve(this.dateTime.toLocalDateTime(), this, zone, resolver);
    }

    public ZonedDateTime withZoneSameInstant(TimeZone zone) {
        return zone == this.zone ? this : ZonedDateTime.fromInstant(this.dateTime, zone);
    }

    public TimeZone getApplicableZone() {
        if (this.zone.isFloatingVersion()) {
            return this.zone.withLatestVersionValidFor(this.dateTime);
        }
        return this.zone;
    }

    public ZoneRules getApplicableRules() {
        return this.zone.getRulesValidFor(this.dateTime);
    }

    public int getYear() {
        return this.dateTime.getYear();
    }

    public MonthOfYear getMonthOfYear() {
        return this.dateTime.getMonthOfYear();
    }

    public int getDayOfMonth() {
        return this.dateTime.getDayOfMonth();
    }

    public int getDayOfYear() {
        return this.dateTime.getDayOfYear();
    }

    public DayOfWeek getDayOfWeek() {
        return this.dateTime.getDayOfWeek();
    }

    public int getHourOfDay() {
        return this.dateTime.getHourOfDay();
    }

    public int getMinuteOfHour() {
        return this.dateTime.getMinuteOfHour();
    }

    public int getSecondOfMinute() {
        return this.dateTime.getSecondOfMinute();
    }

    public int getNanoOfSecond() {
        return this.dateTime.getNanoOfSecond();
    }

    public ZonedDateTime with(DateAdjuster adjuster) {
        return this.with(adjuster, ZoneResolvers.retainOffset());
    }

    public ZonedDateTime with(DateAdjuster adjuster, ZoneResolver resolver) {
        ISOChronology.checkNotNull(adjuster, "DateAdjuster must not be null");
        ISOChronology.checkNotNull(resolver, "ZoneResolver must not be null");
        LocalDateTime newDT = this.dateTime.toLocalDateTime().with(adjuster);
        return newDT == this.dateTime.toLocalDateTime() ? this : ZonedDateTime.resolve(newDT, this, this.zone, resolver);
    }

    public ZonedDateTime with(TimeAdjuster adjuster) {
        return this.with(adjuster, ZoneResolvers.retainOffset());
    }

    public ZonedDateTime with(TimeAdjuster adjuster, ZoneResolver resolver) {
        ISOChronology.checkNotNull(adjuster, "TimeAdjuster must not be null");
        ISOChronology.checkNotNull(resolver, "ZoneResolver must not be null");
        LocalDateTime newDT = this.dateTime.toLocalDateTime().with(adjuster);
        return newDT == this.dateTime.toLocalDateTime() ? this : ZonedDateTime.resolve(newDT, this, this.zone, resolver);
    }

    public ZonedDateTime withYear(int year) {
        LocalDateTime newDT = this.dateTime.toLocalDateTime().withYear(year);
        return newDT == this.dateTime.toLocalDateTime() ? this : ZonedDateTime.resolve(newDT, this, this.zone, ZoneResolvers.retainOffset());
    }

    public ZonedDateTime withMonthOfYear(int monthOfYear) {
        LocalDateTime newDT = this.dateTime.toLocalDateTime().withMonthOfYear(monthOfYear);
        return newDT == this.dateTime.toLocalDateTime() ? this : ZonedDateTime.resolve(newDT, this, this.zone, ZoneResolvers.retainOffset());
    }

    public ZonedDateTime withDayOfMonth(int dayOfMonth) {
        LocalDateTime newDT = this.dateTime.toLocalDateTime().withDayOfMonth(dayOfMonth);
        return newDT == this.dateTime.toLocalDateTime() ? this : ZonedDateTime.resolve(newDT, this, this.zone, ZoneResolvers.retainOffset());
    }

    public ZonedDateTime withDayOfYear(int dayOfYear) {
        LocalDateTime newDT = this.dateTime.toLocalDateTime().withDayOfYear(dayOfYear);
        return newDT == this.dateTime.toLocalDateTime() ? this : ZonedDateTime.resolve(newDT, this, this.zone, ZoneResolvers.retainOffset());
    }

    public ZonedDateTime withDate(int year, int monthOfYear, int dayOfMonth) {
        LocalDateTime newDT = this.dateTime.toLocalDateTime().withDate(year, monthOfYear, dayOfMonth);
        return newDT == this.dateTime.toLocalDateTime() ? this : ZonedDateTime.resolve(newDT, this, this.zone, ZoneResolvers.retainOffset());
    }

    public ZonedDateTime withHourOfDay(int hourOfDay) {
        LocalDateTime newDT = this.dateTime.toLocalDateTime().withHourOfDay(hourOfDay);
        return newDT == this.dateTime.toLocalDateTime() ? this : ZonedDateTime.resolve(newDT, this, this.zone, ZoneResolvers.retainOffset());
    }

    public ZonedDateTime withMinuteOfHour(int minuteOfHour) {
        LocalDateTime newDT = this.dateTime.toLocalDateTime().withMinuteOfHour(minuteOfHour);
        return newDT == this.dateTime.toLocalDateTime() ? this : ZonedDateTime.resolve(newDT, this, this.zone, ZoneResolvers.retainOffset());
    }

    public ZonedDateTime withSecondOfMinute(int secondOfMinute) {
        LocalDateTime newDT = this.dateTime.toLocalDateTime().withSecondOfMinute(secondOfMinute);
        return newDT == this.dateTime.toLocalDateTime() ? this : ZonedDateTime.resolve(newDT, this, this.zone, ZoneResolvers.retainOffset());
    }

    public ZonedDateTime withNanoOfSecond(int nanoOfSecond) {
        LocalDateTime newDT = this.dateTime.toLocalDateTime().withNanoOfSecond(nanoOfSecond);
        return newDT == this.dateTime.toLocalDateTime() ? this : ZonedDateTime.resolve(newDT, this, this.zone, ZoneResolvers.retainOffset());
    }

    public ZonedDateTime withTime(int hourOfDay, int minuteOfHour) {
        LocalDateTime newDT = this.dateTime.toLocalDateTime().withTime(hourOfDay, minuteOfHour);
        return newDT == this.dateTime.toLocalDateTime() ? this : ZonedDateTime.resolve(newDT, this, this.zone, ZoneResolvers.retainOffset());
    }

    public ZonedDateTime withTime(int hourOfDay, int minuteOfHour, int secondOfMinute) {
        LocalDateTime newDT = this.dateTime.toLocalDateTime().withTime(hourOfDay, minuteOfHour, secondOfMinute);
        return newDT == this.dateTime.toLocalDateTime() ? this : ZonedDateTime.resolve(newDT, this, this.zone, ZoneResolvers.retainOffset());
    }

    public ZonedDateTime withTime(int hourOfDay, int minuteOfHour, int secondOfMinute, int nanoOfSecond) {
        LocalDateTime newDT = this.dateTime.toLocalDateTime().withTime(hourOfDay, minuteOfHour, secondOfMinute, nanoOfSecond);
        return newDT == this.dateTime.toLocalDateTime() ? this : ZonedDateTime.resolve(newDT, this, this.zone, ZoneResolvers.retainOffset());
    }

    public ZonedDateTime plus(PeriodProvider periodProvider) {
        return this.plus(periodProvider, ZoneResolvers.retainOffset());
    }

    public ZonedDateTime plus(PeriodProvider periodProvider, ZoneResolver resolver) {
        ISOChronology.checkNotNull(periodProvider, "PeriodProvider must not be null");
        ISOChronology.checkNotNull(resolver, "ZoneResolver must not be null");
        LocalDateTime newDT = this.dateTime.toLocalDateTime().plus(periodProvider);
        return newDT == this.dateTime.toLocalDateTime() ? this : ZonedDateTime.resolve(newDT, this, this.zone, resolver);
    }

    public ZonedDateTime plusYears(int years) {
        LocalDateTime newDT = this.dateTime.toLocalDateTime().plusYears(years);
        return newDT == this.dateTime.toLocalDateTime() ? this : ZonedDateTime.resolve(newDT, this, this.zone, ZoneResolvers.retainOffset());
    }

    public ZonedDateTime plusMonths(int months) {
        LocalDateTime newDT = this.dateTime.toLocalDateTime().plusMonths(months);
        return newDT == this.dateTime.toLocalDateTime() ? this : ZonedDateTime.resolve(newDT, this, this.zone, ZoneResolvers.retainOffset());
    }

    public ZonedDateTime plusWeeks(int weeks) {
        LocalDateTime newDT = this.dateTime.toLocalDateTime().plusWeeks(weeks);
        return newDT == this.dateTime.toLocalDateTime() ? this : ZonedDateTime.resolve(newDT, this, this.zone, ZoneResolvers.retainOffset());
    }

    public ZonedDateTime plusDays(int days) {
        LocalDateTime newDT = this.dateTime.toLocalDateTime().plusDays(days);
        return newDT == this.dateTime.toLocalDateTime() ? this : ZonedDateTime.resolve(newDT, this, this.zone, ZoneResolvers.retainOffset());
    }

    public ZonedDateTime plusHours(int hours) {
        LocalDateTime newDT = this.dateTime.toLocalDateTime().plusHours(hours);
        return newDT == this.dateTime.toLocalDateTime() ? this : ZonedDateTime.resolve(newDT, this, this.zone, ZoneResolvers.retainOffset());
    }

    public ZonedDateTime plusMinutes(int minutes) {
        LocalDateTime newDT = this.dateTime.toLocalDateTime().plusMinutes(minutes);
        return newDT == this.dateTime.toLocalDateTime() ? this : ZonedDateTime.resolve(newDT, this, this.zone, ZoneResolvers.retainOffset());
    }

    public ZonedDateTime plusSeconds(int seconds) {
        LocalDateTime newDT = this.dateTime.toLocalDateTime().plusSeconds(seconds);
        return newDT == this.dateTime.toLocalDateTime() ? this : ZonedDateTime.resolve(newDT, this, this.zone, ZoneResolvers.retainOffset());
    }

    public ZonedDateTime plusNanos(int nanos) {
        LocalDateTime newDT = this.dateTime.toLocalDateTime().plusNanos(nanos);
        return newDT == this.dateTime.toLocalDateTime() ? this : ZonedDateTime.resolve(newDT, this, this.zone, ZoneResolvers.retainOffset());
    }

    public ZonedDateTime plusDuration(PeriodProvider periodProvider) {
        PeriodFields period = PeriodFields.from(periodProvider);
        Duration duration = period.toDuration();
        return duration.isZero() ? this : ZonedDateTime.fromInstant(this.toInstant().plus(duration), this.zone);
    }

    public ZonedDateTime plusDuration(int hours, int minutes, int seconds, long nanos) {
        if (((long)(hours | minutes | seconds) | nanos) == 0L) {
            return this;
        }
        Instant instant = this.toInstant().plusSeconds((long)hours * 3600L + (long)minutes * 60L + (long)seconds).plusNanos(nanos);
        return ZonedDateTime.fromInstant(instant, this.zone);
    }

    public ZonedDateTime minus(PeriodProvider periodProvider) {
        return this.minus(periodProvider, ZoneResolvers.retainOffset());
    }

    public ZonedDateTime minus(PeriodProvider periodProvider, ZoneResolver resolver) {
        ISOChronology.checkNotNull(periodProvider, "PeriodProvider must not be null");
        ISOChronology.checkNotNull(resolver, "ZoneResolver must not be null");
        LocalDateTime newDT = this.dateTime.toLocalDateTime().minus(periodProvider);
        return newDT == this.dateTime.toLocalDateTime() ? this : ZonedDateTime.resolve(newDT, this, this.zone, resolver);
    }

    public ZonedDateTime minusYears(int years) {
        LocalDateTime newDT = this.dateTime.toLocalDateTime().minusYears(years);
        return newDT == this.dateTime.toLocalDateTime() ? this : ZonedDateTime.resolve(newDT, this, this.zone, ZoneResolvers.retainOffset());
    }

    public ZonedDateTime minusMonths(int months) {
        LocalDateTime newDT = this.dateTime.toLocalDateTime().minusMonths(months);
        return newDT == this.dateTime.toLocalDateTime() ? this : ZonedDateTime.resolve(newDT, this, this.zone, ZoneResolvers.retainOffset());
    }

    public ZonedDateTime minusWeeks(int weeks) {
        LocalDateTime newDT = this.dateTime.toLocalDateTime().minusWeeks(weeks);
        return newDT == this.dateTime.toLocalDateTime() ? this : ZonedDateTime.resolve(newDT, this, this.zone, ZoneResolvers.retainOffset());
    }

    public ZonedDateTime minusDays(int days) {
        LocalDateTime newDT = this.dateTime.toLocalDateTime().minusDays(days);
        return newDT == this.dateTime.toLocalDateTime() ? this : ZonedDateTime.resolve(newDT, this, this.zone, ZoneResolvers.retainOffset());
    }

    public ZonedDateTime minusHours(int hours) {
        LocalDateTime newDT = this.dateTime.toLocalDateTime().minusHours(hours);
        return newDT == this.dateTime.toLocalDateTime() ? this : ZonedDateTime.resolve(newDT, this, this.zone, ZoneResolvers.retainOffset());
    }

    public ZonedDateTime minusMinutes(int minutes) {
        LocalDateTime newDT = this.dateTime.toLocalDateTime().minusMinutes(minutes);
        return newDT == this.dateTime.toLocalDateTime() ? this : ZonedDateTime.resolve(newDT, this, this.zone, ZoneResolvers.retainOffset());
    }

    public ZonedDateTime minusSeconds(int seconds) {
        LocalDateTime newDT = this.dateTime.toLocalDateTime().minusSeconds(seconds);
        return newDT == this.dateTime.toLocalDateTime() ? this : ZonedDateTime.resolve(newDT, this, this.zone, ZoneResolvers.retainOffset());
    }

    public ZonedDateTime minusNanos(int nanos) {
        LocalDateTime newDT = this.dateTime.toLocalDateTime().minusNanos(nanos);
        return newDT == this.dateTime.toLocalDateTime() ? this : ZonedDateTime.resolve(newDT, this, this.zone, ZoneResolvers.retainOffset());
    }

    public ZonedDateTime minusDuration(PeriodProvider periodProvider) {
        PeriodFields period = PeriodFields.from(periodProvider);
        Duration duration = period.toDuration();
        return duration.isZero() ? this : ZonedDateTime.fromInstant(this.toInstant().minus(duration), this.zone);
    }

    public ZonedDateTime minusDuration(int hours, int minutes, int seconds, long nanos) {
        if (((long)(hours | minutes | seconds) | nanos) == 0L) {
            return this;
        }
        Instant instant = this.toInstant().minusSeconds((long)hours * 3600L + (long)minutes * 60L + (long)seconds).minusNanos(nanos);
        return ZonedDateTime.fromInstant(instant, this.zone);
    }

    public boolean matches(CalendricalMatcher matcher) {
        return matcher.matchesCalendrical(this);
    }

    @Override
    public boolean matchesCalendrical(Calendrical calendrical) {
        return this.equals(calendrical.get(ZonedDateTime.rule()));
    }

    @Override
    public Instant toInstant() {
        return this.dateTime.toInstant();
    }

    @Override
    public LocalDate toLocalDate() {
        return this.dateTime.toLocalDate();
    }

    @Override
    public LocalTime toLocalTime() {
        return this.dateTime.toLocalTime();
    }

    @Override
    public LocalDateTime toLocalDateTime() {
        return this.dateTime.toLocalDateTime();
    }

    public OffsetDate toOffsetDate() {
        return this.dateTime.toOffsetDate();
    }

    public OffsetTime toOffsetTime() {
        return this.dateTime.toOffsetTime();
    }

    public OffsetDateTime toOffsetDateTime() {
        return this.dateTime;
    }

    public Year toYear() {
        return this.dateTime.toYear();
    }

    @Override
    public int compareTo(ZonedDateTime other) {
        int compare = this.dateTime.compareTo(other.dateTime);
        if (compare == 0) {
            compare = this.zone.getID().compareTo(other.zone.getID());
        }
        return compare;
    }

    public boolean isAfter(ZonedDateTime other) {
        return this.compareTo(other) > 0;
    }

    public boolean isBefore(ZonedDateTime other) {
        return this.compareTo(other) < 0;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof ZonedDateTime) {
            ZonedDateTime zonedDateTime = (ZonedDateTime)other;
            return this.dateTime.equals(zonedDateTime.dateTime) && this.zone.equals(zonedDateTime.zone);
        }
        return false;
    }

    public int hashCode() {
        return this.dateTime.hashCode() ^ this.zone.hashCode();
    }

    public String toString() {
        return this.dateTime.toString() + '[' + this.zone.toString() + ']';
    }

    public static CalendricalRule<ZonedDateTime> rule() {
        return Rule.INSTANCE;
    }

    static final class Rule
    extends CalendricalRule<ZonedDateTime>
    implements Serializable {
        private static final CalendricalRule<ZonedDateTime> INSTANCE = new Rule();
        private static final long serialVersionUID = 1L;

        private Rule() {
            super(ZonedDateTime.class, ISOChronology.INSTANCE, "ZonedDateTime", ISOChronology.periodNanos(), null);
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }
}

