/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar.format;

import java.io.IOException;
import javax.time.calendar.Calendrical;
import javax.time.calendar.format.DateTimeFormatSymbols;
import javax.time.calendar.format.DateTimeParseContext;
import javax.time.calendar.format.DateTimeParser;
import javax.time.calendar.format.DateTimePrinter;

final class CharLiteralPrinterParser
implements DateTimePrinter,
DateTimeParser {
    private final char literal;

    CharLiteralPrinterParser(char literal) {
        this.literal = literal;
    }

    @Override
    public void print(Calendrical calendrical, Appendable appendable, DateTimeFormatSymbols symbols) throws IOException {
        appendable.append(this.literal);
    }

    @Override
    public boolean isPrintDataAvailable(Calendrical calendrical) {
        return true;
    }

    @Override
    public int parse(DateTimeParseContext context, String parseText, int position) {
        int length = parseText.length();
        if (position == length) {
            return ~position;
        }
        char ch = parseText.charAt(position);
        if (ch != this.literal && (context.isCaseSensitive() || Character.toUpperCase(ch) != Character.toUpperCase(this.literal) && Character.toLowerCase(ch) != Character.toLowerCase(this.literal))) {
            return ~position;
        }
        return position + 1;
    }

    public String toString() {
        if (this.literal == '\'') {
            return "''";
        }
        return "'" + this.literal + "'";
    }
}

