/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar.format;

import java.text.DateFormatSymbols;
import java.util.Locale;
import javax.time.calendar.format.DateTimeFormatter;

public final class DateTimeFormatSymbols {
    private final Locale locale;
    private final char zeroChar = (char)48;
    private final char positiveSignChar = (char)43;
    private final char negativeSignChar = (char)45;
    private final char decimalPointChar = (char)46;

    public static Locale[] getAvailableLocales() {
        return Locale.getAvailableLocales();
    }

    public static DateTimeFormatSymbols getInstance() {
        return DateTimeFormatSymbols.getInstance(Locale.getDefault());
    }

    public static DateTimeFormatSymbols getInstance(Locale locale) {
        DateTimeFormatter.checkNotNull(locale, "Locale must not be null");
        DateFormatSymbols symbols = new DateFormatSymbols(locale);
        return new DateTimeFormatSymbols(locale, symbols);
    }

    private DateTimeFormatSymbols(Locale locale) {
        DateTimeFormatter.checkNotNull(locale, "Locale must not be null");
        this.locale = locale;
    }

    private DateTimeFormatSymbols(Locale locale, DateFormatSymbols oldSymbols) {
        this(locale);
        DateTimeFormatter.checkNotNull(oldSymbols, "Symbols to convert must not be null");
    }

    public Locale getLocale() {
        return this.locale;
    }

    public char getZeroChar() {
        return '0';
    }

    public char getDigitChar(int digit) {
        return (char)(digit + 48);
    }

    public int convertToDigit(char ch) {
        int val = ch - 48;
        return val >= 0 && val <= 9 ? val : -1;
    }

    public char getPositiveSignChar() {
        return '+';
    }

    public char getNegativeSignChar() {
        return '-';
    }

    public char getDecimalPointChar() {
        return '.';
    }

    String convertNumberToI18N(String numericText) {
        if (this.getZeroChar() == '0') {
            return numericText;
        }
        int diff = this.getZeroChar() - 48;
        char[] array = numericText.toCharArray();
        for (int i = 0; i < array.length; ++i) {
            array[i] = (char)(array[i] + diff);
        }
        return new String(array);
    }
}

