/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar.format;

import java.io.IOException;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Locale;
import javax.time.calendar.Calendrical;
import javax.time.calendar.CalendricalMerger;
import javax.time.calendar.CalendricalRule;
import javax.time.calendar.UnsupportedRuleException;
import javax.time.calendar.format.CalendricalParseException;
import javax.time.calendar.format.CalendricalPrintException;
import javax.time.calendar.format.CalendricalPrintFieldException;
import javax.time.calendar.format.CompositePrinterParser;
import javax.time.calendar.format.DateTimeFormatSymbols;
import javax.time.calendar.format.DateTimeParseContext;

public final class DateTimeFormatter {
    private final DateTimeFormatSymbols symbols;
    private final CompositePrinterParser printerParser;

    DateTimeFormatter(Locale locale, CompositePrinterParser printerParser) {
        this.symbols = DateTimeFormatSymbols.getInstance(locale);
        this.printerParser = printerParser;
    }

    private DateTimeFormatter(DateTimeFormatSymbols symbols, CompositePrinterParser printerParser) {
        this.symbols = symbols;
        this.printerParser = printerParser;
    }

    static void checkNotNull(Object object, String errorMessage) {
        if (object == null) {
            throw new NullPointerException(errorMessage);
        }
    }

    public Locale getLocale() {
        return this.symbols.getLocale();
    }

    public DateTimeFormatter withLocale(Locale locale) {
        DateTimeFormatter.checkNotNull(locale, "Locale must not be null");
        if (locale.equals(this.getLocale())) {
            return this;
        }
        DateTimeFormatSymbols newSymbols = DateTimeFormatSymbols.getInstance(locale);
        return new DateTimeFormatter(newSymbols, this.printerParser);
    }

    public boolean isPrintSupported() {
        return this.printerParser.isPrintSupported();
    }

    public String print(Calendrical calendrical) {
        StringBuilder buf = new StringBuilder(32);
        this.print(calendrical, buf);
        return buf.toString();
    }

    public void print(Calendrical calendrical, Appendable appendable) {
        DateTimeFormatter.checkNotNull(calendrical, "Calendrical must not be null");
        DateTimeFormatter.checkNotNull(appendable, "Appendable must not be null");
        try {
            this.printerParser.print(calendrical, appendable, this.symbols);
        }
        catch (UnsupportedRuleException ex) {
            throw new CalendricalPrintFieldException(ex);
        }
        catch (IOException ex) {
            throw new CalendricalPrintException(ex.getMessage(), ex);
        }
    }

    public boolean isParseSupported() {
        return this.printerParser.isParseSupported();
    }

    public <T> T parse(String text, CalendricalRule<T> rule) {
        DateTimeFormatter.checkNotNull(text, "Text must not be null");
        DateTimeFormatter.checkNotNull(rule, "CalendricalRule must not be null");
        CalendricalMerger merger = this.parse(text);
        T result = merger.merge().get(rule);
        if (result == null) {
            String str = text;
            if (str.length() > 64) {
                str = str.substring(0, 64) + "...";
            }
            throw new CalendricalParseException("Text could not be parsed into a " + rule.getName() + ": " + str, text, 0);
        }
        return result;
    }

    public CalendricalMerger parse(String text) {
        ParsePosition pos = new ParsePosition(0);
        DateTimeParseContext result = this.parse(text, pos);
        if (pos.getErrorIndex() >= 0 || pos.getIndex() < text.length()) {
            String str = text;
            if (str.length() > 64) {
                str = str.substring(0, 64) + "...";
            }
            if (pos.getErrorIndex() >= 0) {
                throw new CalendricalParseException("Text could not be parsed at index " + pos.getErrorIndex() + ": " + str, text, pos.getErrorIndex());
            }
            throw new CalendricalParseException("Unparsed text found at index " + pos.getIndex() + ": " + str, text, pos.getIndex());
        }
        return result.toCalendricalMerger();
    }

    public DateTimeParseContext parse(String text, ParsePosition position) {
        DateTimeFormatter.checkNotNull(text, "Text must not be null");
        DateTimeFormatter.checkNotNull(position, "ParsePosition must not be null");
        DateTimeParseContext context = new DateTimeParseContext(this.symbols);
        int pos = position.getIndex();
        pos = this.printerParser.parse(context, text, pos);
        if (pos < 0) {
            position.setErrorIndex(~pos);
            return null;
        }
        position.setIndex(pos);
        return context;
    }

    CompositePrinterParser toPrinterParser(boolean optional) {
        return this.printerParser.withOptional(optional);
    }

    public Format toFormat() {
        return new ClassicFormat();
    }

    public String toString() {
        String pattern = this.printerParser.toString();
        return pattern.startsWith("[") ? pattern : pattern.substring(1, pattern.length() - 1);
    }

    private class ClassicFormat
    extends Format {
        private static final long serialVersionUID = 1L;

        private ClassicFormat() {
        }

        @Override
        public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
            DateTimeFormatter.checkNotNull(obj, "Object to be printed must not be null");
            DateTimeFormatter.checkNotNull(toAppendTo, "StringBuffer must not be null");
            DateTimeFormatter.checkNotNull(pos, "FieldPosition must not be null");
            if (!(obj instanceof Calendrical)) {
                throw new IllegalArgumentException("DateTimeFormatter can format Calendrical instances");
            }
            pos.setBeginIndex(0);
            pos.setEndIndex(0);
            DateTimeFormatter.this.print((Calendrical)obj, toAppendTo);
            return toAppendTo;
        }

        @Override
        public Object parseObject(String source) throws ParseException {
            try {
                return DateTimeFormatter.this.parse(source);
            }
            catch (CalendricalParseException ex) {
                throw new ParseException(ex.getMessage(), ex.getErrorIndex());
            }
        }

        @Override
        public Object parseObject(String source, ParsePosition pos) {
            DateTimeParseContext context = DateTimeFormatter.this.parse(source, pos);
            return context != null ? context.toCalendricalMerger().merge() : null;
        }
    }
}

