/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar.format;

import java.io.IOException;
import java.util.Locale;
import javax.time.calendar.Calendrical;
import javax.time.calendar.Chronology;
import javax.time.calendar.format.DateTimeFormatSymbols;
import javax.time.calendar.format.DateTimeFormatter;
import javax.time.calendar.format.DateTimeFormatterBuilder;
import javax.time.calendar.format.DateTimeFormatterProviderImpl;
import javax.time.calendar.format.DateTimeParseContext;
import javax.time.calendar.format.DateTimeParser;
import javax.time.calendar.format.DateTimePrinter;

final class LocalizedPrinterParser
implements DateTimePrinter,
DateTimeParser {
    private final DateTimeFormatterBuilder.FormatStyle dateStyle;
    private final DateTimeFormatterBuilder.FormatStyle timeStyle;
    private final Chronology chronology;

    LocalizedPrinterParser(DateTimeFormatterBuilder.FormatStyle dateStyle, DateTimeFormatterBuilder.FormatStyle timeStyle, Chronology chronology) {
        this.dateStyle = dateStyle;
        this.timeStyle = timeStyle;
        this.chronology = chronology;
    }

    @Override
    public void print(Calendrical calendrical, Appendable appendable, DateTimeFormatSymbols symbols) throws IOException {
        this.formatter(symbols.getLocale()).toPrinterParser(false).print(calendrical, appendable, symbols);
    }

    @Override
    public boolean isPrintDataAvailable(Calendrical calendrical) {
        return true;
    }

    @Override
    public int parse(DateTimeParseContext context, String parseText, int position) {
        return this.formatter(context.getLocale()).toPrinterParser(false).parse(context, parseText, position);
    }

    private DateTimeFormatter formatter(Locale locale) {
        return new DateTimeFormatterProviderImpl().getFormatter(this.dateStyle, this.timeStyle, locale, this.chronology);
    }

    public String toString() {
        return "Localized(" + (this.dateStyle != null ? this.dateStyle : "") + "," + (this.timeStyle != null ? this.timeStyle : "") + "," + this.chronology.getName() + ")";
    }
}

